// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 06/17/2007
//  -------------------------------------------------------------
//  File Name : InitHardware.c
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Initializes all Hardware used
// ***************************************************************

#include "Globals.h"
#include "InitHardware.h"

void IOInit(void)
{
	//Configure all Port IOs
	//Port Descriptions
	//					Port B:					Port C:					Port D:
	//Bit 0:			Segment2				SensorTop				Segment a
	//Bit 1:			Segment3				SensorBottom			Segment	b
	//Bit 2:			Segment4				Motor					Segment c
	//Bit 3:			SegmentLeds				SW1						Segment	d
	//Bit 4:			Heater					SW2						Segment e
	//Bit 5:			N/A(SCK)				Buzzer					Segment f
	//Bit 6:			Segment1				N/A (RST)				Segment g
	//Bit 7:			SW3						N/A						SW4

	//On AVRs all Data Direction Registers are set to Output on 1, and to Input on 0 (weired isnt it)
	
	//Set Port Data Direction Register
	DDRB = 0b01011111;
	DDRC = 0b00100100;
	DDRD = 0b01111111;

	//Set Port Output Values
	PORTB = 0b10000000;	
	PORTC = 0b00111000;
	PORTD = 0b11111111;

	//Setup Timers
	TCCR0 = 0b00000101;		//Set Prescaler to 1024 -> 8Mhz equals to 128s -> 8 cycles to reach 1ms Timer
	TCNT0 = TIMER0_RELOAD;	//Trigger Interrupt every 8 Cycles
	TIMSK = 0b00000001;		//Enable IRQ for Timer0
	SREG  = 0b10000000;		//Global IRQ Enable
	
}
