// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 06/17/2007
//  -------------------------------------------------------------
//  File Name : Interrupts.c
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Handles all Interrupt routines
// ***************************************************************

#include "Globals.h"

void SetLEDS(BYTE p_LEDS);

// Knight Rider ;-) live on stage
typedef struct ledstate_ 
{
	BYTE ledcounter;
	BYTE direction : 1;
	BYTE rightzero : 1;
	BYTE leftzero : 1;
}ledstate;

static unsigned int dutycycle=0;
static ledstate _ledstate = {0x80,0};
// ADC conversion complete Interrupt
ISR(ADC_vect)
{
	WORD result = (WORD)ADCL;
	result |= ((WORD)ADCH)<<8;
	StoreADCSample(result);
}


// Timer/Counter1 Overflow
ISR(TIMER0_OVF_vect)
{
	//static int beep=0;
	TCNT0 = TIMER0_RELOAD;
	dutycycle++;
	//Drives 7 Segments
	SegmentShow();
	if(dutycycle&1)
		//Samples key inputs
		SampleSwitches();
	if((dutycycle&0x1f) == 0x1f)	//Modulo eats up to much CPU Power
	{
		//Select Channel and Start Single ended Conversion-> Left bit of 0x20 does toggle on every entry
		if(dutycycle&0x20)
			SetADCChannel(1);
		else
			SetADCChannel(0);
	}
 	if(!(dutycycle%52))
	{		
 		SetLEDS(_ledstate.ledcounter);
		if(!(_ledstate.direction))
		{
			_ledstate.ledcounter>>=1;
			if(_ledstate.ledcounter==0x7f)
			{
				_ledstate.rightzero=1;
			}
			else if(_ledstate.ledcounter==1)
			{
				_ledstate.direction=1;
			}
			else
			{
				if(!_ledstate.rightzero)
					_ledstate.ledcounter|=0x80;
			}
		}
		else
		{
			_ledstate.ledcounter<<=1;
			if(_ledstate.ledcounter==0x7e)
			{
				_ledstate.rightzero=0;
			}
			else if(_ledstate.ledcounter==0xc0)
			{
				_ledstate.direction=0;
			}
			else
			{
				if(_ledstate.rightzero)
					_ledstate.ledcounter|=0x01;
			}
		}
		
	}
	if(!(dutycycle%250))
		SegmentScrollString();
	Beat=1;			//Triggers Application run
}

// Timer/Counter2 Overflow
ISR(TIMER1_OVF_vect)
{

}

