// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 08.11.2007
//  -------------------------------------------------------------
//  File Name : SegmentDriver.h
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Definitions for 7 Segment Block
// ***************************************************************


// ***************************************************************
// Usage in File where it is used 
// static BYTE DisplayBuffer[SEGMENTBLOCKSIZE];
// ...
// InitSegmentBuffer();
// ...
// while(1)
// {
//	 ...
//   SegmentShow();			//Blits Segments one by one 
//   ...
// }
//
// interrupt routine
// ***************************************************************

#ifndef __SEGMENTDRIVER__
#define __SEGMENTDRIVER__

#include "Globals.h"

#define SEGMENTBLOCKSIZE 5			//Defines the Size
#define SEGMENTBLOCK_DRIVE PORTD	//Segments a-f	 (Drive for NPN)
#define SEGMENTBLOCK_ACTOR PORTB	//Segment Digits (Drive for PNP)

//7 Segments a-f Mask Values
#define SEGMENT_DRIVE_NODOT	0x80	//Excludes Dot on PD7

//7 Segment Digit Mask Values reside in Table if not continous
#define SEGMENTBLOCK_DIGIT0 0x40	//Connected to PB6
#define SEGMENTBLOCK_DIGIT1 0x02	//Connected to PB0
#define SEGMENTBLOCK_DIGIT2 0x01	//Connected to PB1
#define SEGMENTBLOCK_DIGIT3 0x04	//Connected to PB2
#define SEGMENTBLOCK_LEDS   0x08	//Connected to PB3

//7 Segment Auxillaries
#define NONE 0
#define RIGHT 1
#define LEFT 2

typedef struct _displaybuffer
{
	BYTE bufferlock : 1;			//Buffer is not
	char *buffer ;					//Pointer to SRAM Location
	BYTE startindex;				//Where to start on String
	BYTE scroll		: 5;			//0 scrolls infinite
	BYTE done		: 1;			//if scrolling finished bit is set
	BYTE direction	: 2;			//LEFT, RIGHT, NONE
} chardisplaybuffer;

//Function Prototypes
//used in Program to display Strings on 7 Segment Block
void DisplayStringFlash(PGM_P p_flashstring, ...);

//LEDS are lit accordingly to Bit0-6
void SetLEDS(BYTE p_LEDS);
//Initialize 7Segment Display
void InitDisplay(void);
//Gets Display Buffer for manipulation 
void GetDisplayBuffer(chardisplaybuffer** p_displaybuffer);
//Function needs to be placed somewhere free to loop 
void SegmentShow(void);							
//Sets the position of the String and a Window will be displayed xxxxx[0123]xxxxx
void SetScrollIndex(BYTE p_scrollindex);
//Shows String on 7 Segment Display
void SegmentScrollString(void);
//Show Flash String on 7 Segment Display
void SegmentScrollStringFlash(PGM_P p_string,BYTE dir);

#endif /*__SEGMENTDRIVER__*/
