// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 08.11.2007
//  -------------------------------------------------------------
//  File Name : Switches.c
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Shows a Character on a single 7 Segment Block
// ***************************************************************
// Remarks: Need Standard Data Types defined in Globals.h
// ***************************************************************

#include "switches.h"

static switchsamplestate switchstate;
static switchstates topleft		=	{0,0,0,0,SWITCHPIN_TOPLEFT,SWITCHBIT_TOPLEFT};
static switchstates bottomleft		=	{0,0,0,0,SWITCHPIN_BOTTOMLEFT,SWITCHBIT_BOTTOMLEFT};
static switchstates topright		=	{0,0,0,0,SWITCHPIN_TOPRIGHT,SWITCHBIT_TOPRIGHT};
static switchstates bottomright	=	{0,0,0,0,SWITCHPIN_BOTTOMRIGHT,SWITCHBIT_BOTTOMRIGHT};
static switchstates* switches[4];

void InitSwitchSampling(void)
{	
	switches[0] = &topleft;
	switches[1] = &bottomleft;
	switches[2]	= &topright;
	switches[3] = &bottomright;
}

//Samples all buttons and debounces them
void SampleSwitches(void)
{	
	BYTE bit = 0;
	BYTE pin = 0;
	switchstates *button = (switchstates*)switches[switchstate.switchcount];

	//Check if button is pressed
	bit=(1<<button->bit);	//need less space in SRAM bit 7 turns to 0x80
	pin=button->pin;
	pin = ~(_SFR_IO8(pin)); //switch is grounded if pressed
	if(pin & bit)
	{
		//Ok Pressed
		//Check if button is kept pressed
		if(button->ispressed)
		{
			if(button->presscount<255)
				button->presscount++;		//Yes is pressed count up 
			if(button->presscount>3 && button->presscount<150)
				PORTC|=_BV(5);			//Beep off
			if(button->presscount>150 && button->presscount<175)
				PORTC&=~_BV(5);			//Beep
			if(button->presscount>175)
				PORTC|=_BV(5);			//Beep off
		}
		else
		{
			button->ispressed=1;			//memorize that button is pressed
			PORTC&=~_BV(5);					//Beep
		}
	}
	else
	{
		//check if button was pressed to take further action
		if(button->ispressed)
		{
			//ok -> forget that 
			button->ispressed=0;
			//Check how long it was pressed
			BYTE buttoncount = button->presscount;
			if((buttoncount > 1) && (buttoncount < 150))
				button->pressed=1;
			else if(buttoncount>150)
				button->pessedLong=1;
			button->presscount=0;
			PORTC|=_BV(5);			//Beep off
			
		}
	}
	switchstate.switchcount++;
	if(switchstate.switchcount==SWITCHCOUNT)
		switchstate.switchcount=0;
}

//Process Buttons returns a BYTE which has following encoding
//				 MSB 0000 0000 LSB
//					 |||| ||||
//	   press type <- 3210 3210 -> button number
//	HighNibble holds long or short press of buttons			
//	LowNibble hold buttons pressed
BYTE ProcessButtons(void)
{
	BYTE buttons=0;
	//disabling button sampling
	if(switchstate.simulpress>1)
		return 0;
	//walk through all buttons and see what we have got
	for(BYTE i=0;i<SWITCHCOUNT;i++)
	{
		switchstates *button=switches[i];
		//if simultaneous buttons were pressed exit here and wait 
		if(button->ispressed)			
			return 0;				//-> exit here
		BYTE pressedstate=0;
		if(button->pressed)
		{
			pressedstate = (1 << i);
			button->pressed=0;
		}
		if(button->pessedLong)
		{
			pressedstate |= (1<< (i+4));
			button->pessedLong=0;
		}
		//write to buttons which is being returned
		buttons |=pressedstate;
	}

	return buttons;
}

