// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 08.11.2007
//  -------------------------------------------------------------
//  File Name : Switches.h
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Switch debouncing
// ***************************************************************

#ifndef __SWITCHES__
#define __SWITCHES__

#include "Globals.h"

#define SWITCHCOUNT					4		//Total number of sampable single switches (no matrix)

#define SWITCHBIT_TOPLEFT			3
#define SWITCHPIN_TOPLEFT			0x13	//#define PINC _SFR_IO8(0x13)
#define	BUTTON_TOPLEFT_SHORT		0x04	//Maskable Bitvalue what is beeing returned by ProcessButtons()
#define	BUTTON_TOPLEFT_LONG			0x40	//Maskable Bitvalue what is beeing returned by ProcessButtons()

#define SWITCHBIT_BOTTOMLEFT		4
#define SWITCHPIN_BOTTOMLEFT		0x13	
#define	BUTTON_BOTTOMLEFT_SHORT		0x08	//Maskable Bitvalue what is beeing returned by ProcessButtons()
#define	BUTTON_BOTTOMLEFT_LONG		0x80	//Maskable Bitvalue what is beeing returned by ProcessButtons()

#define SWITCHBIT_TOPRIGHT			7
#define SWITCHPIN_TOPRIGHT			0x16	//#define PINB _SFR_IO8(0x16)
#define	BUTTON_TOPRIGHT_SHORT		0x01	//Maskable Bitvalue what is beeing returned by ProcessButtons()
#define	BUTTON_TOPRIGHT_LONG		0x10	//Maskable Bitvalue what is beeing returned by ProcessButtons()

#define SWITCHBIT_BOTTOMRIGHT		7
#define SWITCHPIN_BOTTOMRIGHT		0x10	//#define PIND _SFR_IO8(0x10)
#define	BUTTON_BOTTOMRIGHT_SHORT	0x02	//Maskable Bitvalue what is beeing returned by ProcessButtons()
#define	BUTTON_BOTTOMRIGHT_LONG		0x20	//Maskable Bitvalue what is beeing returned by ProcessButtons()

typedef struct _swichsamplestate
{
	BYTE switchcount : 4;		//represents switch which is currently sampled
	BYTE simulpress  : 2;
} switchsamplestate;

typedef struct _switchstate
{
	BYTE pressed	: 1;		//shortpress is defined with 100ms up
	BYTE pessedLong	: 1;		//longpress is defined with 250ms up
	BYTE ispressed	: 1;		//checks if button is still pressed
	BYTE presscount : 8;		//counts up to 255 -> fairly enough
	BYTE pin		: 5;		//0x1x highest value
	BYTE bit		: 3;		//max 7

} switchstates;

//Function Prototypes
//Initialize all Buttons before making use of SampleSwitches
void InitSwitchSampling(void);
//Function needs to be placed in an IRQ routine where it can run continously 
void SampleSwitches(void);
//Function returns all values of buttons pressed
BYTE ProcessButtons(void);

#endif	/*__SWITCHES__*/
