/*------------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Commando Interpreter
------------------------------------------------------------------------------*/

#include "cmd.h"

volatile unsigned int variable[MAX_VAR];
char cmd_buffer[40];

CMD_ITEM CMD_TABLE[] = // Befehls-Tabelle
{
	{"RESET",command_reset},
	{"ARP",command_arp},
	{"TCP",command_tcp},
	{"IP",command_ip},
	{"NET",command_net},
	{"ROUTER",command_router},
	{"NTP",command_ntp},
	{"MAC",command_mac},
	{"VER",command_ver},
	{"SV",command_setvar},
	{"TIME",command_time},
#if HELPTEXT
	{"HELP",command_help},
	{"?",command_help},
#endif
	{NULL,NULL} 
};

#if HELPTEXT
	PROGMEM char helptext[] = {
		"RESET  - reset the AVR - Controller\r\n"
		"ARP    - list the ARP table\r\n"
		"TCP    - list the tcp table\r\n"
		"IP     - list/change ip\r\n"
		"NET    - list/change netmask\r\n"
		"ROUTER - list/change router ip\r\n"
		"NTP    - list/change NTP\r\n"
		"MAC    - list MAC-address\r\n"
		"VER    - list enc version number\r\n"
		"SV     - set variable\r\n"
		"TIME   - get time\r\n"
		"HELP   - print Helptext\r\n"
		"?      - print Helptext\r\n"
	};
#endif

//------------------------------------------------------------------------------
//Zeichenprfung auf Trennzeichen
unsigned char is_space (char ch)
{
	
	return (ch == ' ' || ch == ',' || ch == '.');
}

//------------------------------------------------------------------------------
//Nchstes Trennzeichen suchen und String abschliessen
char* cmd_skip_chars(char *sptr)
{
	while (*sptr && !is_space(*sptr)) sptr++;
	if (*sptr) // Wenn noch kein Stringende erreicht ist,
		*sptr++ = 0; // dann String mit 0 abschliessen und Zeiger erhhen
	return sptr;
}

//------------------------------------------------------------------------------
//Commando auswerten
unsigned char cmd_exec(char *pstr)
{
	//Stringzeiger;
	char *ps;
	unsigned char cmd_index = 0; // Befehlsindex
 
	//Anfangsposition von Token in ps speichern
	ps = pstr;  
	//Stringende suchen und abschliessen
	pstr = cmd_skip_chars(pstr);

	usart_write("\r\n");
	//Stringvergleich mit Befehlsliste durchfhren
	while (CMD_TABLE[cmd_index].cmd && strcasecmp(CMD_TABLE[cmd_index].cmd,ps)) cmd_index++;
	// Wenn Befehlsindex zu gross, dann mit Fehler beenden
	if (!CMD_TABLE[cmd_index].cmd) return(0);  
	
	for (unsigned char a = 0; a<MAX_VAR;a++)
	{
		ps = pstr;
		pstr = cmd_skip_chars(pstr);
		variable[a] = atoi(ps);
	}

	CMD_TABLE[cmd_index].fp(); // Befehl ausfhren und Ergebnis zurckgeben
	return(1); 
}

//------------------------------------------------------------------------------
//Reset ausfhren
void command_reset (void)
{
	RESET();
}

//------------------------------------------------------------------------------
//print/edit own IP
void command_ip (void)
{
	write_eeprom_ip(IP_EEPROM_STORE);
	(*((unsigned long*)&myip[0])) = get_eeprom_value(IP_EEPROM_STORE,MYIP);
	usart_write("My IP: %1i.%1i.%1i.%1i\r\n",myip[0],myip[1],myip[2],myip[3]);
}

//------------------------------------------------------------------------------
//
void write_eeprom_ip (unsigned int eeprom_adresse)
{
	if (*((unsigned int*)&variable[0]) != 0x00000000)
	{	
		//value ins EEPROM schreiben
		for (unsigned char count = 0; count<4;count++)
		{
			eeprom_busy_wait ();
			eeprom_write_byte((unsigned char *)(eeprom_adresse + count),variable[count]);
		}
	}
}

//------------------------------------------------------------------------------
//print/edit NTP Server IP
void command_ntp (void)
{
	write_eeprom_ip(NTP_IP_EEPROM_STORE);
	(*((unsigned long*)&ntp_server_ip[0])) = get_eeprom_value(NTP_IP_EEPROM_STORE,NTP_IP);
	usart_write("NTP_Server: %1i.%1i.%1i.%1i\r\n",ntp_server_ip[0],ntp_server_ip[1],ntp_server_ip[2],ntp_server_ip[3]);
}

//------------------------------------------------------------------------------
//print/edit Netmask
void command_net (void)
{
	write_eeprom_ip(NETMASK_EEPROM_STORE);
	(*((unsigned long*)&netmask[0])) = get_eeprom_value(NETMASK_EEPROM_STORE,NETMASK);
	usart_write("NETMASK: %1i.%1i.%1i.%1i\r\n",netmask[0],netmask[1],netmask[2],netmask[3]);
}

//------------------------------------------------------------------------------
//print/edit Router IP
void command_router (void)
{
	write_eeprom_ip(ROUTER_IP_EEPROM_STORE);
	(*((unsigned long*)&router_ip[0])) = get_eeprom_value(ROUTER_IP_EEPROM_STORE,ROUTER_IP);
	usart_write("Router IP: %1i.%1i.%1i.%1i\r\n",router_ip[0],router_ip[1],router_ip[2],router_ip[3]);
}

//------------------------------------------------------------------------------
//print own mac
void command_mac (void)
{
	usart_write("My MAC: %2x:%2x:%2x:%2x:%2x:%2x\r\n",mymac[0],mymac[1],mymac[2],mymac[3],mymac[4],mymac[5]);
}

//------------------------------------------------------------------------------
//print enc28j60 chip version
void command_ver (void)
{
#if USE_ENC28J60
	usart_write("ENC28J60-Version: %1x\r\n", enc28j60Read(EREVID));
#endif

#if USE_RTL8019
	usart_write("RTL8019 Ethernetcard\r\n");
#endif
}

//------------------------------------------------------------------------------
//print ARP table
void command_arp (void)
{
	for (unsigned char index = 0;index<MAX_ARP_ENTRY;index++)
	{
		usart_write("%2i  MAC:%2x",index,arp_entry[index].arp_t_mac[0]);
		usart_write(".%2x",arp_entry[index].arp_t_mac[1]);
		usart_write(".%2x",arp_entry[index].arp_t_mac[2]);
		usart_write(".%2x",arp_entry[index].arp_t_mac[3]);
		usart_write(".%2x",arp_entry[index].arp_t_mac[4]);
		usart_write(".%2x",arp_entry[index].arp_t_mac[5]);
		
		usart_write("  IP:%3i",(arp_entry[index].arp_t_ip&0x000000FF));
		usart_write(".%3i",((arp_entry[index].arp_t_ip&0x0000FF00)>>8));
		usart_write(".%3i",((arp_entry[index].arp_t_ip&0x00FF0000)>>16));
		usart_write(".%3i",((arp_entry[index].arp_t_ip&0xFF000000)>>24));
			
		usart_write("  Time:%4i\r\n",arp_entry[index].arp_t_time);
	}
}

//------------------------------------------------------------------------------
//print ARP table
void command_tcp (void)
{
	for (unsigned char index = 0;index<MAX_TCP_ENTRY;index++)
	{
		usart_write("%2i",index);
		usart_write("  IP:%3i",(tcp_entry[index].ip&0x000000FF));
		usart_write(".%3i",((tcp_entry[index].ip&0x0000FF00)>>8));
		usart_write(".%3i",((tcp_entry[index].ip&0x00FF0000)>>16));
		usart_write(".%3i",((tcp_entry[index].ip&0xFF000000)>>24));
		usart_write("  PORT:%4i",LBBL_ENDIAN_INT(tcp_entry[index].src_port));
		usart_write("  Time:%4i\r\n",tcp_entry[index].time);
	}
}

//------------------------------------------------------------------------------
//ndern einer Variable
void command_setvar (void)
{
	var_array[variable[0]] = variable[1];
	usart_write("Inhalt der Variable[%2i] = %2i\r\n",variable[0],var_array[variable[0]]);
}

//------------------------------------------------------------------------------
//print Time
void command_time (void)
{
	unsigned char hh = (time/3600)%24;
	unsigned char mm = (time/60)%60;
	unsigned char ss = time %60;
	usart_write ("\n\rTIME: %2i:%2i:%2i\r\n",hh,mm,ss);
}

//------------------------------------------------------------------------------
//print helptext
void command_help (void)
{
#if HELPTEXT
	unsigned char data;
	PGM_P helptest_pointer = helptext;
	
	do
	{
		data = pgm_read_byte(helptest_pointer++);
		usart_write("%c",data);
	}while(data != 0);
#endif
}








