/*------------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Commando Interpreter
------------------------------------------------------------------------------*/

#ifndef _CMD_H_
	#define _CMD_H_	
		
	//----------------------------------------------------------------------------
	#include <avr/io.h>
	#include <string.h>
	#include <stdlib.h>
	#include <avr/eeprom.h>
	#include "usart.h"
	#include "stack.h"
	#include "httpd.h"
	#include "ntp.h"
	
	//----------------------------------------------------------------------------	
	typedef struct
	{
		char* cmd; 				// Stringzeiger auf Befehlsnamen
		void(*fp)(void);  		// Zeiger auf auszufhrende Funktion
	} CMD_ITEM;	
	
	#define MAX_VAR	6
	#define HELPTEXT	1
	
	extern unsigned char cmd_exec(char *pstr);
	extern void write_eeprom_ip (unsigned int eeprom_adresse);
	
	//reset the unit
	extern void command_reset	(void);
	//Ausgabe der ARP Tabelle
	extern void command_arp 	(void);
	//Ausgabe der TCP Tabelle
	extern void command_tcp 	(void);
	
	//ndern/ausgabe der IP, NETMASK, ROUTER_IP, NTP_IP
	extern void command_ip 	(void);
	extern void command_net 	(void);
	extern void command_router	(void);
	extern void command_ntp 	(void);

	extern void command_mac	(void);
	extern void command_ver	(void);
	extern void command_setvar	(void);
	extern void command_time	(void);
	extern void command_help 	(void);
	
	#define RESET() {asm("ldi r30,0"); asm("ldi r31,0"); asm("ijmp");}
	
#endif //_CMD_H_


