/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        03.11.2007
 Description:    Webserver Config-File
----------------------------------------------------------------------------*/

#ifndef _CONFIG_H_
	#define _CONFIG_H_	

	//Umrechnung von IP zu unsigned long
	#define IP(a,b,c,d) ((unsigned long)(d)<<24)+((unsigned long)(c)<<16)+((unsigned long)(b)<<8)+a

	//IP des Webservers
	#define MYIP		IP(192,168,0,99)

	//Netzwerkmaske
	#define NETMASK		IP(255,255,255,0)
	
	//IP des Routers
	#define ROUTER_IP	IP(192,168,0,1)
	
	//IP des NTP-Servers z.B. Server 1.de.pool.ntp.org
	#define NTP_IP		IP(77,37,6,59)
	
	//MAC Adresse des Webservers	
	#define MYMAC1	0x00
	#define MYMAC2	0x20
	#define MYMAC3	0x18
	#define MYMAC4	0xB1	
	#define MYMAC5	0x15
	#define MYMAC6	0x6F
	
	//Quarz/Interner Takt oder Takt vom ENC28J60
	#define ENCTAKT 0 //0=Quarz/Intern 1=ENC28J60 Takt
	
	//Taktfrequenz
	#define SYSCLK 16000000UL	
	//#define SYSCLK 11059200UL
	
	//Timertakt intern oder extern
	#define EXTCLOCK 0 //0=Intern 1=Externer Uhrenquarz

	//Baudrate der seriellen Schnittstelle
	#define BAUDRATE 9600
	
	//ETH_M32_EX (www.ulrichradig.de)
	#define USE_ENC28J60	1
	//Holger Buss (www.mikrocontroller.com) Mega32-Board
	#define USE_RTL8019		0
	
	//Webserver mit Passwort? (0 == mit Passwort)
	#define HTTP_AUTH_DEFAULT	0
	
	//AUTH String "USERNAME:PASSWORT" max 14Zeichen 
	//fr Username:Passwort
	#define HTTP_AUTH_STRING "admin:uli1"
	
#endif //_CONFIG_H


