/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver Applikation
----------------------------------------------------------------------------*/

#ifndef _HTTPD_H
	#define _HTTPD_H
	
	#include <avr/io.h>
	#include <avr/pgmspace.h>
	#include "stack.h"
	#include "base64.h"
	
	#define MAX_VAR_ARRAY 10
	
	#define HTTP_OK_HEADER_LEN 87
	#define HTTP_AUTH_HEADER_LEN 129
	
	//#define HTTP_DEBUG	usart_write 
	#define HTTP_DEBUG(...)	
		
	unsigned int var_array[MAX_VAR_ARRAY];
	
	typedef struct
	{
		const char *filename;		//Dateiname der Seite
		PGM_P page_pointer; 	 	//Zeiger auf Speicherinhalt
	} WEBPAGE_ITEM;
	
	struct http_table
	{
		PGM_P old_page_pointer					;
		PGM_P new_page_pointer					;
		unsigned char *auth_ptr 				;
		unsigned char *hdr_end_pointer			;
		unsigned char http_auth 		: 1		;
		unsigned char http_header_type	: 1		;
		unsigned char first_switch		: 1		;
	};
	
	//Prototypen
	void httpd (unsigned char);
	void httpd_init (void);
	void httpd_stack_clear (unsigned char);
	void httpd_header_check (unsigned char);
	void httpd_data_send (unsigned char);
 
#endif //_HTTPD_H




