/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver uvm.
----------------------------------------------------------------------------*/

#include <avr/io.h>

#include "config.h"
#include "usart.h"
#include "networkcard/enc28j60.h"
#include "networkcard/rtl8019.h"
#include "stack.h"
#include "timer.h"
#include "httpd.h"
#include "cmd.h"
#include "telnetd.h"
#include "ntp.h"
#include "base64.h"
#include "http_get.h"

//----------------------------------------------------------------------------
//
int main(void)
{  
    unsigned long a;
	
    usart_init(BAUDRATE); // setup the UART
   
	usart_write("\n\rSystem Ready\n\r");
	for(a=0;a<1000000;a++){asm("nop");};

	//Applikationen starten
	stack_init();
	httpd_init();
	telnetd_init();
	
	
	PORTB |= (1<<PB2);
	
	//Ethernetcard Interrupt enable
	ETH_INT_ENABLE;
	//Globale Interrupts einschalten
	sei(); 
	
	ntp_init();
	ntp_request();
	
	for(a=0;a<2000000;a++){asm("nop");};
	
	//**************************************************
	//!!!!!!*************EXPERIMENTAL*************!!!!!!
	//http_request ();
		
	while(1)
	{
		tcp_socket_process();
		udp_socket_process();

		if (usart_status.usart_ready)
		{
			if(cmd_exec(&usart_rx_buffer[0]))
			{
				usart_write("Ready\r\n\r\n");
			}
			else
			{
				usart_write("ERROR\r\n\r\n");
			}
			usart_status.usart_ready =0;
		}
		
		//USART Daten fr Telnetanwendung?
		telnetd_send_data();	
    }
		
return(0);
}

