/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        12.11.2007
 Description:    NTP Client
----------------------------------------------------------------------------*/

#include "ntp.h"

//----------------------------------------------------------------------------
//
PROGMEM char  NTP_Request[] = {	0xd9,0x00,0x0a,0xfa,0x00,0x00,0x00,0x00,
									0x00,0x01,0x04,0x00,0x00,0x00,0x00,0x00,
									0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
									0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
									0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
									0xc7,0xd6,0xac,0x72,0x08,0x00,0x00,0x00,
									'%','E','N','D' };

unsigned char ntp_server_ip[4];

//----------------------------------------------------------------------------
//Initialisierung des NTP Ports (fr Daten empfang)
void ntp_init (void)
{
	//Port in Anwendungstabelle eintragen fr eingehende NTP Daten!
	add_udp_app (NTP_CLIENT_PORT, (void(*)(unsigned char))ntp_get);
	
	//NTP IP aus EEPROM auslesen
	(*((unsigned long*)&ntp_server_ip[0])) = get_eeprom_value(NTP_IP_EEPROM_STORE,NTP_IP);
	
	return;
}

//----------------------------------------------------------------------------
//Anforderung der aktuellen Zeitinformationen von einem NTP Server
void ntp_request (void)
{
	//oeffnet eine Verbindung zu einem NTP Server
	unsigned int byte_count;
		
	//ARP Request senden
	unsigned long tmp_ip = (*(unsigned long*)&ntp_server_ip[0]);
	if (arp_request(tmp_ip))
	{
		NTP_DEBUG("** NTP Request gesendet! **\r\n");
		
		//Interrupt Deaktivieren da Buffer gerade zum senden benutzt wird!
		ETH_INT_DISABLE;
		PGM_P ntp_data_pointer = NTP_Request;
		for (byte_count = 0;byte_count<(MTU_SIZE-(UDP_DATA_START));byte_count++)
		{
			unsigned char b;
			b = pgm_read_byte(ntp_data_pointer++);
			eth_buffer[UDP_DATA_START + byte_count] = b;
			//wurde das Ende des Packetes erreicht?
			//Schleife wird abgebrochen keine Daten mehr!!
			if (strncasecmp_P("%END",ntp_data_pointer,4)==0)
			{	
				byte_count++;
				break;
			}
		}
		
		create_new_udp_packet(byte_count,eth_buffer,NTP_CLIENT_PORT,NTP_SERVER_PORT,tmp_ip);
		ETH_INT_ENABLE;
		return;
	}
	NTP_DEBUG("Kein NTP Server gefunden!!\r\n");
	return;
}

//----------------------------------------------------------------------------
//Empfang der Zeitinformationen von einem NTP Server
void ntp_get (unsigned char index)
{
	NTP_DEBUG("** NTP DATA GET! **\r\n");
		
	struct NTP_GET_Header *ntp;
	ntp = (struct NTP_GET_Header *)&eth_buffer[UDP_DATA_START];

	ntp->rx_timestamp = LBBL_ENDIAN_LONG(ntp->rx_timestamp);
	ntp->rx_timestamp += GMT_TIME_CORRECTION; //  UTC +1h
	time = ntp->rx_timestamp;
	
	unsigned char hh = (time/3600)%24;
	unsigned char mm = (time/60)%60;
	unsigned char ss = time %60;
	
	NTP_DEBUG("\n\rNTP TIME: %2i:%2i:%2i\r\n",hh,mm,ss);
}








