/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver Applikation
----------------------------------------------------------------------------*/

#include "telnetd.h"
char *retransmission_pointer;

//----------------------------------------------------------------------------
//Initialisierung des telnetd Testservers
void telnetd_init (void)
{
	//Serverport und Anwendung in TCP Anwendungsliste eintragen
	add_tcp_app (23, (void(*)(unsigned char))telnetd);
}

//----------------------------------------------------------------------------
//telnet Testserver
void telnetd (unsigned char index)
{
	TELNET_DEBUG("TELNET Anwendung gestartet\r\n");
	
	if (tcp_entry[index].app_status == 0 || tcp_entry[index].app_status == 1)
	{
		tcp_entry[index].app_status = 1; 
		memmove(&eth_buffer[TCP_DATA_START],
				"Start Telnet Server:\r\n",22);
		create_new_tcp_packet(22,index);
		usart_status.usart_disable = 1;
		telnetd_status.ack_wait = 0;
		tcp_entry[index].time = TCP_TIME_OFF;
		return;
	}	

	if ((tcp_entry[index].app_status > 1) && (tcp_entry[index].status&PSH_FLAG))
	{
		tcp_entry[index].app_status = 2;	
		for (int a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{
			//Warten solange bis Zeichen gesendet wurde
			while(!(USR & (1<<UDRE)));
			//Ausgabe des Zeichens
			UDR = eth_buffer[a];
		}	
		tcp_entry[index].status =  ACK_FLAG;
		create_new_tcp_packet(0,index);
		return;
	}
	
	//Ack erhalten vom gesendeten Packet
	if ((tcp_entry[index].app_status > 1)&&(tcp_entry[index].status&ACK_FLAG)&&(telnetd_status.ack_wait))
	{
		tcp_entry[index].time = TCP_TIME_OFF;
		rx_buffer_pointer_out = retransmission_pointer;
		telnetd_status.ack_wait = 0;
		return;
	}
	
	//Time out kein ack angekommen
	if (tcp_entry[index].status == 0) 
	{
		//Daten nochmal senden
		telnetd_status.ack_wait = 0;
		telnetd_send_data ();
		return;
	}
	
	return;
}

//----------------------------------------------------------------------------
//telnet Testserver
void telnetd_send_data (void)
{
	unsigned char index;
	if (rx_buffer_pointer_in != retransmission_pointer)
	{
		for (index = 0;index<MAX_TCP_ENTRY;index++)
		{
			if(tcp_entry[index].dest_port == LBBL_ENDIAN_INT(23))
			{
				if(!telnetd_status.ack_wait)
					{
					ETH_INT_DISABLE;
					telnetd_status.ack_wait = 1;
					unsigned char count = 0;
					retransmission_pointer = rx_buffer_pointer_out; 
					
					while(rx_buffer_pointer_in != retransmission_pointer)
					{
						eth_buffer[TCP_DATA_START+count] = *retransmission_pointer++;
						count++;
						if (retransmission_pointer == &usart_rx_buffer[BUFFER_SIZE-1])
						{
							retransmission_pointer = &usart_rx_buffer[0];
						}
					}
					tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
					create_new_tcp_packet(count,index);
					tcp_entry[index].time = TCP_MAX_ENTRY_TIME;
					ETH_INT_ENABLE;
					return;
				}
				else
				{
				return;
				}
			}
		}
		if (index >= MAX_TCP_ENTRY)
		{
			if(usart_status.usart_disable)
			{
				usart_status.usart_disable = 0;
			}
		}
	}
}






