
#include "HTMLtools.h"

void responseClient()
{
  WiFiClient client = server.available();
  if (!client)
  {
    return;
  }
  // Wait until the client sends some data
  Serial.println("new client");
  
  unsigned long ultimeout = millis() + 250;
  while (!client.available() && (millis() < ultimeout) )
  {
    yield();
  }
  if (millis() > ultimeout)
  {
    Serial.println("client connection time-out!");
    return;
  }

  String sHeader, sRequest, sResponse; 

  // Read the first line of the request
  sRequest = client.readStringUntil('\r');
  client.flush();

  // stop client, if request is empty
  if (sRequest == "")
  {
    Serial.println("empty request! - stopping client");
    client.stop();
    return;
  }

#ifdef HTML_DEBUG
  Serial.println("Clientdaten");
  Serial.println(sRequest);
  Serial.println("Clientdaten Ende");
#endif

// sRequest enthält die Daten vom Client

  pageDaten.Path = "";                                             // Parameterarray löschen 
  for (int i = 0; i < MAX_PARAMETER; i++)
  {
    pageDaten.Index[i] = "";
    pageDaten.Value[i] = "";
  }

  // get path; end of path is either space or ?
  // Syntax is e.g. GET /{filename}?pin=MOTOR1STOP HTTP/1.1
  
  String sParam = "", sGetstart = "GET ", sPath;
  int iStartGet, iEndSpace, iEndQuest;
  
  iStartGet = sRequest.indexOf(sGetstart);                          // Position von 'GET ' im Puffer bestimmen
  if (iStartGet >= 0)
  {
    iStartGet += +sGetstart.length();                               // Zeiger auf Position hinter 'GET '
    iEndSpace = sRequest.indexOf(" ", iStartGet);                   // Position Leerzeichen hinter dem Pfad suchen
    iEndQuest = sRequest.indexOf("?", iStartGet);                   // Position ? hinter dem Pfad suchen falls Parameter
    if (iEndQuest > 0)                                              // Fragezeichen gefunden, also Parameter
    {
      sPath  = sRequest.substring(iStartGet, iEndQuest);             // Pfad extrahieren und merken
      if (sPath == "/")                                              // wenn ohne Dateinamen dann index.html als Default
      {
        sPath += "index.html";
      }
      sParam = sRequest.substring(iEndQuest, iEndSpace);             // Parameter extrahieren
      sParam.replace("?", "");                                       // Fragezeichen am Anfang entfernen

#ifdef HTML_DEBUG
      Serial.println("Parameter");
      Serial.println(sParam);
      Serial.println("");
#endif      
    
    }
    else                                                             // Leerzeichen am Ende, also nur Pfad 
    {
      sPath = sRequest.substring(iStartGet, iEndSpace);              // Pfad extrahieren und merken
      if (sPath == "/")                                              // wenn ohne Dateinamen dann index.html als Default
      {
        sPath += "index.html";
      }
    }
                                                                         
// sPath gesetzt, sParam gesetzt, wenn Parameter vorhanden
    ulReqcount++;                                                   // Anzahl Verbindungen

    Serial.print("Pfad ");
    Serial.println(sPath);

   if (!SPIFFS.exists(sPath))                                       // angeforderte Datei vorhanden?
    {
      sHeader = F("HTTP/1.1 404 Not found\r\nContent-Length: ~response-length~\r\nContent-Type: text/html\r\nConnection: close\r\n\r\n");
      sResponse = F("<html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL was not found on this server.</p></body></html>");

      // Send the response to the client      
      sHeader.replace("~response-length~", String(sResponse.length(),DEC));       // PayLoad Länge in Header eintragen

#ifdef HTML_DEBUG
        Serial.println("Header");
        Serial.println(sHeader);
#endif

      client.print(sHeader);
      client.print(sResponse);                            // maximal 2992 Zeichen...      
      client.stop();
      Serial.println("404 - Client disonnected");
      Serial.println("");    
    }
    else
    {
      sHeader = F("HTTP/1.1 200 OK\r\nContent-Length: ~response-length~\r\nContent-Type: ~content-typ~\r\nConnection: close\r\n\r\n");       
      File tempFile = SPIFFS.open(sPath, "r"); 
      int filelen = tempFile.size();                      // Dateilänge erstmal merken
      if (!sPath.endsWith(".html"))                           // nicht .html
      {
        sHeader.replace("~response-length~", String(filelen,DEC));       // PayLoad Länge in Header eintragen
        if (sPath.endsWith(".ico"))
        {
          sHeader.replace("~content-typ~","image/x-icon");    
        }
        else if (sPath.endsWith(".css"))
        {
          sHeader.replace("~content-typ~","text/css");    
        }
        else if (sPath.endsWith(".js"))
        {
          sHeader.replace("~content-typ~","application/javascript");    
        }
        else if (sPath.endsWith(".jpg"))
        {
          sHeader.replace("~content-typ~","image/jpg");    
        }
        else if (sPath.endsWith(".bin"))
        {
          sHeader.replace("~content-typ~","application/octet-stream");    
        }
        else                                                 // kein zulässiger Content-Typ   
        {
          sHeader = F("HTTP/1.1 406 Not Acceptable\r\nContent-Length: ~response-length~\r\nContent-Type: text/html\r\nConnection: close\r\n\r\n");
          sResponse = F("<html><head><title>406 Not Acceptable</title></head><body><h1>Not Acceptable</h1><p>Only HTML, CSS, JS, ICO, BIN</p></body></html>");

          // Send the response to the client      
          sHeader.replace("~response-length~", String(sResponse.length(),DEC));       // PayLoad Länge in Header eintragen

#ifdef HTML_DEBUG
          Serial.println("Header");
          Serial.println(sHeader);
#endif

          client.print(sHeader);
          client.print(sResponse);                            // maximal 2992 Zeichen...      
          client.stop();
          Serial.println("404 - Client disonnected");
          Serial.println("");              
        }
        
#ifdef HTML_DEBUG
        Serial.print("Header");
        Serial.println(sHeader);
#endif

        client.print(sHeader);
     
        // Send the response to the client
        char tempbuf[MAX_PAKET_LEN + 64];                            // Puffer zum Einlesen
        unsigned int anzread = 0;                                    // Anzahl gelesen Bytes in .readBytes
        unsigned int gesendet = 0;                                   // gesendete Bytes
          
        // Datei in Teilen zu MAX_PAKET_LEN Byte senden
        while ((filelen - gesendet) > 0)                              // nochwas zum Senden da?
        {
          anzread = tempFile.readBytes(tempbuf, MAX_PAKET_LEN);      // 2500 Bytes holen oder den Rest
          client.write(&tempbuf[0], anzread);               // geholte Bytes senden
          gesendet += anzread;                              // gesendete zum Zeiger hinzu
        }   
        tempFile.close();
        client.stop();

        Serial.print("gesendet: ");
        Serial.println(String(gesendet,DEC));
        Serial.println("Client disonnected\r\n");     
      }
      else                                                  // ist also .html
      {
        sHeader.replace("~content-typ~","text/html");       // Header anpassen    
        pageDaten.Path = sPath;                             // Pfad eintragen   

#ifdef HTML_DEBUG
        Serial.print(".html-File ");
        Serial.println(sHeader);
#endif

        pageDaten.Anzahl = 0;                               // Parameter auf 0   
        decodeParameter(sParam);                            // Parameterarray füllen
        
#ifdef REPLACE_DEBUG
        Serial.println("Parameter");
        Serial.print("Pfad: ");
        Serial.println(pageDaten.Path);
        for (int i=0; i<MAX_PARAMETER; i++)
        {
          if (i<10)
          {
            Serial.print(" ");     
          }
          Serial.print(i);
          Serial.print(" - ");     
          Serial.print(pageDaten.Index[i]);
          Serial.print(" # ");
          Serial.println(pageDaten.Value[i]);    
        }
        Serial.println("");

        Serial.println("Ersetzungen");
        for (int i=0; i<ANZ_REPLACE; i++)
        {
          if (i<10)
          {
            Serial.print(" ");     
          }
          Serial.print(i);
          Serial.print(" - ");
          Serial.print(char('a' + i));   
          Serial.print(" # ");
          Serial.println(index_array[i]);    
        }
        Serial.println("");
#endif
    
        useraction();                                   // Benutzerfunktion, die das Replace-Array entsprechend den Paramtern modifizieren kann  
        
        File tempFile = SPIFFS.open(sPath, "r");
        sResponse = tempFile.readString();
        tempFile.close();
        
        for (int i = 0; i < ANZ_REPLACE; i++)
        {
          String suchstring = "~" + String(char(i + 'a')) + "~";                            // nächsten Buchstaben setzen -> ~a~ ... bis ANZ_REPLACE
          sResponse.replace(suchstring, index_array[i]);
        }
       
        // Send the response to the client
        sHeader.replace("~response-length~", String(sResponse.length(),DEC) + 10);       // PayLoad Länge in Header eintragen

#ifdef HTML_DEBUG
        Serial.println("Header");
        Serial.println(sHeader);
#endif

        client.print(sHeader);

        // Send the response to the client   

#ifdef HTML_DEBUG
        Serial.print("Len: ");
        Serial.println(sResponse.length(),DEC);
        Serial.print("sResponse: ");
        Serial.println(sResponse);
        Serial.print("free Heap: ");
        Serial.println(ESP.getFreeHeap(),DEC);
#endif

        int datapos = 0;
        while (datapos < (sResponse.length()))                // senden bis alles raus, client.print buffer ist nur 2290 Byte groß
        {
          client.print(sResponse.substring(datapos, datapos + MAX_PAKET_LEN));
          datapos += MAX_PAKET_LEN;        
        }

        client.stop();

        // index_Array löschen
        for (int i=0; i<ANZ_REPLACE; i++)
        {
          index_array[i] = "";
        }
        Serial.println("Client disonnected");
        Serial.print("Request: ");
        Serial.print(String(ulReqcount));
        Serial.print(" # Reconnect: ");
        Serial.println(String(ulReconncount));
        Serial.println("");
      }  
    }
  }
  else
  {
    Serial.println("kein GET gefunden - stopping client");
    client.stop();
    return;
  }

}

// ----------------------------------------------------------------------

void decodeParameter(String sParam)
{
  // are there parameters?
  if (sParam.length() > 0)                                         // Parameter gefunden
  {
    String temp;
    int iStart = 0;
    int iEndSpace = 0;                                              // Position von '&' -> neuer Parameter
    int iEndQuest = 0;                                              // Position von '=' -> Trenner Name - Wert
    char anz = 0;                                                   // Index für Parameter-Array
    while (iEndSpace != -1)                                         // was gefunden
    {
      if (sParam.length() > 0)                                      // überhaupt was da?
      {
        iEndSpace = sParam.indexOf("&", iStart);                    // erstes & suchen
        iEndQuest = sParam.indexOf("=", iStart + 1);                // Suchen nach '=' ab Zeichen nach '&'
        if (iEndQuest > iStart)                                     // auch mit '=' drin?
        {
          pageDaten.Index[anz] = sParam.substring(iStart, iEndQuest);
          pageDaten.Value[anz] = sParam.substring(iEndQuest + 1, iEndSpace);
          pageDaten.Value[anz].trim();
          iStart = iEndSpace + 1;                                   // nur Startposition hinter dem gefundenen '&'
          anz++;                                                    // Arrayindex erhöhen
          if (anz == MAX_PARAMETER)
          {
              Serial.println("!!! Zuviel Parameter !!!");
            break;
          }
        }
        else
        {
          Serial.println("!!! Kein '=' gefunden !!!");
          break;
        }
      }
    }
    pageDaten.Anzahl = anz;
  }
  return;
}

// ----------------------------------------------------------------------

String decodeSpecialChar(String intext)
{
  int index;   

  intext.replace("%25", "~#~#~");                         // echte % ersetzen
  intext.replace("+"," ");                                // + durch Space ersetzen

  while((index = intext.indexOf("%")) != -1)              // % gefunden
  {
    char sonderzeichen[5];
    
    String temp = intext.substring(index, index+3);

    temp.toCharArray(sonderzeichen,4);

    char zeichen1 = (sonderzeichen[1] - '0');
    if (zeichen1 > 9)
    {
      zeichen1 -= 7; 
    }

    char zeichen2 = (sonderzeichen[2] - '0');
    if (zeichen2 > 9)
    {
      zeichen2 -= 7; 
    }
    char zeichen = (zeichen1 * 16) + zeichen2;
    
    intext.replace(temp, String(zeichen));   
  }
  intext.replace("~#~#~", "%");

  return intext;
}  

