/*
 * Decoding remote control ITW
 * 
 * tested on Arduino Uno
 * 
 * protocol:
 * start condition: >10ms low, short high, >2,5ms <3ms low
 * 33 data elements: 
 *  0: short high, long low
 *  1: short high, short low, short high, long low
 *  2: short high, short low, short high, long low, short high, long low
 *  
 */
#include <itwControl.h>

#define RXPIN     2   // Input Pin 2 is interrupt 0 

itwControl itw (RXPIN);


void setup() {
  Serial.begin ( 9600 );
  Serial.println ( "ITW Test 3" );
  attachInterrupt ( digitalPinToInterrupt(RXPIN), rxInterrupt, CHANGE ); 
}

void loop() {
  if ( itw.available() ) {
    Serial.println ( (char *)itw.getData() );
    itw.release();
  }
}

void rxInterrupt() {
  itw.rxInterrupt();
}


