#ifndef _ITWCONTROL_H
#define _ITWCONTROL_H

// value for keys
// not found until now, ideas:
// left switch ends with 31, right with 22 (idx 31 and 32)
// on is 12 on position 27 and 28, off is 21
// tested with two different switches ITW-852:
// first 12 data is always 213 213 123 123
// data 13 .. 26 (15 values) are switch specific
#define KEY_1ON     238
#define KEY_1OFF    255
#define KEY_1UP     245
#define KEY_1DOWN   228

#define KEY_2ON     108
#define KEY_2OFF    125
#define KEY_2UP     119
#define KEY_2DOWN   102

#define KEY_3ON     175
#define KEY_3OFF    190
#define KEY_3UP     180
#define KEY_3DOWN   165

#define KEY_4ON     45
#define KEY_4OFF    60
#define KEY_4UP     54
#define KEY_4DOWN   39

#define KEY_ALLUP   20
#define KEY_ALLDOWN  5
#define KEY_ALLON   15
#define KEY_ALLOFF  30

#define ITW_NUM     33  // number of data elements with value 1..3
// 33*1,5=50bits are needed to store the data
// 


class itwControl {
  public:
    itwControl( uint8_t pin = 2 );
    ~itwControl();
    uint8_t available();
    void release();
    uint16_t getLast();
    uint8_t getState();
    uint16_t getAddress();
    uint8_t getKey();
    volatile char *getData();
    const char *getKeyText ( uint8_t key );
    void rxInterrupt();

  private:
    volatile uint8_t _state;
    uint8_t _idx;
    volatile uint8_t _key;
    uint8_t _pin;
    volatile uint16_t _addr;
    volatile uint16_t _last;
    volatile char _dat[ITW_NUM+1]; // one more byte to terminate the string with 0
};

#endif

