/*
WL_NO_SHIELD = 255,
WL_IDLE_STATUS = 0,
WL_NO_SSID_AVAIL = 1
WL_SCAN_COMPLETED = 2
WL_CONNECTED = 3
WL_CONNECT_FAILED = 4
WL_CONNECTION_LOST = 5
WL_DISCONNECTED = 6

wl_tcp_state
  CLOSED      = 0,
  LISTEN      = 1,
  SYN_SENT    = 2,
  SYN_RCVD    = 3,
  ESTABLISHED = 4,
  FIN_WAIT_1  = 5,
  FIN_WAIT_2  = 6,
  CLOSE_WAIT  = 7,
  CLOSING     = 8,
  LAST_ACK    = 9,
  TIME_WAIT   = 10
*/

#define DEBUG

#define OTA_ON
 
#include <ESP8266WiFi.h>

#ifdef OTA_ON
#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>

#define HOSTNAME "OTA-WEBRADIO"                   // OTA-Hostename
#endif

#include "VS1003_Player.h"


#define DEFAULT_VOL  20
#define DEFAULT_BASS  0x56CE                      // 0xabcd a Höhen 1,5dB Schritte, Frequenz b 1000Hz Schritte, Bass c 1dB, Cut d 10Hz Schritte  

const char* ssid = "xxxxxxx";
const char* password = "xxxxxx";
//const char* host = "mp3channels.webradio.antenne.de";
//const int httpPort = 80;
//const char* streamId   = "/80er-kulthits";
const char* host = "192.168.0.99";
const int httpPort = 8000;
const char* streamId   = "/mpd";

WiFiClient iceclient;

void WiFiStart(void);
void IceConnect(void);

uint8_t AudioBuf[OUT_BUF_SIZE];
bool FILL_FLAG;                          // true wenn OUT_BUF_FILL gespielt wurden
bool EMPTY_FLAG;                         // Buffer ist leer
bool COPY_FLAG;                          // Ticker: Daten zum VS1003 schicken
bool PLAY_FLAG;                          // Player läuft

byte vol = DEFAULT_VOL;
uint16_t bass = DEFAULT_BASS;
int out_buf_counter = 0;                 // Zeiger für die Ausgabe and en VS1003  
int loop_counter = 0;                    // Buffer-Empty-Counter

void setup()
{
  Serial.begin(115200);
  Serial.println("\r\nRESET");

#ifdef OTA_ON
  // Set Hostname.
  String hostname(HOSTNAME);
  WiFi.hostname(hostname);
#endif

  mp3.Init();
  Serial.println("MP3 Init OK");
  
  // inital connect
  WiFi.mode(WIFI_STA);
  if (WiFi.status() != WL_CONNECTED)
  {   
    WiFiStart();
  }

#ifdef OTA_ON
  // Start OTA server.
  ArduinoOTA.setHostname((const char *)hostname.c_str());
  ArduinoOTA.begin();
#endif
    
  EMPTY_FLAG = true;
  IceConnect();                                                   // Streamserver connecten    
}

void loop()
{
  static int fill_pos = 0;
/*
  if (COPY_FLAG)
  {
    mp3.mp3PlayCallback();
  }
*/
   if (PLAY_FLAG)
   {
     if (digitalRead(DREQ) == HIGH)   // if VS1003 request data
     {    
       mp3.mp3PlayCallback();
     }
   }
   
  if (loop_counter > OUT_BUF_SIZE)                                 // Buffer ist leer
  {
    Serial.println("Buffer EMPTY!");
    loop_counter = 0;
    mp3.stopSong();
    EMPTY_FLAG = true;
    iceclient.stop();
    iceclient.flush();   
  }
  
  IceConnect();

  if (iceclient.available() > OUT_BUF_FILL)
  {
    if (FILL_FLAG)                                                 // Buffer kann nachgefüllt werden
    {
      iceclient.read(AudioBuf + fill_pos, OUT_BUF_FILL);
      FILL_FLAG = false;     
      loop_counter = 0;

      fill_pos += OUT_BUF_FILL;
      if (fill_pos == OUT_BUF_SIZE)                                // am Bufferende angekommen?
      {
        fill_pos = 0;
        if (out_buf_counter > OUT_BUF_FILL) 
        {
          FILL_FLAG = true;                                        // wenn noch mehr als OUT_BUF_FILL reinpaßt weiter einlesen
        }

#ifdef DEBUG
        if (FILL_FLAG)
        {
          Serial.print("FILL: true");        
        }
        else
        {
          Serial.print("FILL: false");        
        }
        Serial.print(" - Out-Count: :");

        Serial.println(out_buf_counter,DEC);       
#endif

      }
     
    }
  }

#ifdef OTA_ON
  ArduinoOTA.handle();                                             // Handle OTA server.
#endif

}

// ----------------------------------------------------------------------

void WiFiStart()
{
  WiFi.disconnect();
  delay(10);
  
  // Connect to WiFi network
  WiFi.begin(ssid, password);

  Serial.println("WiFi connect");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(500);
  }
  Serial.println("connected");
  IPAddress myAddr = WiFi.localIP();
  Serial.println(myAddr);
  Serial.print("RSSI: ");
  Serial.print(WiFi.RSSI(), DEC);
  Serial.println("dBm"); 
}

// ----------------------------------------------------------------------

void IceConnect()
{
  if (!iceclient.connected())
  {
    if (WiFi.status() != WL_CONNECTED)
    {   
      WiFiStart();
    }
    if (!iceclient.connect(host, httpPort))
    {
      Serial.println("connection failed");
    }
    else
    {
      String url = streamId;
 
      Serial.print("Requesting URL: ");
      Serial.println(url);
 
      // This will send the request to the server
      iceclient.print(String("GET ") + url + " HTTP/1.1\r\n" +
                      "Host: " + host + "\r\n\r\n");
    }
    if (iceclient.status() == ESTABLISHED)
    {
      Serial.println("ICEclient connected");
      if (EMPTY_FLAG)
      {
        Serial.print("Buffer fill");
        for (int i=0; i<OUT_BUF_ANZ; i++)
        {
          while (iceclient.available() < OUT_BUF_FILL + 1)
          {
            yield();
          }
          iceclient.read(AudioBuf + (OUT_BUF_FILL * i), OUT_BUF_FILL);              // Buffer erstmal komplett füllen
          Serial.print("-");
        }
        Serial.println("");   
        Serial.println("Buffer OK");   

        mp3.setBass(bass); // VOL
        mp3.setVolume(vol); // VOL
//        mp3.showRegister();
        mp3.startSong();                                                 // Start Play
        Serial.println("Start...");
        EMPTY_FLAG = false;
      }
    }
  }
}

// ----------------------------------------------------------------------

