
#include "VS1003_Player.h"

VS1003 mp3;

String reg_namen[] = {"SCI_MODE","SCI_STATUS","SCI_BASS","SCI_CLOCKF","SCI_DECODE_TIME","SCI_AUDATA","SCI_WRAM","SCI_WRAMADDR","SCI_HDAT0","SCI_HDAT1","SCI_AIADDR","SCI_VOL","SCI_AICTRL0","SCI_AICTRL1","SCI_AICTRL2","SCI_AICTRL3"}; 

void VS1003::Callback()
{
    COPY_FLAG = true;
//  mp3.mp3PlayCallback();
}

void VS1003::mp3PlayCallback()
{
  data_mode_on();
  while(digitalRead(DREQ) == HIGH)       // if VS1003 request data 
  {
    SPI.transfer(AudioBuf[out_buf_counter]); //send data
    out_buf_counter++;
    loop_counter++;
    
    if (out_buf_counter == OUT_BUF_SIZE)
    {
      out_buf_counter = 0;                              // von vorne         
    }

    if (out_buf_counter%OUT_BUF_FILL == 0)              // der nächste Block kann nachgefüllt werden. 
    {
      FILL_FLAG = true;
    }
  }
  data_mode_off();
  COPY_FLAG = false;
}

//-------------- Play-Funktionen ---------------

void VS1003::setVolume(byte volume)
{
  uint16_t value = volume;
  value <<= 8;
  value |= volume;
  write_register(SCI_VOL,value); // VOL
}

//-----------------------------------------------


void VS1003::setBass(uint16_t bass)
{
    write_register(SCI_BASS,bass);
}

//-----------------------------------------------

void VS1003::startSong(void)
{
  mp3PlayCallback();
//  attachInterrupt(digitalPinToInterrupt(DREQ), Callback, RISING);  // Daten bei High schicken
//  COPY_FLAG = true;
  PLAY_FLAG = true;
}

//-----------------------------------------------

void VS1003::stopSong(void)
{
//  detachInterrupt(digitalPinToInterrupt(DREQ));
  PLAY_FLAG = false;
  sdi_send_zeroes(2048);
  write_register(SCI_VOL,0xfefe); // VOL 
  write_register(SCI_MODE, (1<<SM_SDINEW) | (1<<SM_RESET)); 
  delay(10);
}

//------------------------------------------------

void VS1003::Init(void)
{
  pinMode(RESET,OUTPUT);
  digitalWrite(RESET,LOW);

  pinMode(CS,OUTPUT);
  digitalWrite(CS,HIGH);

  pinMode(DCS,OUTPUT);
  digitalWrite(DCS,HIGH);

  // DREQ is an input
  pinMode(DREQ,INPUT);

  // initiate SPI
  SPI.begin();
  SPI.beginTransaction(SPISettings(1000000, MSBFIRST, SPI_MODE0));       
  Serial.println("SPI init OK");
  
  // Boot VS1003
  Serial.println("Booting VS1003...");
  digitalWrite(RESET,HIGH);
  delay(10);

  /* Declick: Slow sample rate for slow analog part startup */
  write_register(SCI_VOL,0xffff); // VOL auf 0
  write_register(SCI_AUDATA,10);
  delay(100);
  /* Switch on the analog parts */
  write_register(SCI_VOL,0xfefe); // VOL 
 
  Serial.println("VS1003 Init...");
  write_register(SCI_AUDATA,44101); // 44.1kHz stereo
  
  // soft reset
  write_register(SCI_MODE, (1<<SM_SDINEW) | (1<<SM_RESET));     // ##### Mode ???
  delay(10);
  await_data_request();  
  write_register(SCI_CLOCKF,0xB800);                            // Experimenting with higher clock settings 0x8000
  delay(10);
  await_data_request();

  // Now you can set high speed SPI clock
  SPI.setFrequency(6000000);                                    // ####### SPI Speed
  Serial.println("SPI High-Speed");
  
  Serial.println("VS1003 OK\r\n");
}

//-------------- VS1003-Funktionen ---------------

void VS1003::Reset_VS1003(void)
{
    digitalWrite(RESET,LOW);
    delay(500);
    digitalWrite(RESET,HIGH);
    delay(500);
}

//------------------------------------------------

void VS1003::showRegister(void)
{
  Serial.println("VS1003 Configuration:");
  int i = 0;
  while (i < SCI_num_registers)
  {
    String tempname = reg_namen[i] + ":           ";
    String outstring = tempname.substring(0,18);
    Serial.print(outstring);
    int temp = read_register(i);
    if (temp < 0x1000)
    {
      Serial.print("0");
    }
    if (temp < 0x0100)
    {
      Serial.print("0");
    }
    if (temp < 0x0010)
    {
      Serial.print("0");
    }
    Serial.println(temp,HEX);
    i++;
  }
  Serial.println("");
}

/****************************************************************************/

uint16_t VS1003::read_register(uint8_t _reg)
{
  uint16_t result;
  control_mode_on();
  delayMicroseconds(1); // tXCSS
  SPI.transfer(VS_READ_COMMAND); // Read operation
  SPI.transfer(_reg); // Which register
  result = SPI.transfer(0xff) << 8; // read high byte
  result |= SPI.transfer(0xff); // read low byte
  delayMicroseconds(1); // tXCSH
  await_data_request();
  control_mode_off();
  return result;
}

/****************************************************************************/

void VS1003::write_register(uint8_t _reg, uint16_t _value)
{
  control_mode_on();
  delayMicroseconds(1); // tXCSS
  SPI.transfer(VS_WRITE_COMMAND); // Write operation
  SPI.transfer(_reg); // Which register
  SPI.transfer(_value >> 8); // Send hi byte
  SPI.transfer(_value & 0xff); // Send lo byte
  delayMicroseconds(1); // tXCSH
  await_data_request();
  control_mode_off();
}

/****************************************************************************/

void VS1003::sdi_send_zeroes(size_t len)
{
  data_mode_on();
  while (len > 0)
  {
    await_data_request();
    SPI.transfer(0);
    len--;
  }
  data_mode_off();
}

/****************************************************************************/

