
#ifndef VS1003_h
#define VS1003_h

#include "SPI.h"
#include "FS.h"

//definitions
#define OUT_BUF_SIZE 20480
#define OUT_BUF_ANZ 10
#define OUT_BUF_FILL 2048
                                           
//#define MOSI 13                                // SPI Hardware Standard-Config
//#define MISO 12
//#define SCLK 14

#define CS     4                                 // CS für Daten
#define DCS    5                                 // CS für Command
#define DREQ   2
#define RESET 16

#define VS_WRITE_COMMAND 0x02
#define VS_READ_COMMAND  0x03

// SCI Registers
#define SCI_MODE          0x0
#define SCI_STATUS        0x1
#define SCI_BASS          0x2
#define SCI_CLOCKF        0x3
#define SCI_DECODE_TIME   0x4
#define SCI_AUDATA        0x5
#define SCI_WRAM          0x6
#define SCI_WRAMADDR      0x7
#define SCI_HDAT0         0x8
#define SCI_HDAT1         0x9
#define SCI_AIADDR        0xa
#define SCI_VOL           0xb
#define SCI_AICTRL0       0xc
#define SCI_AICTRL1       0xd
#define SCI_AICTRL2       0xe
#define SCI_AICTRL3       0xf
#define SCI_num_registers 16

// SCI_MODE bits
#define SM_DIFF           0
#define SM_LAYER12        1
#define SM_RESET          2
#define SM_OUTOFWAV       3
#define SM_EARSPEAKER_LO  4
#define SM_TESTS          5
#define SM_STREAM         6
#define SM_EARSPEAKER_HI  7
#define SM_DACT           8
#define SM_SDIORD         9
#define SM_SDISHARE      10
#define SM_SDINEW        11
#define SM_ADPCM         12
#define SM_ADCPM_HP      13
#define SM_LINE_IN       14

extern uint8_t AudioBuf[OUT_BUF_SIZE];
extern bool FILL_FLAG;                          // true wenn OUT_BUF_FILL gespielt wurden
extern bool COPY_FLAG;                          // Ticker: Daten zum VS1003 schicken
extern bool PLAY_FLAG;                          // Player läuft

extern int out_buf_counter;
extern int loop_counter;

class VS1003
{
	public:
  
  void Init(void);
	void setVolume(byte volume);
  void setBass(uint16_t bass);

  void startSong(void);
  void stopSong(void);

  void showRegister(void);

  void mp3PlayCallback(void);
  
	private:
  
	void Reset_VS1003(void);
  static void Callback();
  void write_register(uint8_t _reg, uint16_t _value);
  uint16_t read_register(uint8_t _reg);
  void sdi_send_zeroes(size_t len);
      
protected:
  void await_data_request(void)
  {
    while(digitalRead(DREQ) == LOW)
    {
      yield();  
    }  
  }

  void control_mode_on(void)
  {
    digitalWrite(DCS,HIGH);
    digitalWrite(CS,LOW);
  }

  void control_mode_off(void)
  {
    digitalWrite(CS,HIGH);
  }

  void data_mode_on(void)
  {
    digitalWrite(CS,HIGH);
    digitalWrite(DCS,LOW);
  }

  void data_mode_off(void)
  {
    digitalWrite(DCS,HIGH);
  }    
};

extern VS1003 mp3;

#endif
