
#include <ESP8266WiFi.h>
#include <ESP_NTP_Client.h>

const char* ssid = "xxxxxxxx";
const char* password = "xxxxxxxxx";
void WiFiStart(void);

// NTP TimeClient settings                                 // für 1s blockierend, muß noch umgebaut werden
const float UTC_OFFSET = 2;                                // timelib/timezone ist noch nicht drin 
NTPTimeClient timeClient(UTC_OFFSET);

void setup()
{
  // start serial
  Serial.begin(115200);                           
  Serial.println("");
  Serial.println("RESET");

  WiFi.mode(WIFI_STA);
  WiFiStart();
}

void loop()
{
    Serial.println("Updating time...");
    timeClient.updateTime();
    Serial.println(timeClient.getFormattedDate("."));
    Serial.println(timeClient.getFormattedTime());
    Serial.println("");

    delay(10000);
}

void WiFiStart()
{
  // Connect to WiFi network

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
  }
}
