#include "delay.h"

static __IO uint32_t sysTickCounter;
static __IO uint32_t sysTickCount;
static __IO uint32_t sysTickTimeus;
static __IO uint32_t sysTickTimems;

void Delay_Init(void) {
    /****************************************
     *SystemFrequency/1000      1ms         *
     *SystemFrequency/100000    10us        *
     *SystemFrequency/1000000   1us         *
     *****************************************/
    while (SysTick_Config(SystemCoreClock / 1000000) != 0) {
    } // One SysTick interrupt now equals 1us

}

/*
 * Interrupt HANDLING routine
 */
void SysTick_Handler(void) {
	sysTickTimeus++;
	sysTickCount++;
	if(sysTickCount>=1000){
		sysTickCount = 0;
		sysTickTimems ++;
	}
}

/*
 * Give the Microsecond amount since the program is
 * started in a 32bit variable.
 */
uint32_t micros(void) {
	return sysTickTimeus;
}


/*
 * Give the Millisecond amount since the program is
 * started in a 32bit variable.
 */
uint32_t millis(void) {
	return sysTickTimems;
}

/*
 * Waste Microsecond
 */
void delay_us(uint32_t us) {
	uint32_t now = sysTickTimeus;
	while(sysTickTimeus < (now + us)){
		asm("nop");
	}
}

/*
 * Waste Millisecond
 */
void delay_ms(uint32_t ms) {
	uint32_t now = sysTickTimems;
	while(sysTickTimems < (now + ms)){
		asm("nop");
	}
}
