#include "fmc.h"

uint8_t FMC_SSD1963_SLOW_Init(void)
{
	FMC_NORSRAMInitTypeDef  FMC_NORSRAMInitDef;
	FMC_NORSRAMTimingInitTypeDef  FMC_NORSRAMTimingInitDef;

	/* Enable FMC clock */
	RCC_AHB3PeriphClockCmd(RCC_AHB3Periph_FMC, ENABLE);

	/* FMC SSD1963 as a NORSRAM device initialization sequence ---*/
	/* Step 1 ----------------------------------------------------------*/
	/* Timing configuration for 84 Mhz of SD clock frequency (168Mhz/2) */
	FMC_NORSRAMTimingInitDef.FMC_AddressSetupTime		= 0x0F;
	FMC_NORSRAMTimingInitDef.FMC_AddressHoldTime		= 0x00;
	FMC_NORSRAMTimingInitDef.FMC_DataSetupTime		= 0xFF;
	FMC_NORSRAMTimingInitDef.FMC_BusTurnAroundDuration  	= 0x00;
	FMC_NORSRAMTimingInitDef.FMC_CLKDivision    		= 0x00;
	FMC_NORSRAMTimingInitDef.FMC_DataLatency            	= 0x00;
	FMC_NORSRAMTimingInitDef.FMC_AccessMode             	= FMC_AccessMode_A;

	/* FMC SDRAM control configuration */
	FMC_NORSRAMInitDef.FMC_Bank 					= FMC_Bank1_NORSRAM1;
	FMC_NORSRAMInitDef.FMC_DataAddressMux 			= FMC_DataAddressMux_Disable;
	FMC_NORSRAMInitDef.FMC_MemoryType 				= FMC_MemoryType_SRAM;
	FMC_NORSRAMInitDef.FMC_MemoryDataWidth 			= FMC_NORSRAM_MemoryDataWidth_16b;
	FMC_NORSRAMInitDef.FMC_BurstAccessMode 			= FMC_BurstAccessMode_Disable;
	FMC_NORSRAMInitDef.FMC_AsynchronousWait 			= FMC_AsynchronousWait_Disable;
	FMC_NORSRAMInitDef.FMC_WaitSignalPolarity 		= FMC_WaitSignalPolarity_Low;
	FMC_NORSRAMInitDef.FMC_WrapMode 				= FMC_WrapMode_Disable;
	FMC_NORSRAMInitDef.FMC_WaitSignalActive 			= FMC_WaitSignalActive_BeforeWaitState;
	FMC_NORSRAMInitDef.FMC_WriteOperation 			= FMC_WriteOperation_Enable;
	FMC_NORSRAMInitDef.FMC_WaitSignal 			    	= FMC_WaitSignal_Disable;
	FMC_NORSRAMInitDef.FMC_ExtendedMode 			= FMC_ExtendedMode_Disable;
	FMC_NORSRAMInitDef.FMC_WriteBurst 				= FMC_WriteBurst_Disable;
	FMC_NORSRAMInitDef.FMC_ContinousClock 			= FMC_CClock_SyncOnly;  //FMC_CClock_SyncAsync
	FMC_NORSRAMInitDef.FMC_ReadWriteTimingStruct		= &FMC_NORSRAMTimingInitDef;
	FMC_NORSRAMInitDef.FMC_WriteTimingStruct			= &FMC_NORSRAMTimingInitDef;
	/* FMC NORSRAM bank initialization */
	FMC_NORSRAMInit(&FMC_NORSRAMInitDef);
	/* FMC NORSRAM bank enable */
	FMC_NORSRAMCmd(FMC_Bank1_NORSRAM1, ENABLE);

	return 1;
}

/* Afer Slow Init and SSD Init, Fast Init must be called for high FPS */
uint8_t FMC_SSD1963_FAST_Init(void)
{
	FMC_NORSRAMInitTypeDef  FMC_NORSRAMInitDef;
	FMC_NORSRAMTimingInitTypeDef  FMC_NORSRAMTimingInitDef_Write, FMC_NORSRAMTimingInitDef_Read;

	/* FMC SSD1963 as a NORSRAM device initialization sequence ---*/
	/* Timing configuration for 84 Mhz of SD clock frequency (168Mhz/2) */
	FMC_NORSRAMTimingInitDef_Write.FMC_AccessMode             	= FMC_AccessMode_A;
	FMC_NORSRAMTimingInitDef_Write.FMC_AddressSetupTime		= 2;//FMC_WR_ADDR_SETUP;
	FMC_NORSRAMTimingInitDef_Write.FMC_AddressHoldTime		= 0;//FMC_WR_ADDR_HOLD;
	FMC_NORSRAMTimingInitDef_Write.FMC_DataSetupTime		= 2;//FMC_WR_DATA_SETUP;
	FMC_NORSRAMTimingInitDef_Write.FMC_BusTurnAroundDuration  	= 0x00;
	FMC_NORSRAMTimingInitDef_Write.FMC_CLKDivision    		= 0x00;
	FMC_NORSRAMTimingInitDef_Write.FMC_DataLatency           	= 0x00;


	/* Timing configuration for 84 Mhz of SD clock frequency (168Mhz/2) */
	FMC_NORSRAMTimingInitDef_Read.FMC_AccessMode    		= FMC_AccessMode_A;
	FMC_NORSRAMTimingInitDef_Read.FMC_AddressSetupTime		= 2;//FMC_RD_ADDR_SETUP;
	FMC_NORSRAMTimingInitDef_Read.FMC_AddressHoldTime		= 0;//FMC_RD_ADDR_HOLD;
	FMC_NORSRAMTimingInitDef_Read.FMC_DataSetupTime			= 2;//FMC_RD_DATA_SETUP;
	FMC_NORSRAMTimingInitDef_Read.FMC_BusTurnAroundDuration 	= 0x00;
	FMC_NORSRAMTimingInitDef_Read.FMC_CLKDivision   		= 0x00;
	FMC_NORSRAMTimingInitDef_Read.FMC_DataLatency   		= 0x00;

	/* FMC SDRAM control configuration */
	FMC_NORSRAMInitDef.FMC_Bank 				=  FMC_Bank1_NORSRAM1;
    	FMC_NORSRAMInitDef.FMC_DataAddressMux 		=  FMC_DataAddressMux_Disable;
	FMC_NORSRAMInitDef.FMC_MemoryType 			=  FMC_MemoryType_SRAM;
	FMC_NORSRAMInitDef.FMC_MemoryDataWidth 		=  FMC_NORSRAM_MemoryDataWidth_16b;
	FMC_NORSRAMInitDef.FMC_BurstAccessMode 		=  FMC_BurstAccessMode_Disable;
	FMC_NORSRAMInitDef.FMC_AsynchronousWait 		=  FMC_AsynchronousWait_Disable;
	FMC_NORSRAMInitDef.FMC_WaitSignalPolarity 	=  FMC_WaitSignalPolarity_Low;
	FMC_NORSRAMInitDef.FMC_WrapMode 			=  FMC_WrapMode_Disable;
	FMC_NORSRAMInitDef.FMC_WaitSignalActive 		=  FMC_WaitSignalActive_BeforeWaitState;
	FMC_NORSRAMInitDef.FMC_WriteOperation 		=  FMC_WriteOperation_Enable;
	FMC_NORSRAMInitDef.FMC_WaitSignal 			=  FMC_WaitSignal_Disable;
	FMC_NORSRAMInitDef.FMC_ExtendedMode 		=  FMC_ExtendedMode_Disable;
	FMC_NORSRAMInitDef.FMC_WriteBurst 			=  FMC_WriteBurst_Disable;
	FMC_NORSRAMInitDef.FMC_ContinousClock 		=  FMC_CClock_SyncOnly;  //FMC_CClock_SyncAsync
	FMC_NORSRAMInitDef.FMC_ReadWriteTimingStruct	= &FMC_NORSRAMTimingInitDef_Read;
	FMC_NORSRAMInitDef.FMC_WriteTimingStruct		= &FMC_NORSRAMTimingInitDef_Write;

	/* DISABLING THE NORSRAM BANK WHILE CHANGING SPEED */
	FMC_NORSRAMCmd(FMC_Bank1_NORSRAM1, DISABLE);
	/* FMC NORSRAM bank initialization */
	FMC_NORSRAMInit(&FMC_NORSRAMInitDef);
	/* FMC NORSRAM bank enable */
	FMC_NORSRAMCmd(FMC_Bank1_NORSRAM1, ENABLE);

	return 1;
}

void FMC_SSD1963_InitPins(void)
{
	// Clock for GPIOD + GPIOE => FMC
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD | RCC_AHB1Periph_GPIOE, ENABLE);
	/* Enable FMC clock */
	RCC_AHB3PeriphClockCmd(RCC_AHB3Periph_FMC, ENABLE);

	GPIO_InitTypeDef GPIO_InitDef;

	//Common settings
	GPIO_InitDef.GPIO_Mode  = GPIO_Mode_AF;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd  = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitDef.GPIO_Pin = GPIO_Pin_0  | // D2
					GPIO_Pin_1  | // D3
					GPIO_Pin_4  | // NOE -> /RD
					GPIO_Pin_5  | // NWE -> /WR
					GPIO_Pin_7  | // NE1 -> /CS
					GPIO_Pin_8  | // D13
					GPIO_Pin_9  | // D14
					GPIO_Pin_10 | // D15
					GPIO_Pin_11 | // A16 -> D/C
					GPIO_Pin_14 | // D0
					GPIO_Pin_15;  // D1
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource0, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource1, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource4, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource5, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource7, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource8, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource9, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource10, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource11, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource14, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource15, GPIO_AF_FMC);
	GPIO_Init(GPIOD, &GPIO_InitDef);


	GPIO_InitDef.GPIO_Pin = GPIO_Pin_7  | // D4
					GPIO_Pin_8  | // D5
					GPIO_Pin_9  | // D6
					GPIO_Pin_10 | // D7
					GPIO_Pin_11 | // D8
					GPIO_Pin_12 | // D9
					GPIO_Pin_13 | // D10
					GPIO_Pin_14 | // D11
					GPIO_Pin_15;  // D12
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource7, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource8, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource9, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource10, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource11, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource12, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource13, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource14, GPIO_AF_FMC);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource15, GPIO_AF_FMC);
	GPIO_Init(GPIOE, &GPIO_InitDef);
}
