#ifndef FMC_H
#define FMC_H

#include "stm32f4xx.h"
#include "stm32f4xx_rcc.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_fmc.h"

#include "misc.h"
#include "delay.h"
#include "gpio.h"
#include "fmc.h"
#include "ssd1963.h"


//SDRAM start address
#define SDRAM_START_ADR			(uint32_t)0xD0000000
//SDRAM max memory width = 8MB
#define SDRAM_MEMORY_WIDTH		(uint32_t)0x800000
//SDRAM timeout config time
#define SDRAM_TIMEOUT			((uint32_t)0xFFFF)
//SDRAM address end
#define SDRAM_MAX_ADDR			((uint32_t)0x7FFFFF)

//SSD start address
#define SSD_START_ADR			(uint32_t)0x60000000
//SSD start address
#define SSD_CMD_PTR				SSD_START_ADR
//SSD start address
#define SSD_DATA_PTR			(uint32_t)(SSD_START_ADR + (uint32_t)0x20000)
//SSD timeout configuration time
#define SSD_TIMEOUT				((uint32_t)0xFFFF)


// SSD1963 FMC Timings
#define FMC_RD_ADDR_SETUP 0x0A
#define FMC_RD_ADDR_HOLD  0x00
#define FMC_RD_DATA_SETUP 0x00
#define FMC_WR_ADDR_SETUP 0x0A
#define FMC_WR_ADDR_HOLD  0x00
#define FMC_WR_DATA_SETUP 0x00

//INIT FMC

// MANAGE TWO ITMES: SDRAM and SSD1963
extern uint8_t FMC_SSD1963_SLOW_Init(void);
extern uint8_t FMC_SSD1963_FAST_Init(void);

//INIT FMC GPIO pins: Called internally
extern void FMC_SSD1963_InitPins(void);



#endif
