#include "gpio.h"

/* You need a GPIO_InitTypeDef struct to set options for pin.
 * If you have included GPIO library into project, you can do this with following:
*/
GPIO_InitTypeDef GPIO_InitDef;


/*
 * ADD THE PORT SETUP IN THE FUNCTION DOWN THERE
 */

void myGPIO_Init(){

	/************************************************/
	/*_____________### PORT A SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/*To be able to work with pin, you have to enable pin clock.
	 *This is set inside RCC (Reset and Clock Control).
	 *All GPIOs are on AHB1 bus. We will use GPIOA port, because
	 *our onboard button is connected to pin PA0.
	 *We can enable clock with code below:
	*/
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA, ENABLE);


	/*Next, you need a GPIO_InitTypeDef structure to set options for pin.
	 *If you have included GPIO library into project, you can do this with following:
	 */
	//GPIO_InitTypeDef GPIO_InitDef;      //Already defined


	/*GPIO_InitTypeDef has 5 options:
	 *GPIO_Pin: Choose pins you will use for set settings
	 *GPIO_Mode: Choose mode of operation. Look down for options
	 *GPIO_OType: Choose output type
	 *GPIO_PuPd: Choose pull resistor
	 *GPIO_Speed: Choose pin speed
	 *Every of this settings has its own options.
	 *
	 *GPIO_Mode: Mode of pins operation>
	 *	GPIO_Mode_IN: Set pin to input
     *	GPIO_Mode_OUT: Set pin to be an output
     *	GPIO_Mode_AF: Set pin to alternating function (to use with peripheral ex. SPI, USART, etc)
     *  GPIO_Mode_AN: Set pin to be an analog (ADC or DAC)
	 *GPIO_OType: Mode for pins output type
     *  GPIO_OType_PP: Output type is push-pull
     *  GPIO_OType_OD: Output type is open drain
     *GPIO_PuPd: Select pull resistors or disable it
	 *  GPIO_PuPd_UP: Enable pull up resistor
     *	GPIO_PuPd_DOWN: Enable pull down resistor
     *	GPIO_PuPd_NOPULL: Disable pull resistor
     *GPIO_Speed: Select GPIO speed
     *	GPIO_Speed_100MHz
     *	GPIO_Speed_50MHz
	 *	GPIO_Speed_25MHz
	 *	GPIO_Speed_2MHz
	*/

	//						USER BUTTON
	GPIO_InitDef.GPIO_Pin = GPIO_Pin_0;
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_IN;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;


	/*We never told the script which port we will use because we have more pins 0 on board.
	 *Here comes the first GPIO function called GPIO_Init(). It is located in stm32f4xx_gpio.h
	 */
	GPIO_Init(GPIOA, &GPIO_InitDef);


	/************************************************/
	/*_____________### PORT B SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOB OUTPUTS **/
	/*
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE);

	//
	GPIO_InitDef.GPIO_Pin =
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOB, &GPIO_InitDef);
	*/

	/************************************************/
	/*_____________### PORT C SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOC OUTPUTS **/
	/*
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE);
	//
	GPIO_InitDef.GPIO_Pin =
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOC, &GPIO_InitDef);
	*/

	/************************************************/
	/*_____________### PORT D SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOC OUTPUTS **/
	/*
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);

	//
	GPIO_InitDef.GPIO_Pin =
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOD, &GPIO_InitDef);
	*/

	/************************************************/
	/*_____________### PORT E SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOC OUTPUTS **/
	/*
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOE, ENABLE);

	//
	GPIO_InitDef.GPIO_Pin =
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOE, &GPIO_InitDef);
	*/

	/************************************************/
	/*_____________### PORT F SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOC OUTPUTS **/
	/*
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOF, ENABLE);

	//
	GPIO_InitDef.GPIO_Pin =
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOF, &GPIO_InitDef);
	*/

	/************************************************/
	/*_____________### PORT G SETUP ###_____________*/
	/*                                              */
	/************************************************/

	/**SET THE GPIOG OUTPUTS **/
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOG, ENABLE);

	//					    SSD_BACKLIT		|LED_GREEN		|LED_RED
	GPIO_InitDef.GPIO_Pin = GPIO_Pin_12 	|GPIO_Pin_13	|GPIO_Pin_14;
	GPIO_InitDef.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitDef.GPIO_OType = GPIO_OType_PP;
	GPIO_InitDef.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitDef.GPIO_Speed = GPIO_Speed_100MHz;

	GPIO_Init(GPIOG, &GPIO_InitDef);
	
	
}
