#include "ssd1963.h"

void SSD1963_WriteCommand(uint16_t value) {
	*(uint16_t*) (0x60000000) = value;
}

void SSD1963_WriteData(uint16_t value) {
	*(uint16_t*) (0x60020000) = value;
}

void SSD1963_SoftReset()
{
	//SOFTWARE RESET
	SSD1963_WriteCommand(SSD1963_SOFT_RESET);
	delay_ms(10);				//Wait a stable condition
}

uint16_t SSD1963_ConvertColor(uint32_t color)
{
	return (((color>>19)&0x1F)<<11 | ((color>>10)&0x3F)<<5 | ((color>>3)&0x1F));
}

void SSD1963_Clear(uint16_t color)
{
	uint16_t x,y = 800;
	SSD1963_SetPos(0, 0, 799, 479);
	while(y--){
		for(x=0; x<480; x++)
			SSD1963_WriteData(color);
	}
}

void SSD1963_SetPixel(uint16_t x, uint16_t y, uint16_t color)
{
	SSD1963_SetPos(x, y, x, y);
	SSD1963_WriteData(color);
}


void SSD1963_SetPos(uint16_t xs, uint16_t ys, uint16_t xe, uint16_t ye)
{
	//SET COLUMN ADDRESS
	SSD1963_WriteCommand(0x2A);
	SSD1963_WriteData((xs>>8)&0x00FF);		//Highest byte SC
	SSD1963_WriteData(xs & 0x00FF);		//Lowest byte SC, Start Column
	SSD1963_WriteData((xe>>8)&0x00FF);		//Highest byte EC
	SSD1963_WriteData(xe & 0x00FF);		//Lowest byte EC, End Column

	//SET COLUMN ADDRESS
	SSD1963_WriteCommand(0x2B);
	SSD1963_WriteData((ys>>8)&0x00FF);		//Highest byte SP
	SSD1963_WriteData(ys & 0x00FF);		//Lowest byte SP, Start Page
	SSD1963_WriteData((ye>>8)&0x00FF);		//Highest byte EP
	SSD1963_WriteData(ye & 0x00FF);		//Lowest byte EP, End Page

	//WRITE MEMORY START
	SSD1963_WriteCommand(0x2C);
}


void SSD1963_Init()
{
	SSD1963_SoftReset();
	SSD1963_SoftReset();
	SSD1963_SoftReset();

	//SET THE INTERNAL PLL NM
	SSD1963_WriteCommand(SSD1963_SET_PLL_MN);
	SSD1963_WriteData(0x23);		//Set Multiplier to 35
	SSD1963_WriteData(0x02);		//Set Divider to 2
	SSD1963_WriteData(0x04);		//Set 10Mhz*35/2=175Mhz PLL clock


	//ENABLE PLL
	SSD1963_WriteCommand(SSD1963_SET_PLL);
	SSD1963_WriteData(0x01);		//Reference clock , Enable PLL
	delay_ms(100);				//Wait a stable condition

	SSD1963_WriteCommand(SSD1963_SET_PLL);
	SSD1963_WriteData(0x03);		//PLL clock , Enable PLL

	SSD1963_SoftReset();

	// SSD1963_WriteCommand (SSD1963_GET_PLL_STATUS);
	// test = LCD_RAM;										// test = 4 if PLL is locked
	delay_ms(100);

	SSD1963_WriteCommand (SSD1963_SET_LCD_MODE);
	SSD1963_WriteData (0x0C);				// 18 Bit,  FRC, no Dithering, Vsync, Hsync active low, Data latch @ falling edge
	SSD1963_WriteData (0x00);				// TFT Mode, Hsync+Vsync+De Mode
	SSD1963_WriteData (0x03);				// Set horizontal Panel Size = 799 -> 0x31F
	SSD1963_WriteData (0x1F);
	SSD1963_WriteData (0x01);				// Set vertical Panel Size = 479 ->
	SSD1963_WriteData (0xDF);
	SSD1963_WriteData (0x00);

	SSD1963_WriteCommand (SSD1963_SET_PIXEL_FORMAT);
	SSD1963_WriteData (0x50);

	SSD1963_WriteCommand (SSD1963_SET_PIXEL_DATA_INTERFACE);
	SSD1963_WriteData (0x03);							// 16 Bit - 565 Format

	SSD1963_WriteCommand (SSD1963_SET_LSHIFT_FREQ);
	SSD1963_WriteData((LCD_FPR >> 16) & 0xFF);
	SSD1963_WriteData((LCD_FPR >> 8) & 0xFF);
	SSD1963_WriteData(LCD_FPR & 0xFF);
	/*
	SSD1963_WriteData (0x04);							// (Lshiftfrequency / PLLfrequency ) *2^20 = LCDC_FPR
	SSD1963_WriteData (0x93);							// (40Mhz / 120 MHz ) * 2^20 = 349524 = 0x55554
	SSD1963_WriteData (0xE0);							//  33Mhz / 120 Mhz ) * 2^20 = 0x46666 alt
	*/

	SSD1963_WriteCommand (SSD1963_SET_HORI_PERIOD);
	SSD1963_WriteData(mHIGH(TFT_HSYNC_PERIOD));
	SSD1963_WriteData(mLOW(TFT_HSYNC_PERIOD));
	SSD1963_WriteData(mHIGH((TFT_HSYNC_PULSE + TFT_HSYNC_BACK_PORCH)));
	SSD1963_WriteData(mLOW((TFT_HSYNC_PULSE + TFT_HSYNC_BACK_PORCH)));
	SSD1963_WriteData(TFT_HSYNC_PULSE);
	SSD1963_WriteData(0x00);
	SSD1963_WriteData(0x00);
	SSD1963_WriteData(0x00);

	SSD1963_WriteCommand (SSD1963_SET_VERT_PERIOD);
	SSD1963_WriteData(mHIGH(TFT_VSYNC_PERIOD));
	SSD1963_WriteData(mLOW(TFT_VSYNC_PERIOD));
	SSD1963_WriteData(mHIGH((TFT_VSYNC_PULSE + TFT_VSYNC_BACK_PORCH)));
	SSD1963_WriteData(mLOW((TFT_VSYNC_PULSE + TFT_VSYNC_BACK_PORCH)));
	SSD1963_WriteData(TFT_VSYNC_PULSE);
	SSD1963_WriteData(0x00);
	SSD1963_WriteData(0x00);


	SSD1963_WriteData(0x0060);

	SSD1963_WriteCommand(SSD1963_SET_DISPLAY_ON);
}
