#ifndef __SSD_H
#define __SSD_H

#include "stm32f4xx.h"
#include "stm32f4xx_rcc.h"
#include "stm32f4xx_gpio.h"

#include "misc.h"
#include "delay.h"
#include "gpio.h"
#include "fmc.h"
#include "ssd1963.h"


#define LCD_MAX_X                   800
#define LCD_MAX_Y                   480
#define LCD_PIXEL                   LCD_MAX_X * LCD_MAX_Y
#define LCD_SSD1963_PAUSE           5000
#define LCD_SSD1963_PORTRAIT
#define LCD_SSD1963_LANDSCAPE


#define TFT_FPS 60ULL

//The following values are for a 7" TFT LCD
#define TFT_WIDTH                   800ULL
#define TFT_HSYNC_BACK_PORCH	      46ULL
#define TFT_HSYNC_FRONT_PORCH       210ULL
#define TFT_HSYNC_PULSE			1ULL

#define TFT_HEIGHT			480ULL
#define TFT_VSYNC_BACK_PORCH        23ULL
#define TFT_VSYNC_FRONT_PORCH       22ULL
#define TFT_VSYNC_PULSE			1ULL

#define	TFT_HSYNC_PERIOD       (TFT_HSYNC_PULSE + TFT_HSYNC_BACK_PORCH + TFT_WIDTH  + TFT_HSYNC_FRONT_PORCH)
#define	TFT_VSYNC_PERIOD	     (TFT_VSYNC_PULSE + TFT_VSYNC_BACK_PORCH + TFT_HEIGHT + TFT_VSYNC_FRONT_PORCH)
#define TFT_PCLK	(TFT_HSYNC_PERIOD * TFT_VSYNC_PERIOD * TFT_FPS)

//#define TFT_PCLK (928 * 525 * 60)
#define LCD_FPR		((TFT_PCLK * 1048576)/100000000)



#define TFT_PCLK	                  (TFT_HSYNC_PERIOD * TFT_VSYNC_PERIOD * TFT_FPS)

#define mHIGH(x)                    (x >> 8)
#define mLOW(x)                     (x & 0xFF)


#define SSD1963_NOP				0x0000
#define SSD1963_SOFT_RESET  			0x0001
#define SSD1963_GET_POWER_MODE 		0x000A
#define SSD1963_GET_ADDRESS_MODE		0x000B
#define SSD1963_GET_DISPLAY_MODE		0x000D
#define SSD1963_GET_TEAR_EFFECT_STATUS 	0x000E
#define SSD1963_ENTER_SLEEP_MODE		0x0010
#define SSD1963_EXIT_SLEEP_MODE		0x0011
#define SSD1963_ENTER_PARTIAL_MODE		0x0012
#define SSD1963_ENTER_NORMAL_MODE		0x0013
#define SSD1963_EXIT_INVERT_MODE		0x0020
#define SSD1963_ENTER_INVERT_MODE		0x0021
#define SSD1963_SET_GAMMA_CURVE		0x0026
#define SSD1963_SET_DISPLAY_OFF		0x0028
#define SSD1963_SET_DISPLAY_ON		0x0029
#define SSD1963_SET_COLUMN_ADDRESS		0x002A
#define SSD1963_SET_PAGE_ADDRESS		0x002B
#define SSD1963_WRITE_MEMORY_START		0x002C
#define SSD1963_READ_MEMORY_START		0x002E
#define SSD1963_SET_PARTIAL_AREA		0x0030
#define SSD1963_SET_SCROLL_AREA		0x0033
#define SSD1963_SET_TEAR_OFF			0x0034
#define SSD1963_SET_TEAR_ON			0x0035
#define SSD1963_SET_ADDRESS_MODE		0x0036
#define SSD1963_SET_SCROLL_START		0x0037
#define SSD1963_EXIT_IDLE_MODE		0x0038
#define SSD1963_ENTER_IDLE_MODE		0x0039
#define SSD1963_SET_PIXEL_FORMAT		0x003A
#define SSD1963_WRITE_MEMORY_CONTINUE	0x003C
#define SSD1963_READ_MEMORY_CONTINUE	0x003E
#define SSD1963_SET_TEAR_SCANLINE		0x0044
#define SSD1963_GET_SCANLINE			0x0045
#define SSD1963_READ_DDB			0x00A1
#define SSD1963_SET_LCD_MODE			0x00B0
#define SSD1963_GET_LCD_MODE			0x00B1
#define SSD1963_SET_HORI_PERIOD		0x00B4
#define SSD1963_GET_HORI_PERIOD		0x00B5
#define SSD1963_SET_VERT_PERIOD		0x00B6
#define SSD1963_GET_VERT_PERIOD		0x00B7
#define SSD1963_SET_GPIO_CONF			0x00B8
#define SSD1963_GET_GPIO_CONF			0x00B9
#define SSD1963_SET_GPIO_VALUE		0x00BA
#define SSD1963_GET_GPIO_STATUS		0x00BB
#define SSD1963_SET_POST_PROC			0x00BC
#define SSD1963_GET_POST_PROC			0x00BD
#define SSD1963_SET_PWM_CONF			0x00BE
#define SSD1963_GET_PWM_CONF			0x00BF
#define SSD1963_GET_GDISP_GEN0		0x00C0
#define SSD1963_SET_GDISP_GEN0		0x00C1
#define SSD1963_GET_GDISP_GEN1		0x00C2
#define SSD1963_SET_GDISP_GEN1		0x00C3
#define SSD1963_GET_GDISP_GEN2		0x00C4
#define SSD1963_SET_GDISP_GEN2		0x00C5
#define SSD1963_GET_GDISP_GEN3		0x00C6
#define SSD1963_SET_GDISP_GEN3		0x00C7
#define SSD1963_SET_GPIO0_ROP			0x00C8
#define SSD1963_GET_GPIO0_ROP			0x00C9
#define SSD1963_SET_GPIO1_ROP			0x00CA
#define SSD1963_GET_GPIO1_ROP			0x00CB
#define SSD1963_SET_GPIO2_ROP			0x00CC
#define SSD1963_GET_GPIO2_ROP			0x00CD
#define SSD1963_SET_GPIO3_ROP			0x00CE
#define SSD1963_GET_GPIO3_ROP			0x00CF
#define SSD1963_SET_DBC_CONF			0x00D0
#define SSD1963_GET_DBC_CONF			0x00D1
#define SSD1963_SET_DBC_TH			0x00D4
#define SSD1963_GET_DBC_TH			0x00D5
#define SSD1963_SET_PLL				0x00E0
#define SSD1963_SET_PLL_MN			0x00E2
#define SSD1963_GET_PLL_MN			0x00E3
#define SSD1963_GET_PLL_STATUS		0x00E4
#define SSD1963_SET_DEEP_SLEEP		0x00E5
#define SSD1963_SET_LSHIFT_FREQ		0x00E6
#define SSD1963_GET_LSHIFT_FREQ		0x00E7
#define SSD1963_SET_PIXEL_DATA_INTERFACE  0x00F0
	#define SSD1963_PDI_8BIT			0
	#define SSD1963_PDI_12BIT			1
	#define SSD1963_PDI_16BIT			2
	#define SSD1963_PDI_16BIT565		      3
	#define SSD1963_PDI_18BIT			4
	#define SSD1963_PDI_24BIT			5
	#define SSD1963_PDI_9BIT			6
#define SSD1963_GET_PIXEL_DATA_INTERFACE  0x00F1


//PROTOTYPES FOR SSD1963 DATA/COMMAND WRITE
extern void SSD1963_WriteCommand(uint16_t value);
extern void SSD1963_WriteData(uint16_t value);

/*
extern void write_command_565(uint8_t c);
extern void write_data_565(uint16_t d);
*/
extern void SSD1963_Init(void);
extern void SSD1963_Fill_565(uint16_t color);
extern void SSD1963_Clear(uint16_t color);
extern void SSD1963_SetPos(uint16_t xs, uint16_t xe, uint16_t ys, uint16_t ye);
extern void SSD1963_SetPixel(uint16_t, uint16_t, uint16_t);
extern void SSD1963_SoftReset(void);
extern uint16_t SSD1963_ConvertColor(uint32_t color);

#endif
