;##############################################################################
; ENC28J60 Control Registers													
; ------------------------------------------------------------------------------
;																				
; Control register definitions are a combination of address,					
; bank number, and Ethernet/MAC/PHY indicator bits.								
;																				
; - Register address (bits 0-4)													
; - Bank number  (bits 7-6)														
; - MAC/PHY indicator (bit 5)													
;																				
; Bemerkung:																	
; Die Originalversion stammt von Ben's Hobby-Corner Tutorial und wurde			
; entsprechend ergnzt und abgendert.											
;																				
;##############################################################################
; ===== SPI operation codes =====
.equ RCR 		= 0b00000000	; x00	
.equ RBM   		= 0b00111010 	; x3A	
.equ WCR		= 0b01000000 	; x40	
.equ WBM 		= 0b01111010 	; x7A	
.equ BFS 		= 0b10000000 	; x80	
.equ BFC 		= 0b10100000 	; xA0	
.equ SOFT_RESET	= 0b11111111 	; xFF	

; ===== All-bank registers =====
.equ   EIE 	= 0x1B
.equ   EIR 	= 0x1C
.equ   ESTAT= 0x1D
.equ   ECON2= 0x1E
.equ   ECON1= 0x1F
; ===== for bank selection =====
.equ Bank0 = 0b00_0_00000
.equ Bank1 = 0b01_0_00000
.equ Bank2 = 0b10_0_00000
.equ Bank3 = 0b11_0_00000
; ===== MAC/PHY indicator =====
.equ MacPhy= 0b00_1_00000
; ===== Bank 0 registers =====
.equ Erdptl = 0x00 | Bank0
.equ Erdpth = 0x01 | Bank0
.equ Ewrptl = 0x02 | Bank0
.equ Ewrpth = 0x03 | Bank0
.equ Etxstl = 0x04 | Bank0
.equ Etxsth = 0x05 | Bank0
.equ Etxndl = 0x06 | Bank0
.equ Etxndh = 0x07 | Bank0
.equ Erxstl = 0x08 | Bank0
.equ Erxsth = 0x09 | Bank0
.equ Erxndl = 0x0A | Bank0
.equ Erxndh = 0x0B | Bank0
.equ Erxrdptl = 0x0C | Bank0
.equ Erxrdpth = 0x0D | Bank0
.equ Erxwrptl = 0x0E | Bank0
.equ Erxwrpth = 0x0F | Bank0
.equ Edmastl = 0x10 | Bank0
.equ Edmasth = 0x11 | Bank0
.equ Edmandl = 0x12 | Bank0
.equ Edmandh = 0x13 | Bank0
.equ Edmadstl = 0x14 | Bank0
.equ Edmadsth = 0x15 | Bank0
.equ Edmacsl = 0x16 | Bank0
.equ Edmacsh = 0x17 | Bank0
; ===== Bank 1 registers =====
.equ Eht0 = 0x00 | Bank1
.equ Eht1 = 0x01 | Bank1
.equ Eht2 = 0x02 | Bank1
.equ Eht3 = 0x03 | Bank1
.equ Eht4 = 0x04 | Bank1
.equ Eht5 = 0x05 | Bank1
.equ Eht6 = 0x06 | Bank1
.equ Eht7 = 0x07 | Bank1
.equ Epmm0 = 0x08 | Bank1
.equ Epmm1 = 0x09 | Bank1
.equ Epmm2 = 0x0A | Bank1
.equ Epmm3 = 0x0B | Bank1
.equ Epmm4 = 0x0C | Bank1
.equ Epmm5 = 0x0D | Bank1
.equ Epmm6 = 0x0E | Bank1
.equ Epmm7 = 0x0F | Bank1
.equ Epmcsl = 0x10 | Bank1
.equ Epmcsh = 0x11 | Bank1
.equ Epmol = 0x14 | Bank1
.equ Epmoh = 0x15 | Bank1
.equ Ewolie = 0x16 | Bank1
.equ Ewolir = 0x17 | Bank1
.equ Erxfcon = 0x18 | Bank1
.equ Epktcnt = 0x19 | Bank1
; ===== Bank 2 registers =====
.equ Macon1 = 0x00 | Bank2 | Macphy
.equ Macon2 = 0x01 | Bank2 | Macphy                      ; reserved
.equ Macon3 = 0x02 | Bank2 | Macphy
.equ Macon4 = 0x03 | Bank2 | Macphy
.equ Mabbipg = 0x04 | Bank2 | Macphy
.equ Maipgl = 0x06 | Bank2 | Macphy
.equ Maipgh = 0x07 | Bank2 | Macphy
.equ Maclcon1 = 0x08 | Bank2 | Macphy
.equ Maclcon2 = 0x09 | Bank2 | Macphy
.equ Mamxfll = 0x0A | Bank2 | Macphy
.equ Mamxflh = 0x0B | Bank2 | Macphy
.equ Maphsup = 0x0D | Bank2 | Macphy
.equ Micon = 0x11 | Bank2 | Macphy
.equ Micmd = 0x12 | Bank2 | Macphy
.equ Miregadr = 0x14 | Bank2 | Macphy
.equ Miwrl = 0x16 | Bank2 | Macphy
.equ Miwrh = 0x17 | Bank2 | Macphy
.equ Mirdl = 0x18 | Bank2 | Macphy
.equ Mirdh = 0x19 | Bank2 | Macphy
; ===== Bank 3 registers =====
.equ Maadr5 = 0x00 | Bank3 | Macphy
.equ Maadr6 = 0x01 | Bank3 | Macphy
.equ Maadr3 = 0x02 | Bank3 | Macphy
.equ Maadr4 = 0x03 | Bank3 | Macphy
.equ Maadr1 = 0x04 | Bank3 | Macphy
.equ Maadr2 = 0x05 | Bank3 | Macphy
.equ Ebstsd = 0x06 | Bank3
.equ Ebstcon = 0x07 | Bank3
.equ Ebstcsl = 0x08 | Bank3
.equ Ebstcsh = 0x09 | Bank3
.equ Mistat = 0x0A | Bank3 | Macphy             ; checken of goed is
.equ Erevid = 0x12 | Bank3
.equ ECOCON = 0x15 | Bank3						; ECOCON: CLOCK OUTPUT CONTROL REGISTER
.equ Eflocon = 0x17 | Bank3
.equ Epausl = 0x18 | Bank3
.equ Epaush = 0x19 | Bank3




; ===== ENC28J60 EIR Register Bit Definitions =====
; bit 7 Unimplemented: Read as ?0?
; bit 6 PKTIF: Receive Packet Pending Interrupt Flag bit
; bit 5 DMAIF: DMA Interrupt Flag bit
; bit 4 LINKIF: Link Change Interrupt Flag bit
; bit 3 TXIF: Transmit Interrupt Flag bit
; bit 2 Reserved: Maintain as ?0?
; bit 1 TXERIF: Transmit Error Interrupt Flag bit
; bit 0 RXERIF: Receive Error Interrupt Flag bit

.equ Eir_pktif = 6
.equ Eir_dmaif = 5
.equ Eir_linkif = 4
.equ Eir_txif = 3
.equ Eir_wolif = 2
.equ Eir_txerif = 1
.equ Eir_rxerif = 0


; ===== ENC28J60 ESTAT Register Bit Definitions =====
; bit 7 INT: INT Interrupt Flag bit
; bit 6 BUFER: Ethernet Buffer Error Status bit
; bit 5 Reserved: Read as ?0?
; bit 4 LATECOL: Late Collision Error bit
; bit 3 Unimplemented: Read as ?0?
; bit 2 RXBUSY: Receive Busy bit
; bit 1 TXABRT: Transmit Abort Error bit
; bit 0 CLKRDY: Clock Ready bit(1)
.equ ESTAT_int = 7
.equ ESTAT_bufer = 6
.equ ESTAT_latecol = 4
.equ ESTAT_rxbusy = 2
.equ ESTAT_txabrt = 1
.equ ESTAT_CLKRDY = 0	; CLKRDY resets to .0. on Power-on Reset but is unaffected on all other Resets.


; ===== ENC28J60 EIE Register Bit Definitions =====
; bit 7 INTIE: Global INT Interrupt Enable bit
; bit 6 PKTIE: Receive Packet Pending Interrupt Enable bit
; bit 5 DMAIE: DMA Interrupt Enable bit
; bit 4 LINKIE: Link Status Change Interrupt Enable bit
; bit 3 TXIE: Transmit Enable bit
; bit 2 Reserved: Maintain as ?0?
; bit 1 TXERIE: Transmit Error Interrupt Enable bit
; bit 0 RXERIE: Receive Error Interrupt Enable bit
.equ Eie_intie = 7
.equ Eie_pktie = 6
.equ Eie_dmaie = 5
.equ Eie_linkie = 4
.equ Eie_txie = 3
.equ Eie_wolie = 2
.equ Eie_txerie = 1
.equ Eie_rxerie = 0

; ===== ENC28J60 ECOCON Register Bit Definitions =====
; COCON2:COCON0: Clock Output Configuration bits
; 11x = Reserved for factory test. Do not use. Glitch prevention not assured.
; 101 = CLKOUT outputs main clock divided by 8 (3.125 MHz)
; 100 = CLKOUT outputs main clock divided by 4 (6.25 MHz)
; 011 = CLKOUT outputs main clock divided by 3 (8.333333 MHz)
; 010 = CLKOUT outputs main clock divided by 2 (12.5 MHz)
; 001 = CLKOUT outputs main clock divided by 1 (25 MHz)
; 000 = CLKOUT is disabled. The pin is driven low.
.equ ECOCON_COCON2 = 2
.equ ECOCON_COCON1 = 1
.equ ECOCON_COCON0 = 0
; ===== ENC28J60 ECON2 Register Bit Definitions =====
; bit 7 AUTOINC: Automatic Buffer Pointer Increment Enable bit
; bit 6 PKTDEC: Packet Decrement bit
; bit 5 PWRSV: Power Save Enable bit
; bit 4 Reserved: Maintain as ?0?
; bit 3 VRPS: Voltage Regulator Power Save Enable bit
; bit 2-0 Unimplemented: Read as ?0?
.equ Econ2_autoinc = 7
.equ Econ2_pktdec = 6
.equ Econ2_pwrsv = 5
.equ Econ2_vrps = 3

; ===== ENC28J60 ECON1 Register Bit Definitions =====
; bit 7 TXRST: Transmit Logic Reset bit
; bit 6 RXRST: Receive Logic Reset bit
; bit 5 DMAST: DMA Start and Busy Status bit
; bit 4 CSUMEN: DMA Checksum Enable bit
; bit 3 TXRTS: Transmit Request to Send bit
; bit 2 RXEN: Receive Enable bit
; bit 1-0 BSEL1:BSEL0: Bank Select bits
.equ Econ1_txrst = 7
.equ Econ1_rxrst = 6
.equ Econ1_dmast = 5
.equ Econ1_csumen = 4
.equ Econ1_txrts = 3
.equ Econ1_rxen = 2
.equ Econ1_bsel1 = 1
.equ Econ1_bsel0 = 0

; ===== ENC28J60 MACON1 Register Bit Definitions =====
; bit 7-5 Unimplemented: Read as ?0?
; bit 4 Reserved: Maintain as ?0?
; bit 3 TXPAUS: Pause Control Frame Transmission Enable bit
; bit 2 RXPAUS: Pause Control Frame Reception Enable bit
; bit 1 PASSALL: Pass All Received Frames Enable bit
; bit 0 MARXEN: MAC Receive Enable bit
.equ Macon1_loopbk = 4                                     ;?? reserved (0x10)
.equ Macon1_txpaus = 3
.equ Macon1_rxpaus = 2
.equ Macon1_passall = 1
.equ Macon1_marxen = 0

; ===== ENC28J60 MACON2 Register Bit Definitions =====
; Anmerkung: Gem# Datenblatt ist dieses Register nicht existent ==> Reserved
.equ Macon2_marst = 7
.equ Macon2_rndrst = 6
.equ Macon2_marxrst = 4
.equ Macon2_rfunrst = 2
.equ Macon2_matxrst = 1
.equ Macon2_tfunrst = 0

; ===== ENC28J60 MACON3 Register Bit Definitions =====
; bit 7-5 PADCFG2:PADCFG0: Automatic Pad and CRC Configuration bits
; bit 4 TXCRCEN: Transmit CRC Enable bit
; bit 3 PHDREN: Proprietary Header Enable bit
; bit 2 HFRMEN: Huge Frame Enable bit
; bit 1 FRMLNEN: Frame Length Checking Enable bit
; bit 0 FULDPX: MAC Full-Duplex Enable bit
.equ Macon3_padcfg2 = 7
.equ Macon3_padcfg1 = 6
.equ Macon3_padcfg0 = 5
.equ Macon3_txcrcen = 4
.equ Macon3_PHDREN = 3
.equ Macon3_hfrmen = 2
.equ Macon3_frmlnen = 1
.equ Macon3_fuldpx  = 0

; ===== ENC28J60 MACON4 Register Bit Definitions =====
; bit 7 Unimplemented: Read as ?0?
; bit 6 DEFER: Defer Transmission Enable bit (applies to half duplex only)
; bit 5 BPEN: No Backoff During Backpressure Enable bit (applies to half duplex only)
; bit 4 NOBKOFF: No Backoff Enable bit (applies to half duplex only)
; bit 3-2 Unimplemented: Read as ?0?
; bit 1-0 Reserved: Maintain as ?0?
.equ Macon4_defer = 6
.equ Macon4_bpen = 5
.equ Macon4_nobkoff = 4


; ===== ENC28J60 MICMD Register Bit Definitions =====
; bit 7-2 Unimplemented: Read as ?0?
; bit 1 MIISCAN: MII Scan Enable bit
; bit 0 MIIRD: MII Read Enable bit
.equ Micmd_MIISCAN = 1
.equ Micmd_MIIRD = 0


; ===== ENC28J60 MISTAT Register Bit Definitions =====
; bit 7-4 Unimplemented: Read as ?0?
; bit 3 Reserved: Maintain as ?0?
; bit 2 NVALID: MII Management Read Data Not Valid bit
; bit 1 SCAN: MII Management Scan Operation bit
; bit 0 BUSY: MII Management Busy bit
.equ Mistat_nvalid = 2
.equ Mistat_scan = 1
.equ Mistat_busy = 0

; ===== ENC28J60 ETHERNET RECEIVE FILTER CONTROL REGISTER =====
; bit 7 UCEN: Unicast Filter Enable bit					
; bit 6 ANDOR: AND/OR Filter Select bit					
; bit 5 CRCEN: Post-Filter CRC Check Enable bit
; bit 4 PMEN: Pattern Match Filter Enable bit
; bit 3 MPEN: Magic Packet? Filter Enable bit
; bit 2 HTEN: Hash Table Filter Enable bit
; bit 1 MCEN: Multicast Filter Enable bit
; bit 0 BCEN: Broadcast Filter Enable bit
.equ Erxfcon_ucen = 7                                      ;default 1 - Unicast Filter Enable bit (Packets with a destination address matching the local MAC address will be accepted )
.equ Erxfcon_andor = 6                                     ;default 0 - OR = Packets will be accepted unless all enabled filters reject the packet
.equ Erxfcon_crcen = 5                                     ;default 1 - All packets with an invalid CRC will be discarded
.equ Erxfcon_pmen = 4                                      ;default 0 - Pattern Match Filter Enable bit (Packets which meet the Pattern Match criteria will be accepted)
.equ Erxfcon_mpen = 3                                      ;default 0 - Magic Packet Filter Enable bit (if you put this on 1, Magic Pack Filter Enable bit)
.equ Erxfcon_hten = 2                                      ;default 0 - Hash Table Filter Enable bit
.equ Erxfcon_mcen = 1                                      ;default 0 - Multicast Filter Enable bit
.equ Erxfcon_bcen = 0                                      ;default 1 - Broadcast Filter Enable bit (Packets which have a destination address of FF-FF-FF-FF-FF-FF will be accepted)


; ##############################################################################
; ##############################################################################
; ##############################################################################
; TABLE 3-3: ENC28J60 PHY REGISTER SUMMARY										
; Addr Name 																	
; 00h PHCON1																	
; 01h PHSTAT1																	
; 02h PHID1																		
; 03h PHID2																		
; 10h PHCON2																	
; 11h PHSTAT2																	
; 12h PHIE																		
; 13h PHIR																		
; 14h PHLCON																	
; ===== PHY registers ==========================================================
.equ Phcon1 = 0x00
.equ Phstat1= 0x01
.equ Phid1 = 0x02
.equ Phid2 = 0x03
.equ Phcon2 = 0x10
.equ Phstat2= 0x11
.equ Phie   = 0x12
.equ Phir   = 0x13
.equ Phlcon = 0x14
; ===== ENC28J60 PHY PHCON1 Register Bit Definitions =====
; bit 15    PRST: PHY Software Reset bit
; bit 14    PLOOPBK: PHY Loopback bit
; bit 13-12 Unimplemented: Read as ?0?
; bit 11    PPWRSV: PHY Power-Down bit
; bit 10    Reserved: Maintain as ?0?
; bit 9     Unimplemented: Read as ?0?
; bit 8     PDPXMD: PHY Duplex Mode bit(1)
; bit 7     Reserved: Maintain as ?0?
; bit 6-0   Unimplemented: Read as ?0?
.equ Phcon1_prst   = 0x8000
.equ Phcon1_ploopbk= 0x4000
.equ Phcon1_ppwrsv = 0x0800
.equ Phcon1_pdpxmd = 0x0100
; ===== ENC28J60 PHY PHSTAT1 Register Bit Definitions =====
; bit 15-13 Unimplemented: Read as ?0?
; bit 12    PFDPX: PHY Full-Duplex Capable bit
; bit 11    PHDPX: PHY Half-Duplex Capable bit
; bit 10-3  Unimplemented: Read as ?0?
; bit 2     LLSTAT: PHY Latching Link Status bit
; bit 1     JBSTAT: PHY Latching Jabber Status bit
; bit 0     Unimplemented: Read as ?0?
.equ Phstat1_pfdpx = 0x1000
.equ Phstat1_phdpx = 0x0800
.equ Phstat1_llstat= 0x0004
.equ Phstat1_jbstat= 0x0002
; ===== ENC28J60 PHY PHCON2 Register Bit Definitions =====
; bit 15    Unimplemented: Read as ?0?
; bit 14    FRCLNK: PHY Force Linkup bit
; bit 13    TXDIS: Twisted-Pair Transmitter Disable bit
; bit 12-11 Reserved: Write as ?0?
; bit 10    JABBER: Jabber Correction Disable bit
; bit 9     Reserved: Write as ?0?
; bit 8     HDLDIS: PHY Half-Duplex Loopback Disable bit
; bit 7-0   Reserved: Write as ?0?
.equ Phcon2_frclink= 0x4000
.equ Phcon2_txdis  = 0x2000
.equ Phcon2_jabber = 0x0400
.equ Phcon2_hdldis = 0x0100
; ===== PHLCON: PHY MODULE LED CONTROL REGISTER =====
; bit 15-14 Reserved: Write as '0'
; bit 13-12 Reserved: Write as '1'
; bit 11-8 LACFG3:LACFG0: LEDA Configuration bits
; bit 7-4 LBCFG3:LBCFG0: LEDB Configuration bits
; bit 3-2 LFRQ1:LFRQ0: LED Pulse Stretch Time Configuration bits (see Table 2-1)
; bit 1 STRCH: LED Pulse Stretching Enable bit
; bit 0 Reserved: Write as '0'
.equ Phlcon_led_config =  0b00_11_0111_0100_00_1_0          ;PHLCON LED Control Register
;                           |  |  |    |    |  | |
;                           |  |  |    |    |  | +--  Reserved -> Write as 0
;                           |  |  |    |    |  +----- Stretchable LED events will cause lengthened LED pulses based on LFRQ1:LFRQ0 configuration
;                           |  |  |    |    +-------- Stretch LED events by TNSTRCH
;                           |  |  |    +------------- Display link status
;                           |  |  +------------------ Display transmit and receive activity (stretchable)
;                           |  +--------------------- Reserved -> Write as 1
;                           +------------------------ Reserved -> Write as 0


; ===== ENC28J60 Packet Control Byte Bit Definitions =====
; bit 7-4 Unused
; bit 3 PHUGEEN: Per Packet Huge Frame Enable bit
; bit 2 PPADEN: Per Packet Padding Enable bit
; bit 1 PCRCEN: Per Packet CRC Enable bit
; bit 0 POVERRIDE: Per Packet Override bit
.equ Pktctrl_phugeen = 3
.equ Pktctrl_ppaden = 2
.equ Pktctrl_pcrcen = 1
.equ Pktctrl_poverride = 0

; =====														
; buffer boundaries applied to internal 8K ram				
; entire available packet buffer space is allocated			
;.equ Txstart_init 	= 0x0000 	; start TX buffer at 0
;.equ Rxstart_init 	= 0x1A19  	; give TX buffer space for one full ethernet frame (~1500 bytes)
;.equ Rxstop_init 	= 0x1FF0  	; receive buffer gets the rest
;.equ MAX_FRAMELEN	= 1500 		; maximum ethernet frame length




; ===== buffer boundaries applied to internal 8K ram =====
; entire available packet buffer space is allocated

; ENC28J60 Errata !!!
; Module: Memory (Ethernet Buffer)
; The receive hardware maintains an internal Write Pointer which defines the area in the receive buffer
; where bytes arriving over the Ethernet are written. This Internal Write Pointer Should Be Updated With
; the Value Stored In Erxst Whenever The Receive Buffer Start Pointer, ERXST, or the Receive Buffer		
; End Pointer, ERXND, is written to by the host microcontroller. Sometimes, when ERXST or				
; ERXND is written to, the exact value, 0000h, is stored in the internal receive Write Pointer instead
; of the ERXST address.																					
; Work around:																							
; Use the lower segment of the buffer memory for the receive buffer, starting at address 0000h. For		
; example, use the range (0000h to n) for the receive buffer and ((n + 1) to 8191) for the transmit buffer.
;.equ Txstart_init = 0x0000                                 ; start TX buffer at 0
;.equ Rxstart_init = 0x1A19                                 ; give TX buffer space for one full ethernet frame (~1500 bytes)
;.equ Rxstop_init  = 0x1FF0                                 ; receive buffer gets the rest



; ENC28J60 Errata !!!
; Module: Memory (Ethernet Buffer)
; The receive hardware may corrupt the circular receive buffer (including the Next Packet Pointer
; and receive status vector fields) when an even value is programmed into the ERXRDPTH:ERXRDPTL
; registers.
; Work around
; Ensure that only odd addresses are written to the ERXRDPT registers. Assuming that ERXND contains
; An Odd Value , Many Applications Can Derive A Suitable Value To Write To Erxrdpt By Subtracting
; One From The Next Packet Pointer(a Value Alwaysensured To Be Even Because Of Hardware Padding)
; and then compensating for a potential ERXST to ERXND wrap-around. Assuming that the receive
; Buffer Area Does Not Span The 1fffh To 0000h Memory Boundary , The Logic In Example 2 Will Ensure That
; Erxrdpt Is Programmed With An Odd Value:
;.equ Rxstart_init = 0x0000                                 ; Receive Buffer Start bei 0x0000
;.equ Rxstop_init  = 0x1A0C                                 ; Receive Buffer End bei 0x1A0C, Receive Buffer hat den Rest
;.equ Txstart_init = 0x1A0D                                 ; Transmitt Buffer Start bei 0x1A0D damit Platz fr max. Lnger Ethernetframe inkl. VLAN 1522 Bytes

;.equ Rxstart_init = 0x0000                                 ; Receive Buffer Start bei 0x0000	
;.equ Rxstop_init  = 0x19FF                                 ; Receive Buffer End bei 0x19FF		
;.equ Txstart_init = 0x1A00                                 ; Transmitt Buffer Start bei 0x1A00 damit Platz fr max. Lnger Ethernetframe 1536 Bytes
;.equ Txstop_init  = 0x1FFF                                 ; Endadresse des 8kByte Buffers		

;.equ MAX_FRAMELEN = 1500 									; maximum ethernet frame length


;.equ Txstart_init = 0x0000 ' start TX buffer at 0
;.equ Rxstart_init = 0x1A19 ' give TX buffer space for one full ethernet frame (~1500 bytes)
;.equ Rxstop_init = &H1FF0 ' receive buffer gets the rest


