; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_MAC_EIGENE_TEMP1_6:
	ldi temp1,(MACeigene0)
	ldi temp2,(MACeigene1)
	ldi temp3,(MACeigene2)
	ldi temp4,(MACeigene3)
	ldi temp5,(MACeigene4)
	ldi temp6,(MACeigene5)
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_IP_EIGENE_TEMP1_4:
	LDS temp1,(adr_IP_EIGENE0)
	LDS temp2,(adr_IP_EIGENE1)
	LDS temp3,(adr_IP_EIGENE2)
	LDS temp4,(adr_IP_EIGENE3)
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; "favicon.ico"																	
FUNCTION_SEARCH_favicon_ICO_C:
	ldi ZL,LOW (TCPdata)
	ldi ZH,HIGH(TCPdata)
	ldi temp9,255
FUNCTION_SEARCH_favicon_ICO_C_S:
	dec temp9
	breq FUNCTION_SEARCH_FAVICON_ICO_C_NOT_FOUND
	LD temp,Z+
	cpi temp,'f'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'a'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'v'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'i'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'c'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'o'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
	LD temp,Z+
	cpi temp,'n'
	brne FUNCTION_SEARCH_favicon_ICO_C_S
FUNCTION_SEARCH_FAVICON_ICO_C_FOUND:
	SEC 			;Set Carry
	ret
FUNCTION_SEARCH_FAVICON_ICO_C_NOT_FOUND:
	CLC 			;Clear Carry
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_MAKE_NEW_MAC_HEADER:
	LDS temp1,(SourceMACaddr0)	; SourceMACaddr nach DestinationMACaddr
	LDS temp2,(SourceMACaddr1)
	LDS temp3,(SourceMACaddr2)
	LDS temp4,(SourceMACaddr3)
	LDS temp5,(SourceMACaddr4)
	LDS temp6,(SourceMACaddr5)
	STS(DestinationMACaddr0),temp1
	STS(DestinationMACaddr1),temp2
	STS(DestinationMACaddr2),temp3
	STS(DestinationMACaddr3),temp4
	STS(DestinationMACaddr4),temp5
	STS(DestinationMACaddr5),temp6
	ldi temp1,(MACeigene0)		; SourceMACaddr							
	ldi temp2,(MACeigene1)
	ldi temp3,(MACeigene2)
	ldi temp4,(MACeigene3)
	ldi temp5,(MACeigene4)
	ldi temp6,(MACeigene5)
	STS(SourceMACaddr0),temp1
	STS(SourceMACaddr1),temp2
	STS(SourceMACaddr2),temp3
	STS(SourceMACaddr3),temp4
	STS(SourceMACaddr4),temp5
	STS(SourceMACaddr5),temp6
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_MAKE_NEW_IP4_HEADER:
	; IP4TTL									
	LDS temp,(IP4TTL)
	dec temp
	STS(IP4TTL),temp
	; IP4SourceIPaddr0 <-->IP4DestinationIPaddr
	LDS temp1,(IP4SourceIPaddr3)
	LDS temp2,(IP4SourceIPaddr2)
	LDS temp3,(IP4SourceIPaddr1)
	LDS temp4,(IP4SourceIPaddr0)
	LDS temp5,(IP4DestinationIPaddr3)
	LDS temp6,(IP4DestinationIPaddr2)
	LDS temp7,(IP4DestinationIPaddr1)
	LDS temp8,(IP4DestinationIPaddr0)

	STS(IP4SourceIPaddr3),temp5
	STS(IP4SourceIPaddr2),temp6
	STS(IP4SourceIPaddr1),temp7
	STS(IP4SourceIPaddr0),temp8
	STS(IP4DestinationIPaddr3),temp1
	STS(IP4DestinationIPaddr2),temp2
	STS(IP4DestinationIPaddr1),temp3
	STS(IP4DestinationIPaddr0),temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_MAKE_NEW_TCP_HEADER:
	; sourcePort<-->destinationPort
	LDS temp1,(TCPsourcePortL)
	LDS temp2,(TCPsourcePortH)
	LDS temp3,(TCPdestinationPortL)
	LDS temp4,(TCPdestinationPortH)
	STS(TCPdestinationPortL),temp1
	STS(TCPdestinationPortH),temp2
	STS(TCPsourcePortL),temp3
	STS(TCPsourcePortH),temp4
	; Windows Size		
	ldi temp1,LOW (1000)
	ldi temp2,HIGH(1000)
	STS(TCPwindowSizeL),temp1
	STS(TCPwindowSizeH),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_IP4HEADER_CHECKSUM:
	STS(IP4HeaderChecksumL),NULL		; NULL				
	STS(IP4HeaderChecksumH),NULL
	ldi ZL,LOW (IP4VersionHeaderLength)	; Zeiger-Data		
	ldi ZH,HIGH(IP4VersionHeaderLength)
	ldi XL,LOW (20)						; X (Anzahl DATA)	
	ldi XH,HIGH(20)
	call FUNCTION_CHECKSUM_XYZ			; Berechnung		
	STS(IP4HeaderChecksumL),YL			; new Checksum		
	STS(IP4HeaderChecksumH),YH
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INP: 	X Anzahl Bytes															
;		Z Zeiger																
; OUT:	Y CHECKSUM																
FUNCTION_CHECKSUM_XYZ:
	sbrc XL,0					; Schleife aufrunden ?	
	adiw XL,1					; +1					
	LSR XH						; Bytes--> Word			
	ROR XL
	clr YL						; CHECKSUM		
	clr YH
FUNCTION_CHECKSUM16_s:
	LD R1,Z+					; 16-bit word	
	LD R0,Z+
	add YL,R0					; addieren		
	adc YH,R1
	brcc FUNCTION_CHECKSUM16_w	; Carry			
	add YL,EINS		
	adc YH,NULL
FUNCTION_CHECKSUM16_w:
	sbiw XL,1					; Schleife		
	tst XL
	brne FUNCTION_CHECKSUM16_s
	tst XH
	brne FUNCTION_CHECKSUM16_s
	com	YL 						; invertieren	
	com	YH
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Pseudoheader basteln (IPv4)													
FUNCTION_TCP_PSEUDOHEADER_CHECKSUM:
	clr YL								; CHECKSUM		
	clr YH
	STS(TCPchecksumL),NULL				; NULL				
	STS(TCPchecksumH),NULL	
	; IP-Absenderadresse	
	LDS R1,(IP4SourceIPaddr3)
	LDS R0,(IP4SourceIPaddr2)
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	LDS R1,(IP4SourceIPaddr1)
	LDS R0,(IP4SourceIPaddr0)
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	; IP-Empfngeradresse
	LDS R1,(IP4DestinationIPaddr3)
	LDS R0,(IP4DestinationIPaddr2)
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	LDS R1,(IP4DestinationIPaddr1)
	LDS R0,(IP4DestinationIPaddr0)
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	; 0x0006 (=TCP) 	
	ldi temp2,HIGH(0x0006)
	ldi temp1,LOW (0x0006)
	mov R1,temp2
	mov R0,temp1
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	; Lnge des TCP-Segments mit TCP-Header
	LDS XL,(IP4TotalLengthL)
	LDS XH,(IP4TotalLengthH)
	sbiw XL,20 					; -20(IPv4-Header)		
	mov R1,XH
	mov R0,XL
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
;-------------------------------------------------------------------------------
	; Schleife initialisieren			
	LDS XL,(IP4TotalLengthL)
	LDS XH,(IP4TotalLengthH)
	sbiw XL,20					; -20(IPv4-Header)		

	sbrc XL,0					; Schleife aufrunden ?	
	adiw XL,1					; +1					
	LSR XH						; Bytes--> Word			
	ROR XL
	ldi ZL,LOW (TCPsourcePortH)	; Zeiger-Data		
	ldi ZH,HIGH(TCPsourcePortH)
FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_s:
	LD R1,Z+					; 16-bit word	
	LD R0,Z+
	rcall FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD
	sbiw XL,1					; Schleife		
	tst XL
	brne FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_s
	tst XH
	brne FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_s
	com	YL 						; invertieren	
	com	YH
	STS(TCPchecksumL),YL		; CHECKSUM		
	STS(TCPchecksumH),YH
ret
;-------------------------------------------------------------------------------
FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD:
	add YL,R0										; addieren		
	adc YH,R1
	brcc FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD_w	; Carry			
	add YL,EINS		
	adc YH,NULL
FUNCTION_TCP_PSEUDOHEADER_CHECKSUM_WORD_w:
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_TCP_NEXT_ACK_NR:
	LDS  temp1,(TCPHeaderLength)
	swap temp1
	andi temp1,0b00001111
	ldi  temp,32
	mul temp,temp1
	LSR R0
	LSR R0
	LSR R0
	mov temp3,R0

	LDS ZL,(IP4TotalLengthL)
	LDS ZH,(IP4TotalLengthH)
	sub ZL,temp3
	sbc ZH,NULL
	sbiw ZL,20

	STS(adr_TCP_DATA_LENGTH_L),ZL
	STS(adr_TCP_DATA_LENGTH_H),ZH
;-------------------------------------------------------------------------------
	; Next ACK Nr		
	LDS temp1,(TcpSeq0)
	LDS temp2,(TcpSeq1)
	LDS temp3,(TcpSeq2)
	LDS temp4,(TcpSeq3)

	LDS temp5,(adr_TCP_DATA_LENGTH_L)
	LDS temp6,(adr_TCP_DATA_LENGTH_H)

	add temp1,temp5
	adc temp2,temp6
	adc temp3,NULL
	adc temp4,NULL

	STS(adr_TCP_NEXT_ACK_0),temp1
	STS(adr_TCP_NEXT_ACK_1),temp2
	STS(adr_TCP_NEXT_ACK_2),temp3
	STS(adr_TCP_NEXT_ACK_3),temp4


ret
; ##############################################################################
; ##############################################################################
; ##############################################################################


