; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_INITIALISIERUNG:
	call ENC_WAIT_CLKRDY	; wait CLKRDY	
	call ENC_SOFT_RESET		; Reset			
	call ENC_LED_BLINKEN_ON
	call WAIT_1s
	call ENC_LED_BLINKEN_OFF
	call ENC_INITIALISIERUNG_REGISTER
	call ENC_INITIALISIERUNG_PHY
	call ENC_MAC_ADRESSE_CHECK	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_WAIT_CLKRDY:
	; ESTAT.CLKRDY	
	ldi temp1,(ESTAT)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	andi temp1,0b00000011
	cpi  temp1,0b00000001
	brne ENC_WAIT_CLKRDY_ERROR
	ret
;-------------------------------------------------------------------------------
ENC_WAIT_CLKRDY_ERROR:
	call WAIT_100ms								; nochmal Reset
	call ENC_SOFT_RESET
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	call WAIT_50ms
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus  
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	call WAIT_50ms
rjmp ENC_WAIT_CLKRDY
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Reset ber SPI																
ENC_SOFT_RESET:
	call SPI_CS_LOW							; CS auf LOW	
	ldi temp1,(soft_reset)					; RESET			
	call SPI_TX_TEMP1						; TX			
	sbi (SPI_CS_PORT),(SPI_CS_PIN_NR)		; CS auf HIGH	
	call WAIT_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_LED_BLINKEN_ON:
	ldi temp1,(PHLCON)
	ldi temp2,LOW (0x0AA2)
	ldi temp3,HIGH(0x0AA2)
	call ENC_WCR_PHY_TEMP1_TEMP2_TEMP3				; INP: temp1(phy.addr) temp2+3(data)			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_LED_BLINKEN_OFF:
	ldi temp1,(PHLCON)
	ldi temp2,LOW (0x3422); 0011 0100 0010 001x
	ldi temp3,HIGH(0x3422)
	call ENC_WCR_PHY_TEMP1_TEMP2_TEMP3				; INP: temp1(phy.addr) temp2+3(data)			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_INITIALISIERUNG_REGISTER:
	ldi ZL,LOW (ENC_TABELLE_INITIALISIERUNG*2)
	ldi ZH,HIGH(ENC_TABELLE_INITIALISIERUNG*2)
ENC_INITIALISIERUNG_REGISTER_s:
	LPM temp1,Z+							; aus Tabelle laden und Zeiger um 1 erhhen		
	cpi temp1,0xFF							; Tabellenende ?								
	brne ENC_INITIALISIERUNG_REGISTER_w
	ret
ENC_INITIALISIERUNG_REGISTER_w:
	LPM temp2,Z+							; aus Tabelle laden und Zeiger um 1 erhhen		
	call ENC_WCR_TEMP1_TEMP2				; INP: temp1(cod+addr) temp2(data)				
	call ENC_WCR_CHECK_TEMP1_TEMP2 			; INP: temp1(cod+addr) temp2(data)				
	rjmp ENC_INITIALISIERUNG_REGISTER_s
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_INITIALISIERUNG_PHY:
	ldi ZL,LOW (ENC_TABELLE_INITIALISIERUNG_PHY*2)
	ldi ZH,HIGH(ENC_TABELLE_INITIALISIERUNG_PHY*2)
ENC_INITIALISIERUNG_PHY_s:
	LPM temp1, Z+							; LOW aus Tabelle laden und Zeiger um 1 erhhen		
	cpi temp1,0xFF							; Tabellenende ?								
	brne ENC_INITIALISIERUNG_PHY_w
	ret
ENC_INITIALISIERUNG_PHY_w:
	LPM temp , Z+   						; DUMMY aus Tabelle laden und Zeiger um 1 erhhen	
	LPM temp2, Z+   						; LOW aus Tabelle laden und Zeiger um 1 erhhen		
	LPM temp3, Z+   						; HIGH aus Tabelle laden und Zeiger um 1 erhhen	
	call ENC_WCR_PHY_TEMP1_TEMP2_TEMP3		; INP: temp1(phy.addr) temp2+3(data)			
	rjmp ENC_INITIALISIERUNG_PHY_s
; ##############################################################################
; ##############################################################################
; ##############################################################################
.equ Rxstart_init = 0x0000                	; Receive Buffer Start bei 0x0000	
.equ Rxstop_init  = 0x19FF                  ; Receive Buffer End bei 0x19FF		
.equ Txstart_init = 0x1A00                  ; Transmitt Buffer Start bei 0x1A00 damit Platz fr max. Lnger Ethernetframe 1536 Bytes
.equ Txstop_init  = 0x1FFF                  ; Endadresse des 8kByte Buffers		
.equ MAX_FRAMELEN = 1550 					; maximum ethernet frame length		

ENC_TABELLE_INITIALISIERUNG:
.db ERXSTL,Low (RXstart_init)						; RX-Buffer Start		
.db ERXSTH,HIGH(RXstart_init)

.db ERXNDL,Low (RXstop_init)						; RX-Buffer End			
.db ERXNDH,HIGH(RXstop_init)

.db ERDPTL,Low (RXstart_init)						; RX-Read Pointer			
.db ERDPTH,HIGH(RXstart_init)

.db ETXSTL,Low (TXstart_init)						; TX-Buffer Start		
.db ETXSTH,HIGH(TXstart_init)

.db MACON1,(1<<MACON1_TXPAUS)|(1<<MACON1_RXPAUS)|(0<<MACON1_PASSALL)|(1<<MACON1_MARXEN)
.db	MACON3,(1<<MACON3_PADCFG2)+(1<<MACON3_PADCFG0)	; Padding 60Byte + CRC
.db	MACON4,(1<<MACON4_DEFER)						; IEEE 802.3
.db MAMXFLL,LOW (MAX_FRAMELEN)
.db MAMXFLH,HIGH(MAX_FRAMELEN)
.db	MABBIPG,0x12									; 
.db	MAIPGL, 0x12									; 
.db	MAIPGH, 0x0C									; 
.db	MAADR1,MACeigene0						
.db	MAADR2,MACeigene1						
.db	MAADR3,MACeigene2
.db	MAADR4,MACeigene3
.db	MAADR5,MACeigene4
.db	MAADR6,MACeigene5						
.db EIE,(1<<EIE_INTIE)| (0<<EIE_PKTIE)|(0<<EIE_DMAIE)|(0<<EIE_LINKIE)|(0<<EIE_TXIE)|(0<<EIE_TXERIE)|(1<<EIE_RXERIE)
.db	ECON2,(1<<ECON2_AUTOINC)
.db ECON1,(0<<ECON1_TXRST)|(0<<ECON1_RXRST)|(0<<ECON1_DMAST)|(0<<ECON1_CSUMEN)|(0<<ECON1_TXRTS)|(1<<ECON1_RXEN)|(0<<ECON1_BSEL1)|(0<<ECON1_BSEL0)
.db ECOCON,(0<<ECOCON_COCON2)|(0<<ECOCON_COCON1)|(0<<ECOCON_COCON0)
.db	0xFF,0xFF	; Ende Tabelle
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_TABELLE_INITIALISIERUNG_PHY:
.dw PHCON2,0x0100
.dw PHLCON,0x31C2	; LEDs			
.dw 0xFFFF,0xFFFF	; Ende Tabelle	

