;--- Flag-Werte ------------------------------------------------
.equ FLAG_ETH_ARP			= 0
.equ FLAG_ETH_IDCMP			= 1
.equ FLAG_ETH_TCP			= 2
.equ FLAG_TCP_HTTP			= 4
; Typen															
.equ ETH_TYP_ARP			= 0x0806
.equ ETH_TYP_IP				= 0x0800
.equ IP_TYP_ICMP			= 1
.equ IP_TYP_TCP				= 6
; Protokollaufbau (MAC-HEADER 14Bytes)													
.equ DestinationMACaddr0	= adr_ENC_DATA+0														
.equ DestinationMACaddr1	= adr_ENC_DATA+1														
.equ DestinationMACaddr2	= adr_ENC_DATA+2														
.equ DestinationMACaddr3	= adr_ENC_DATA+3														
.equ DestinationMACaddr4	= adr_ENC_DATA+4														
.equ DestinationMACaddr5	= adr_ENC_DATA+5														
.equ SourceMACaddr0			= adr_ENC_DATA+6													
.equ SourceMACaddr1			= adr_ENC_DATA+7														
.equ SourceMACaddr2			= adr_ENC_DATA+8														
.equ SourceMACaddr3			= adr_ENC_DATA+9														
.equ SourceMACaddr4			= adr_ENC_DATA+10														
.equ SourceMACaddr5			= adr_ENC_DATA+11														
.equ PacketTypH				= adr_ENC_DATA+12	; 0x0806=ARP 
.equ PacketTypL				= adr_ENC_DATA+13															
; Protokollaufbau (ARP-HEADER)													
.equ ARPhwtypeH				= adr_ENC_DATA+14	; 0x0001 	
.equ ARPhwtypeL				= adr_ENC_DATA+15
.equ ARPprotokollTypH		= adr_ENC_DATA+16	; 0x0800 	
.equ ARPprotokollTypL		= adr_ENC_DATA+17															
.equ ARPhardwareLen			= adr_ENC_DATA+18	; 0x06		
.equ ARPprotokollLen		= adr_ENC_DATA+19	; 0x04		
.equ ARPoperationCodeH		= adr_ENC_DATA+20	; 0x0001=Request 0x0002=Reply	
.equ ARPoperationCodeL		= adr_ENC_DATA+21															
.equ ARPsenderMACaddr0		= adr_ENC_DATA+22															
.equ ARPsenderMACaddr1		= adr_ENC_DATA+23															
.equ ARPsenderMACaddr2		= adr_ENC_DATA+24															
.equ ARPsenderMACaddr3		= adr_ENC_DATA+25															
.equ ARPsenderMACaddr4		= adr_ENC_DATA+26															
.equ ARPsenderMACaddr5		= adr_ENC_DATA+27															
.equ ARPsenderIPAddr0		= adr_ENC_DATA+28															
.equ ARPsenderIPAddr1		= adr_ENC_DATA+29															
.equ ARPsenderIPAddr2		= adr_ENC_DATA+30															
.equ ARPsenderIPAddr3		= adr_ENC_DATA+31															
.equ ARPtargetsHardAddr0	= adr_ENC_DATA+32														
.equ ARPtargetsHardAddr1	= adr_ENC_DATA+33														
.equ ARPtargetsHardAddr2	= adr_ENC_DATA+34														
.equ ARPtargetsHardAddr3	= adr_ENC_DATA+35														
.equ ARPtargetsHardAddr4	= adr_ENC_DATA+36														
.equ ARPtargetsHardAddr5	= adr_ENC_DATA+37														
.equ ARPtargetsIPAddr0 		= adr_ENC_DATA+38															
.equ ARPtargetsIPAddr1 		= adr_ENC_DATA+39															
.equ ARPtargetsIPAddr2 		= adr_ENC_DATA+40															
.equ ARPtargetsIPAddr3		= adr_ENC_DATA+41														
;-------------------------------------------------------------------------------
; IP4-HEADER																	
.equ IP4VersionHeaderLength	= adr_ENC_DATA+14 	;(0)	(0x45=20Bytes)
.equ IP4TOS 				= adr_ENC_DATA+15 	;(1)	
.equ IP4TotalLengthH 		= adr_ENC_DATA+16 	;(2)	
.equ IP4TotalLengthL		= adr_ENC_DATA+17 	;(3)	
.equ IP4IdentificationH 	= adr_ENC_DATA+18 	;(4)	
.equ IP4IdentificationL		= adr_ENC_DATA+19 	;(5)	
.equ IP4FlagsFragmentOffset0= adr_ENC_DATA+20 	;(6)	
.equ IP4FlagsFragmentOffset1= adr_ENC_DATA+21 	;(7)	
.equ IP4TTL 				= adr_ENC_DATA+22 	;(8)	
.equ IP4ProtocolTyp			= adr_ENC_DATA+23 	;(9)	
.equ IP4HeaderChecksumH		= adr_ENC_DATA+24 	;(10)	
.equ IP4HeaderChecksumL 	= adr_ENC_DATA+25	;(11)	
.equ IP4SourceIPaddr3		= adr_ENC_DATA+26	;(12)	
.equ IP4SourceIPaddr2		= adr_ENC_DATA+27	;(13)	
.equ IP4SourceIPaddr1		= adr_ENC_DATA+28	;(14)	
.equ IP4SourceIPaddr0		= adr_ENC_DATA+29	;(15)	
.equ IP4DestinationIPaddr3 	= adr_ENC_DATA+30	;(16)	
.equ IP4DestinationIPaddr2 	= adr_ENC_DATA+31	;(17)	
.equ IP4DestinationIPaddr1 	= adr_ENC_DATA+32	;(18)	
.equ IP4DestinationIPaddr0 	= adr_ENC_DATA+33	;(19)	
;-------------------------------------------------------------------------------
; ICMP																			
.equ ICMPtype				= adr_ENC_DATA+34
.equ ICMPcode				= adr_ENC_DATA+35
.equ ICMPchecksumH			= adr_ENC_DATA+36
.equ ICMPchecksumL			= adr_ENC_DATA+37
.equ ICMPidentifferH		= adr_ENC_DATA+38
.equ ICMPidentifferL		= adr_ENC_DATA+39
.equ ICMPsequencenumberH	= adr_ENC_DATA+40
.equ ICMPsequencenumberL	= adr_ENC_DATA+41
.equ ICMPdata				= adr_ENC_DATA+42
;-------------------------------------------------------------------------------
; TCP (http://www.elektronik-kompendium.de/sites/net/0812271.htm)				
.equ TCPsourcePortH			= adr_ENC_DATA+34	;(0) Hier steht der Quell-Port, von der die Anwendung das TCP-Paket verschickt. Bei einer Stellenanzahl von 16 Bit betrgt der hchste Port 65.535. 
.equ TCPsourcePortL			= adr_ENC_DATA+35	;(1) 
.equ TCPdestinationPortH	= adr_ENC_DATA+36	;(2) Hier steht der Ziel-Port, ber welchen das TCP-Paket der Anwendung zugestellt wird. Bei einer Stellenanzahl von 16 Bit betrgt der hchste Port 65.535. 
.equ TCPdestinationPortL	= adr_ENC_DATA+37	;(3) 
.equ TcpSeq3				= adr_ENC_DATA+38	;(4)Bei jeder TCP-Verbindung werden Nummern zwischen den Kommunikationspartner ausgehandelt. Whrend der Verbindung werden diese Nummern verwendet um die TCP-Pakete eindeutig zu identifizieren. 
.equ TcpSeq2				= adr_ENC_DATA+39	;(5) 
.equ TcpSeq1				= adr_ENC_DATA+40	;(6) 
.equ TcpSeq0				= adr_ENC_DATA+41	;(7) 
.equ TcpAck3				= adr_ENC_DATA+42	;(8)Alle Datenpakete werden besttigt. Dazu dient das ACK-Flag und die Acknowledgement-Nummer, die sich aus der Sequenz-Nummer und der Anzahl von empfangenen Bytes errechnet. Damit kann der Sender feststellen, ob die Daten beim Empfnger vollstndig angekommen sind. 
.equ TcpAck2				= adr_ENC_DATA+43	;(9) 
.equ TcpAck1				= adr_ENC_DATA+44	;(10)
.equ TcpAck0				= adr_ENC_DATA+45	;(11)
.equ TCPHeaderLength		= adr_ENC_DATA+46	;(12) Anzahl der 32-Bit-Blcke des TCP-Headers
.equ TCPflags				= adr_ENC_DATA+47	;(13) Kennzeichnung bestimmter fr die Kommunikation und Weiterverarbeitung der Daten wichtiger Zustnde (URG, ACK, PSH, RST, SYN, FIN). 
.equ TCPwindowSizeH			= adr_ENC_DATA+48	;(14) Der Empfnger sendet dem Sender in diesem Feld die Anzahl an Daten, die der Sender senden darf. Dadurch wird das berlaufen des Empfangspuffers beim Empfnger verhindert. Den Vorgang nennt man Windowing und dient der Datenflusssteuerung. 
.equ TCPwindowSizeL			= adr_ENC_DATA+49	;(15)
.equ TCPchecksumH			= adr_ENC_DATA+50	;(16) Dieses Feld dient der Kontrolle von Header- und Datenbereich. https://de.wikipedia.org/wiki/Transmission_Control_Protocol
.equ TCPchecksumL			= adr_ENC_DATA+51	;(17)
.equ TCPurgentPointerH		= adr_ENC_DATA+52	;(18) Zusammen mit der Sequenz-Nummer gibt dieser Wert die genaue Position der Daten im Datenstrom an. Der Wert ist nur gltig, wenn das URG-Flag gesetzt ist. 
.equ TCPurgentPointerL		= adr_ENC_DATA+53	;(19)
.equ TCPdata				= adr_ENC_DATA+54	;(20)

; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_RX:
	ldi temp1,(EPKTCNT)	; Ethernet Packet Count
	call ENC_RCR_TEMP1	; INP: temp1(cod+addr) OUT: temp1(data)			
	tst temp1
	brne ENC_RX_RUN
	ret
;-------------------------------------------------------------------------------
ENC_RX_RUN:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	ldi temp,(MODUL_RX)							; MODUL		
	STS(adr_MODUL_NR),temp
	LDS R0,(adr_ENC_RX_PAKET_COUNTER_L)			; Counter	
	LDS R1,(adr_ENC_RX_PAKET_COUNTER_H)
	add R0,EINS
	adc R1,NULL
	STS(adr_ENC_RX_PAKET_COUNTER_L),R0
	STS(adr_ENC_RX_PAKET_COUNTER_H),R1
;-------------------------------------------------------------------------------
; set the read pointer to the start of the received packet						
	ldi temp1,(ERDPTL)							; Read Pointer(L) 
	LDS temp2,(adr_ENC_RX_NEXT_READ_POINTER_L)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)	
	ldi temp1,(ERDPTH)							; Read Pointer(H)
	LDS temp2,(adr_ENC_RX_NEXT_READ_POINTER_H)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)	
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW			
	ldi temp1,(RBM)								; Read Buffer Memory	
	call SPI_TX_TEMP1							; TX (Opcode+Address)	
;-------------------------------------------------------------------------------
	call SPI_RX_TEMP1							; Next Read Pointer(L) 	
	STS(adr_ENC_RX_NEXT_READ_POINTER_L),temp1
	call SPI_RX_TEMP1							; Next Read Pointer(H) 	
	STS(adr_ENC_RX_NEXT_READ_POINTER_H),temp1
	call SPI_RX_TEMP1							; length of the received frame(L)
	STS(adr_ENC_RX_FRAME_LENGTH_L),temp1
	call SPI_RX_TEMP1							; length of the received frame(H)
	STS(adr_ENC_RX_FRAME_LENGTH_H),temp1
	call SPI_RX_TEMP1							; RX-DUMMY (Status)				
	call SPI_RX_TEMP1							; RX-DUMMY (Status)				
;-------------------------------------------------------------------------------
; Nutzdaten (RX_FRAME_LENGTH) herausfiltern										
	LDS XL,(adr_ENC_RX_FRAME_LENGTH_L)			; X-Schleife					
	LDS XH,(adr_ENC_RX_FRAME_LENGTH_H)
	sbiw XL,4 									; -4
	STS(adr_ENC_RX_FRAME_LENGTH_L),XL			; X-Schleife					
	STS(adr_ENC_RX_FRAME_LENGTH_H),XH
;-------------------------------------------------------------------------------
; ERROR FRAME_LENGTH NULL ?														
	tst XL
	brne ENC_RX_NULL_OK
	tst XH
	brne ENC_RX_NULL_OK
	; ERROR							
	call ENC_RX_ERROR_COUNTER					; ERROR-COUNTER	
	ldi XL,LOW (MAX_FRAMELEN)
	ldi XH,HIGH(MAX_FRAMELEN)
	STS(adr_ENC_RX_FRAME_LENGTH_L),XL			; X-Schleife	
	STS(adr_ENC_RX_FRAME_LENGTH_H),XH
ENC_RX_NULL_OK:
;-------------------------------------------------------------------------------
; ERROR FRAME_LENGTH MAX ?														
	cpi XH,HIGH(MAX_FRAMELEN)
	brlo ENC_RX_MAX_OK
	breq ENC_RX_MAX_w
	rjmp ENC_RX_MAX_ERROR
ENC_RX_MAX_w:
	cpi XL,LOW (MAX_FRAMELEN)
	brlo ENC_RX_MAX_OK
	breq ENC_RX_MAX_OK
	rjmp ENC_RX_MAX_ERROR
ENC_RX_MAX_ERROR:
	; ERROR							
	call ENC_RX_ERROR_COUNTER					; ERROR-COUNTER	
	ldi XL,LOW (MAX_FRAMELEN)
	ldi XH,HIGH(MAX_FRAMELEN)
	STS(adr_ENC_RX_FRAME_LENGTH_L),XL			; X-Schleife					
	STS(adr_ENC_RX_FRAME_LENGTH_H),XH
ENC_RX_MAX_OK:
;-------------------------------------------------------------------------------
	ldi ZL,LOW (adr_ENC_DATA)					; Z-initialisieren				
	ldi ZH,HIGH(adr_ENC_DATA)	
ENC_RX_s:
	call SPI_RX_TEMP1							; RX DATA	
	ST Z+,temp1									; save SRAM	
	sbiw XL,1									; X-Schleife					
	tst XL
	brne ENC_RX_s	
	tst XH
	brne ENC_RX_s
;-------------------------------------------------------------------------------
	call SPI_RX_TEMP1	; RX-DUMMY (CRC)				
	call SPI_RX_TEMP1	; RX-DUMMY (CRC)				
	call SPI_RX_TEMP1	; RX-DUMMY (CRC)				
	call SPI_RX_TEMP1	; RX-DUMMY (CRC)				
;-------------------------------------------------------------------------------
	call SPI_CS_HIGH							; CS auf HIGH	
;-------------------------------------------------------------------------------
;move the rx read pointer to the start of the next received packet				
;this frees the memory we just read out											
	ldi temp1,(ERXRDPTL)	; RX RD Pointer(L) 
	LDS temp2,(adr_ENC_RX_NEXT_READ_POINTER_L)
	call ENC_WCR_TEMP1_TEMP2				; INP: temp1(cod+addr) temp2(data)	
	ldi temp1,(ERXRDPTH)	; RX RD Pointer(H)
	LDS temp2,(adr_ENC_RX_NEXT_READ_POINTER_H)
	call ENC_WCR_TEMP1_TEMP2				; INP: temp1(cod+addr) temp2(data)	
;-------------------------------------------------------------------------------
; decrement the packet counter indicate we are done with this packet			
	ldi temp1,(ECON2)	
	ldi temp2,(1<<Econ2_PKTDEC)
	call ENC_BFS_TEMP1_TEMP2				; INP: temp1(cod+addr) temp2(data)	
;-------------------------------------------------------------------------------
	call DEBUG_ENC_RX
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus	
	jmp ENC_RX_AUSWERTUNG_PAKET_TYPE
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_RX_ERROR_COUNTER:
	LDS R0,(adr_ENC_RX_PAKET_COUNTER_ERROR_L)			; Counter	
	LDS R1,(adr_ENC_RX_PAKET_COUNTER_ERROR_H)
	add R0,EINS
	adc R1,NULL
	STS(adr_ENC_RX_PAKET_COUNTER_ERROR_L),R0
	STS(adr_ENC_RX_PAKET_COUNTER_ERROR_H),R1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_RX_AUSWERTUNG_PAKET_TYPE:
	; PacketTyp (0x0806=ARP) ?					
	LDS temp1,(PacketTypL)
	LDS temp2,(PacketTypH)
	cpi temp1,LOW(ETH_TYP_ARP)
	brne ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_ARP
	cpi temp2,HIGH(ETH_TYP_ARP)
	brne ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_ARP
	ldi temp,(MODUL_RX_ARP)						; MODUL		
	STS(adr_MODUL_NR),temp
	jmp ARP										; ja
ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_ARP:
;-------------------------------------------------------------------------------
	; PacketTyp (0x0800=DoD IP) ? (Standard Internet Protocol)					
	cpi temp1,LOW(ETH_TYP_IP)
	brne ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_DoD
	cpi temp2,HIGH(ETH_TYP_IP)
	brne ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_DoD
	jmp ENC_RX_AUSWERTUNG_IPv4PROTOKOLLTYPE		; ja
ENC_RX_AUSWERTUNG_PAKET_TYPE_NO_DoD:
;-------------------------------------------------------------------------------
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; IPv4 Hader																	
ENC_RX_AUSWERTUNG_IPv4PROTOKOLLTYPE:
	; IP4HeaderLength=20Bytes ?
	LDS temp,(IP4VersionHeaderLength)
	cpi temp,(0x45)
	breq ENC_RX_AUSWERTUNG_IPv4PROTOKOLLTYPE_RUN
	ret
;-------------------------------------------------------------------------------
ENC_RX_AUSWERTUNG_IPv4PROTOKOLLTYPE_RUN:
	; ICMP ?
	LDS temp,(IP4ProtocolTyp)
	cpi temp,(IP_TYP_ICMP)
	brne ENC_RX_AUSWERTUNG_PROTOKOLLTYPE_NO_ICMP
	ldi temp,(MODUL_RX_ICMP)						; MODUL		
	STS(adr_MODUL_NR),temp
	jmp ICMP										; ja
ENC_RX_AUSWERTUNG_PROTOKOLLTYPE_NO_ICMP:
;-------------------------------------------------------------------------------
	; TCP ?
	LDS temp,(IP4ProtocolTyp)
	cpi temp,(IP_TYP_TCP)
	brne ENC_RX_AUSWERTUNG_PROTOKOLLTYPE_NO_TCP
	ldi temp,(MODUL_RX_TCP)							; MODUL		
	STS(adr_MODUL_NR),temp
	jmp TCP
ENC_RX_AUSWERTUNG_PROTOKOLLTYPE_NO_TCP:
;-------------------------------------------------------------------------------
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################


