;																									
;																									
; call ENC_BFS_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; call ENC_BFC_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
; call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; call ENC_WCR_CHECK_TEMP1_TEMP2 					; INP: temp1(cod+addr) temp2(data)				
; call ENC_RCR_PHY_TEMP1_TEMP2						; INP: temp1(phy.addr) OUT: temp1+2(data)		
; call ENC_WCR_PHY_TEMP1_TEMP2_TEMP3				; INP: temp1(phy.addr) temp2+3(data)			
;																				
;																				
; ##############################################################################
; ##############################################################################
; ##############################################################################
; The Bit Field Set (BFS) command is used to set up to 8 bits 					
; in any of the ETH Control registers.											
;																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP= Codierung MAC/PHY indicator 0/1)								
;           a4-a0= Addresse														
;																				
; INP: temp2 (Data Byte)														
;																				
ENC_BFS_TEMP1_TEMP2:
	SBRS temp1,5								; MAC/PHY indicator
	rjmp ENC_BFS_TEMP1_TEMP2_RUN
;-------------------------------------------------------------------------------
	ldi temp,(ERROR_ENC_BFS)						; ERROR				
	call ERROR_SAVE_TEMP
	ret
;-------------------------------------------------------------------------------
ENC_BFS_TEMP1_TEMP2_RUN:
	rcall ENC_BANK_SWITCH_TEMP1					; Bankumschaltung		
;-------------------------------------------------------------------------------
	andi temp1,0b00011111						; Bitmuster (Addresse)			
	ori  temp1,(BFS)			; Bitmuster (Bit Field Set)		
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW	
	call SPI_TX_TEMP1							; TX (Opcode+Address)			
	call SPI_TX_TEMP2							; TX (Data Byte)			
	call SPI_CS_HIGH							; CS auf HIGH	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; The Bit Field Clear (BFC) command is used to clear up							
; to 8 bits in any of the ETH Control registers.								
;																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP= Codierung MAC/PHY indicator 0/1)								
;           a4-a0= Addresse														
;																				
; INP: temp2 (Data Byte)														
;																				
ENC_BFC_TEMP1_TEMP2:
	SBRS temp1,5								; MAC/PHY indicator
	rjmp ENC_BFC_TEMP1_TEMP2_RUN
;-------------------------------------------------------------------------------
	ldi temp,(ERROR_ENC_BFC)					; ERROR				
	call ERROR_SAVE_TEMP
	ret
;-------------------------------------------------------------------------------
ENC_BFC_TEMP1_TEMP2_RUN:
	rcall ENC_BANK_SWITCH_TEMP1					; Bankumschaltung		
;-------------------------------------------------------------------------------
	andi temp1,0b00011111						; Bitmuster (Addresse)			
	ori  temp1,(BFC)			; Bitmuster (Bit Field Clear)	
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW	
	call SPI_TX_TEMP1							; TX (Opcode+Address)			
	call SPI_TX_TEMP2							; TX (Data Byte)			
	call SPI_CS_HIGH							; CS auf HIGH	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; RCR-READ CONTROL REGISTER														
; 																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP= Codierung MAC/PHY indicator 0/1)								
;           a4-a0= Addresse														
;																				
; OUT: temp1																	
; 																				
ENC_RCR_TEMP1:
	rcall ENC_BANK_SWITCH_TEMP1					; Bankumschaltung		
;-------------------------------------------------------------------------------
	push temp1
	andi temp1,0b00011111						; Bitmuster (Adresse)	
	ori  temp1,(RCR)							; Bitmuster (Read Control Register)
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW			
	call SPI_TX_TEMP1							; TX 					
;-------------------------------------------------------------------------------
	pop temp1
	SBRC temp1,5								; MAC/PHY indicator		
	call SPI_TX_DUMMY							; TX (DUMMY)(MAC/PHY)	; Achtung: MAC und MII REGISTER werden mit einem extra DUMMY ausgelesen.		
;-------------------------------------------------------------------------------
	call SPI_RX_TEMP1							; RX 					
	call SPI_CS_HIGH							; CS auf HIGH			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; WCR-WRITE CONTROL REGISTER													
;																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP= Codierung MAC/PHY indicator 0/1)								
;           a4-a0= Addresse														
;																				
; INP: temp2 (Data Byte)														
;																				
ENC_WCR_TEMP1_TEMP2:
	push temp1
	push temp2
;-------------------------------------------------------------------------------
	rcall ENC_BANK_SWITCH_TEMP1					; Bankumschaltung		
;-------------------------------------------------------------------------------
	andi temp1,0b00011111						; Bitmuster (Addresse)			
	ori  temp1,(WCR)							; Bitmuster (Write Control Register)
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW	
	call SPI_TX_TEMP1							; TX (Opcode+Address)			
	call SPI_TX_TEMP2							; TX (Data Byte)			
	call SPI_CS_HIGH							; CS auf HIGH	
;-------------------------------------------------------------------------------
	pop temp2
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; WCR-WRITE CONTROL REGISTER - CHECK											
;																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP= Codierung MAC/PHY indicator 0/1)								
;           a4-a0= Addresse														
;																				
; INP: temp2 (Data Byte)														
;																				
ENC_WCR_CHECK_TEMP1_TEMP2:
	push temp1
	push temp2
	push temp3
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	mov temp3,temp1
	cp temp1,temp3
	brne ENC_WCR_CHECK_ERROR
	pop temp3
	pop temp2
	pop temp1
	ret
;-------------------------------------------------------------------------------
ENC_WCR_CHECK_ERROR:
	pop temp3
	pop temp2
	pop temp1
;-------------------------------------------------------------------------------
	ldi temp,(ERROR_CONTROL_REGISTER_CHECK)					; ERROR				
	call ERROR_SAVE_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Die aktuelle Bank wird im ECON1 definiert										
; ECON1: TXRST RXRST DMAST CSUMEN TXRTS RXEN BSEL1 BSEL0						
;																				
; INP: temp1 (Codierungen+Addresse)												
; 			CB1-CB0-CMP-a4-a3-a2-a1-a0											
; 			CB1= Codierung Bank (0...3)											
; 			CB0= Codierung Bank (0...3)											
; 			CMP = Codierung MAC/PHY indicator 0/1)								
;          a4-a0= Addresse														
;																				
ENC_BANK_SWITCH_TEMP1:
	; Ausnahmen (All-bank registers)			
	cpi temp1,(ECON1)
	breq ENC_BANK_SWITCH_FERTIG
	cpi temp1,(ECON2)
	breq ENC_BANK_SWITCH_FERTIG
	cpi temp1,(EIE)
	breq ENC_BANK_SWITCH_FERTIG
	cpi temp1,(EIR)
	breq ENC_BANK_SWITCH_FERTIG
	cpi temp1,(ESTAT)
	breq ENC_BANK_SWITCH_FERTIG
	rjmp ENC_BANK_SWITCH_RUN
;-------------------------------------------------------------------------------
ENC_BANK_SWITCH_FERTIG:
	ret
;-------------------------------------------------------------------------------
ENC_BANK_SWITCH_RUN:
	; Bit 1+0 im ECON1 clear	
	push temp1									
	ldi temp1,(ECON1)							; (ECON1)						
	andi temp1,0b00011111						; Bitmuster (Addresse)			
	ori  temp1,0b10100000						; Bitmuster (Bit Field Clear)	
	call SPI_CS_LOW							; CS auf LOW					
	call SPI_TX_TEMP1							; TX (Opcode+Address)			
	ldi temp1,0b00000011						; Codierung Bank (0...3)		
	call SPI_TX_TEMP1							; TX (Data Byte)				
	call SPI_CS_HIGH							; CS auf HIGH					
	pop temp1
;-------------------------------------------------------------------------------
	; Bit 1+0 im ECON1 SET														
	push temp1
	ldi temp1,(ECON1)							; (ECON1)						
	ori  temp1,0b10000000						; Bitmuster (Bit Field SET)		
	cbi (SPI_CS_PORT),(SPI_CS_PIN_NR)			; CS auf LOW					
	call SPI_TX_TEMP1							; TX 							
	pop temp1
;-------------------------------------------------------------------------------
	push temp1
	push temp2
	clr temp2
	SBRC temp1,6								; Codierung Bank (0...3)
	ori temp2,1	; +1
	SBRC temp1,7								; Codierung Bank (0...3)
	ori temp2,2	; +3
	call SPI_TX_TEMP2							; TX (BANK)		
	call SPI_CS_HIGH							; CS auf HIGH	
	pop temp2
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; RCR-PHY 
; When a PHY register is read, the entire 16 bits are obtained.					
;																				
; INP: temp1 (PHY-ADRESSE)														
; OUT: temp1+2 (Data-BYTES)														
;																				
ENC_RCR_PHY_TEMP1_TEMP2:
	cpi temp1,(0x00)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x01)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x02)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x03)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x10)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x11)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x12)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x13)
	breq ENC_RCR_PHY_RUN
	cpi temp1,(0x14)
	breq ENC_RCR_PHY_RUN
;-------------------------------------------------------------------------------
	ldi temp,(ERROR_ENC_READ_PHY_REGISTER)					; ERROR				
	call ERROR_SAVE_TEMP
	ret
;-------------------------------------------------------------------------------
ENC_RCR_PHY_RUN:
; 1. Write the address of the PHY register to read from into the MIREGADR register.		
	mov temp2,temp1								; (PHY-ADRESSE)
	ldi temp1,(MIREGADR)
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
	call ENC_WCR_CHECK_TEMP1_TEMP2 					; INP: temp1(cod+addr) temp2(data)				
; 2. Set the MICMD.MIIRD bit. The read operation begins and the MISTAT.BUSY bit is set.	
	ldi temp1,(MICMD)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	mov temp2,temp1								; temp2			
	ldi temp1,(MICMD)
	ori temp2,0b00000001						; temp2 (Bit-Verknpfung)
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; 3. Wait 10.24 s. 										
	call wait_10us
; Poll the MISTAT.BUSY bit to be certain that the operation is complete. 				
;    While busy, the host controller should not start any MIISCAN operations or write 	
;    to the MIWRHregister.When the MAC has obtained the register contents, the BUSY bit will clear itself.
	call ENC_WAIT_BUSY
; 4. Clear the MICMD.MIIRD bit.															
	ldi temp1,(MICMD)
	ldi temp2,0b00000000; bit 0 MIIRD: MII Read Enable bit
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; 5. Read the desired data from the MIRDL and MIRDH registers. The order that these bytes are accessed is unimportant.
	ldi temp1,(MIRDH)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	mov temp2,temp1
	ldi temp1,(MIRDL)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; WCR_PHY WRITE CONTROL REGISTER PHY											
;																				
; INP:  temp1 (PHY-ADRESSE)														
;		temp2 (DATA-LOW)														
;		temp3 (DATA-HIGH)														
;																				
ENC_WCR_PHY_TEMP1_TEMP2_TEMP3:
	cpi temp1,(0x00)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x01)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x02)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x03)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x10)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x11)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x12)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x13)
	breq ENC_WCR_PHY_RUN
	cpi temp1,(0x14)
	breq ENC_WCR_PHY_RUN
;-------------------------------------------------------------------------------
	ldi temp,(ERROR_ENC_WRITE_PHY_REGISTER)					; ERROR				
	call ERROR_SAVE_TEMP
	ret
;-------------------------------------------------------------------------------
ENC_WCR_PHY_RUN:
	push temp1
	push temp2
	push temp3
; 1. Write the address of the PHY register to write to into the MIREGADR register.
	push temp2				;  (DATA-LOW)	
	mov temp2,temp1			; (PHY-ADRESSE)	
	ldi temp1,(MIREGADR)
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; 2. Write the lower 8 bits of data to write into the MIWRL register.
	ldi temp1,(MIWRL)
	pop temp2				;  (DATA-LOW)	
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
; 3. Write the upper 8 bits of data to write into the MIWRH register. 
;    Writing to this register automatically begins the MIIM transaction, so it must
;  be written to after MIWRL. The MISTAT.BUSYbit becomes set.
	ldi temp1,(MIWRH)
	mov temp2,temp3			; (DATA-HIGH)	
	call ENC_WCR_TEMP1_TEMP2							; INP: temp1(cod+addr) temp2(data)				
	call ENC_WCR_CHECK_TEMP1_TEMP2 					; INP: temp1(cod+addr) temp2(data)				
; The PHY register will be written after the MIIM operation		
; completes, which takes 10.24 us. 								
	call wait_10us
; When the write												
; operation has completed, the BUSY bit will clear itself.		
; The host controller should not start any MIISCAN or			
; MIIRD operations while busy.									
	call ENC_WAIT_BUSY
;-------------------------------------------------------------------------------
	pop temp3
	pop temp2
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_WAIT_BUSY:
	ldi temp1,(MISTAT)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	SBRS temp1,(MISTAT_BUSY)
	ret
	call wait_10us
	rjmp ENC_WAIT_BUSY
; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_MAC_ADRESSE_CHECK:
	; Vergleich					
	ldi temp1,(MAADR1)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene0);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ldi temp1,(MAADR2)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene1);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ldi temp1,(MAADR3)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene2);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ldi temp1,(MAADR4)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene3);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ldi temp1,(MAADR5)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene4);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ldi temp1,(MAADR6)
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	cpi temp1,(MACeigene5);
	brne ENC_SPI_MAC_ADRESSE_CHECK_ERROR
	ret
;-------------------------------------------------------------------------------
ENC_SPI_MAC_ADRESSE_CHECK_ERROR:
	; Error						
	ldi temp,(ERROR_ENC_MAC_ADR)
	call ERROR_SAVE_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
