; ##############################################################################
; ##############################################################################
; ##############################################################################
ENC_TX:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	ldi temp,(MODUL_TX)							; MODUL		
	STS(adr_MODUL_NR),temp
	LDS R0,(adr_ENC_TX_PAKET_COUNTER_L)			; Counter	
	LDS R1,(adr_ENC_TX_PAKET_COUNTER_H)
	add R0,EINS
	adc R1,NULL
	STS(adr_ENC_TX_PAKET_COUNTER_L),R0
	STS(adr_ENC_TX_PAKET_COUNTER_H),R1
;-------------------------------------------------------------------------------
	; TXRST (s.Errata 80349c)	
	ldi temp1,(ECON1)
	ldi temp2,(1<<ECON1_TXRST)
	call ENC_BFS_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	ldi temp1,(ECON1)
	ldi temp2,(1<<ECON1_TXRST)
	call ENC_BFC_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
;-------------------------------------------------------------------------------
	; EWRPT						
	ldi temp1,(EWRPTL)
	ldi temp2,LOW(Txstart_init)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	ldi temp1,(EWRPTH)
	ldi temp2,HIGH(Txstart_init)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	; ETXST						
	ldi temp1,(ETXSTL)
	ldi temp2,LOW(Txstart_init)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	call ENC_WCR_CHECK_TEMP1_TEMP2 				; INP: temp1(cod+addr) temp2(data)				
	ldi temp1,(ETXSTH)
	ldi temp2,HIGH(Txstart_init)
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	; ETXND						
	ldi ZL,LOW (Txstart_init)					; Berechnung Ende								
	ldi ZH,HIGH(Txstart_init)
	LDS XL,(adr_ENC_TX_FRAME_LENGTH_L)			; Anzahl Bytes (ohne Controlwort)				
	LDS XH,(adr_ENC_TX_FRAME_LENGTH_H)
	add ZL,XL			
	adc ZH,XH
	ldi temp1,(ETXNDL)
	mov temp2,ZL
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	ldi temp1,(ETXNDH)
	mov temp2,ZH
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
;-------------------------------------------------------------------------------
	call SPI_CS_LOW							; CS auf LOW			
	ldi temp1,(WBM)								; Write Buffer Memory	
	call SPI_TX_TEMP1							; TX (Opcode+Address)	
;-------------------------------------------------------------------------------
; Write DATEN vom SRAM in den ENC BUFFER										
	ldi temp1,(TX_CONTROLWORT)					; Controlwort					
	call SPI_TX_TEMP1							; TX 							
;-------------------------------------------------------------------------------
	LDS XL,(adr_ENC_TX_FRAME_LENGTH_L)			; X Anzahl Bytes (ohne Controlwort)
	LDS XH,(adr_ENC_TX_FRAME_LENGTH_H)
	ldi ZL,LOW (adr_ENC_DATA)					; Z initialisieren		
	ldi ZH,HIGH(adr_ENC_DATA)
ENC_TX_WBM_X_s:
	LD temp1,Z+
	call SPI_TX_TEMP1							; TX			
	sbiw XL,1
	tst XL										; X Anzahl Bytes
	brne ENC_TX_WBM_X_s
	tst XH										; X Anzahl Bytes
	brne ENC_TX_WBM_X_s
;-------------------------------------------------------------------------------
	call SPI_CS_HIGH							; CS auf HIGH	
;-------------------------------------------------------------------------------
; TX																			
	ldi temp1,(ECON1)
	ldi temp2,(1<<ECON1_TXrts )
	call ENC_BFS_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)				
	call DEBUG_ENC_TX							; DEBUG			
;-------------------------------------------------------------------------------
	clr ERROR
	call NET_TX_ESTAT_READ
	call NET_TX_STATUS_VECTOR_READ
;-------------------------------------------------------------------------------
	tst ERROR
	breq NET_TX_OK
	call NET_TX_ERROR_COUNTER
;	call WAIT_50ms								; PAUSE		
;	jmp ENC_TX
;-------------------------------------------------------------------------------
NET_TX_OK:
	call WAIT_1ms								; PAUSE		
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ESTAT auslesen																
NET_TX_ESTAT_READ:
	ldi temp1,(ESTAT)								; ETHERNET STATUS REGISTER	
	call ENC_RCR_TEMP1								; INP: temp1(cod+addr) OUT: temp1(data)			
	andi temp1,(1<<ESTAT_LATECOL)|(1<<ESTAT_TXABRT)	; Bitmuster					
	tst temp1
	brne NET_TX_ESTAT_READ_ERROR
	ret
;-------------------------------------------------------------------------------
NET_TX_ESTAT_READ_ERROR:
	mov ERROR,EINS									; ERROR						
	; ESTAT Bits clear						
	ldi temp1,(ESTAT)								; ETHERNET STATUS REGISTER	
	ldi temp2,(1<<ESTAT_LATECOL)|(1<<ESTAT_TXABRT)					
	call ENC_BFC_TEMP1_TEMP2						; INP: temp1(cod+addr) temp2(data)				
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NET_TX_STATUS_VECTOR_READ:
	; ERDPT berechnen						
	LDS XL,(adr_ENC_TX_FRAME_LENGTH_L)				; Anzahl Bytes (ohne Controlwort)				
	LDS XH,(adr_ENC_TX_FRAME_LENGTH_H)
	ldi temp1,LOW (Txstart_init)
	ldi temp2,HIGH(Txstart_init)
	add XL,temp1
	adc XH,temp2
	adiw XL,1
;-------------------------------------------------------------------------------
	ldi temp1,(ERDPTL)							; Read Pointer(L) 	
	mov temp2,XL
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)	
	ldi temp1,(ERDPTH)							; Read Pointer(H)	
	mov temp2,XH
	call ENC_WCR_TEMP1_TEMP2					; INP: temp1(cod+addr) temp2(data)	
;-------------------------------------------------------------------------------
	call SPI_CS_LOW								; CS auf LOW			
	ldi temp1,(RBM)								; Read Buffer Memory	
	call SPI_TX_TEMP1							; TX (Opcode+Address)	
;-------------------------------------------------------------------------------
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_0),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_1),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_2),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_3),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_4),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_5),temp1
	call SPI_RX_TEMP1							; SPI-RX				
	STS(adr_ENC_TX_STATUS_VECTOR_6),temp1
;-------------------------------------------------------------------------------
	call SPI_CS_HIGH							; CS auf HIGH	
;-------------------------------------------------------------------------------
	LDS temp1,(adr_ENC_TX_STATUS_VECTOR_0)
	LDS temp2,(adr_ENC_TX_STATUS_VECTOR_1)
	LDS temp3,(adr_ENC_TX_STATUS_VECTOR_4)
	LDS temp4,(adr_ENC_TX_STATUS_VECTOR_5)
	cp temp1,temp3
	brne NET_TX_STATUS_VECTOR_READ_ERROR
	cp temp2,temp4
	brne NET_TX_STATUS_VECTOR_READ_ERROR
	ret
;-------------------------------------------------------------------------------
NET_TX_STATUS_VECTOR_READ_ERROR:
	mov ERROR,EINS								; ERROR						
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NET_TX_ERROR_COUNTER:
	LDS R0,(adr_ENC_TX_PAKET_COUNTER_ERROR_L)	; Counter	
	LDS R1,(adr_ENC_TX_PAKET_COUNTER_ERROR_H)
	add R0,EINS
	adc R1,NULL
	STS(adr_ENC_TX_PAKET_COUNTER_ERROR_L),R0
	STS(adr_ENC_TX_PAKET_COUNTER_ERROR_H),R1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################


