; ##############################################################################
; ##############################################################################
; ##############################################################################
ARP:
;-------------------------------------------------------------------------------
	; OPERATION CODE (0x0001) Request (Anforderung)
	LDS temp1,(ARPoperationCodeL)
	LDS temp2,(ARPoperationCodeH)
	cpi temp1,LOW(0x0001)
	brne ARP_NO_REQUEST
	cpi temp2,HIGH(0x0001)
	brne ARP_NO_REQUEST
	rjmp ARP_RX_REQUEST	; RX ARP REQUEST		
ARP_NO_REQUEST:
;-------------------------------------------------------------------------------
	; OPERATION CODE (0x0002) REPLY 				
	LDS temp1,(ARPoperationCodeL)
	LDS temp2,(ARPoperationCodeH)
	cpi temp1,LOW(0x0002)
	brne ARP_NO_REPLY
	cpi temp2,HIGH(0x0002)
	brne ARP_NO_REPLY
	rjmp ARP_RX_REPLAY		; RX ARP REPLAY			
ARP_NO_REPLY:
;-------------------------------------------------------------------------------

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ARP REPLAY(Antwort) empfangen													
ARP_RX_REPLAY:
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an  
	; ARP_CHACHE_EINTRAG						
	call ARP_CHACHE_EINTRAG
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ARP REQUEST(Anforderung) empfangen											
ARP_RX_REQUEST:
	; ist es meine IP-ADRESSE ?
	call FUNCTION_IP_EIGENE_TEMP1_4
	LDS temp5,(ARPTargetsIPAddr0)	; DATA 
	LDS temp6,(ARPTargetsIPAddr1)	; DATA 
	LDS temp7,(ARPTargetsIPAddr2)	; DATA 
	LDS temp8,(ARPTargetsIPAddr3)	; DATA 
	; Vergleich					
	cp temp1,temp5
	brne ARP_REQUEST_NO
	cp temp2,temp6
	brne ARP_REQUEST_NO
	cp temp3,temp7
	brne ARP_REQUEST_NO
	cp temp4,temp8
	brne ARP_REQUEST_NO
	jmp ARP_REQUEST_REPLAY
;-------------------------------------------------------------------------------
ARP_REQUEST_NO:
	ret
;-------------------------------------------------------------------------------
; ARP-REPLAY zurcksenden														
ARP_REQUEST_REPLAY:
	; ARP_CHACHE_EINTRAG						
	call ARP_CHACHE_EINTRAG
	; MAC_HEADER_ADRESS_TAUSCH					
	call FUNCTION_MAKE_NEW_MAC_HEADER
	; ARPsenderMACaddr nach ARPtargetsHardAddr	
	LDS temp1,(ARPsenderMACaddr0)
	LDS temp2,(ARPsenderMACaddr1)
	LDS temp3,(ARPsenderMACaddr2)
	LDS temp4,(ARPsenderMACaddr3)
	LDS temp5,(ARPsenderMACaddr4)
	LDS temp6,(ARPsenderMACaddr5)
	STS(ARPtargetsHardAddr0),temp1
	STS(ARPtargetsHardAddr1),temp2
	STS(ARPtargetsHardAddr2),temp3
	STS(ARPtargetsHardAddr3),temp4
	STS(ARPtargetsHardAddr4),temp5
	STS(ARPtargetsHardAddr5),temp6
	; ARPsenderIPAddr nach ARPtargetsIPAddr		
	LDS temp1,(ARPsenderIPAddr0)
	LDS temp2,(ARPsenderIPAddr1)
	LDS temp3,(ARPsenderIPAddr2)
	LDS temp4,(ARPsenderIPAddr3)
	STS(ARPtargetsIPAddr0),temp1
	STS(ARPtargetsIPAddr1),temp2
	STS(ARPtargetsIPAddr2),temp3
	STS(ARPtargetsIPAddr3),temp4
;-------------------------------------------------------------------------------
	; Operation Code 			
	ldi temp,0x02
	STS(ARPoperationCodeL),temp
	; ARPsenderMACaddr
	call FUNCTION_MAC_EIGENE_TEMP1_6
	STS(ARPsenderMACaddr0),temp1
	STS(ARPsenderMACaddr1),temp2
	STS(ARPsenderMACaddr2),temp3
	STS(ARPsenderMACaddr3),temp4
	STS(ARPsenderMACaddr4),temp5
	STS(ARPsenderMACaddr5),temp6
	; ARPsenderIPAddr
	call FUNCTION_IP_EIGENE_TEMP1_4
	STS(ARPsenderIPAddr0),temp1
	STS(ARPsenderIPAddr1),temp2
	STS(ARPsenderIPAddr2),temp3
	STS(ARPsenderIPAddr3),temp4
;-------------------------------------------------------------------------------
	; Anzahl Bytes 				
	ldi temp1,LOW (42)	; ohne Controlwort	
	ldi temp2,HIGH(42)
	STS(adr_ENC_TX_FRAME_LENGTH_L),temp1
	STS(adr_ENC_TX_FRAME_LENGTH_H),temp2
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ARP_TX_REQUEST_ROUTER:
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus  
	ldi temp1,(IProuter0)
	ldi temp2,(IProuter1)
	ldi temp3,(IProuter2)
	ldi temp4,(IProuter3)
	call ARP_TX_REQUEST_TEMP1_4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ARP_TX_REQUEST_ALLE:
	ldi temp1,(IProuter0)
	ldi temp2,(IProuter1)
	ldi temp3,(IProuter2)
	LDS temp4,(adr_IP_SCAN_NR)
	inc temp4
	STS(adr_IP_SCAN_NR),temp4
	call ARP_TX_REQUEST_TEMP1_4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ARP_TX_REQUEST_TEMP1_4:
	push temp1
	push temp2
	push temp3
	push temp4
	; DESTINATION-Adress								
	ldi temp,0xFF
	STS(DestinationMACaddr0),temp
	STS(DestinationMACaddr1),temp
	STS(DestinationMACaddr2),temp
	STS(DestinationMACaddr3),temp
	STS(DestinationMACaddr4),temp
	STS(DestinationMACaddr5),temp
	; SOURCE-Adress (MAC 00:22:F9:01:BC:27)				
	ldi temp1,(MACeigene0)
	ldi temp2,(MACeigene1)
	ldi temp3,(MACeigene2)
	ldi temp4,(MACeigene3)
	ldi temp5,(MACeigene4)
	ldi temp6,(MACeigene5)
	STS(SourceMACaddr0),temp1
	STS(SourceMACaddr1),temp2
	STS(SourceMACaddr2),temp3
	STS(SourceMACaddr3),temp4
	STS(SourceMACaddr4),temp5
	STS(SourceMACaddr5),temp6
	; TYPE (0x0806)				
	ldi temp1,LOW (0x0806)
	ldi temp2,HIGH(0x0806)
	STS(PacketTypL),temp1
	STS(PacketTypH),temp2
;-------------------------------------------------------------------------------
	; Hardaware TYPE (0x0001)	
	ldi temp1,LOW (0x0001)
	ldi temp2,HIGH(0x0001)
	STS(ARPhwtypeL),temp1
	STS(ARPhwtypeH),temp2
	; Protokoll TYPE (0x0800)	
	ldi temp1,LOW (0x0800)
	ldi temp2,HIGH(0x0800)
	STS(ARPprotokollTypL),temp1
	STS(ARPprotokollTypH),temp2
	; Lengt Harware Adress (06)	
	ldi temp1,0x06
	STS(ARPhardwareLen),temp1
	; Lengt Protokoll Adress (04)
	ldi temp1,0x04
	STS(ARPprotokollLen),temp1
	; Operation Code 0x0001=Request 0x0002=Reply				
	ldi temp1,LOW (0x0001)
	ldi temp2,HIGH(0x0001)
	STS(ARPoperationCodeL),temp1
	STS(ARPoperationCodeH),temp2
	; Sender Harware Adress	
	ldi temp1,(MACeigene0)
	ldi temp2,(MACeigene1)
	ldi temp3,(MACeigene2)
	ldi temp4,(MACeigene3)
	ldi temp5,(MACeigene4)
	ldi temp6,(MACeigene5)
	STS(ARPsenderMACaddr0),temp1
	STS(ARPsenderMACaddr1),temp2
	STS(ARPsenderMACaddr2),temp3
	STS(ARPsenderMACaddr3),temp4
	STS(ARPsenderMACaddr4),temp5
	STS(ARPsenderMACaddr5),temp6
	; Sender IP Adress		
	LDS temp1,(adr_IP_EIGENE0)
	LDS temp2,(adr_IP_EIGENE1)
	LDS temp3,(adr_IP_EIGENE2)
	LDS temp4,(adr_IP_EIGENE3)
	STS(ARPsenderIPAddr0),temp1
	STS(ARPsenderIPAddr1),temp2
	STS(ARPsenderIPAddr2),temp3
	STS(ARPsenderIPAddr3),temp4
	; Target  Harware Adress
	STS(ARPtargetsHardAddr0),NULL
	STS(ARPtargetsHardAddr1),NULL
	STS(ARPtargetsHardAddr2),NULL
	STS(ARPtargetsHardAddr3),NULL
	STS(ARPtargetsHardAddr4),NULL
	STS(ARPtargetsHardAddr5),NULL
	; Target  IP Adress		
	pop temp4
	pop temp3
	pop temp2
	pop temp1
	STS(ARPtargetsIPAddr0),temp1
	STS(ARPtargetsIPAddr1),temp2
	STS(ARPtargetsIPAddr2),temp3
	STS(ARPtargetsIPAddr3),temp4
	; Anzahl Bytes 			
	ldi temp1,LOW (42)
	ldi temp2,HIGH(42)
	STS(adr_ENC_TX_FRAME_LENGTH_L),temp1
	STS(adr_ENC_TX_FRAME_LENGTH_H),temp2
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
