.equ ARP_CHACHE_MAC0	=0
.equ ARP_CHACHE_MAC1	=1
.equ ARP_CHACHE_MAC2	=2
.equ ARP_CHACHE_MAC3	=3
.equ ARP_CHACHE_MAC4	=4
.equ ARP_CHACHE_MAC5	=5
.equ ARP_CHACHE_IP0		=6
.equ ARP_CHACHE_IP1		=7
.equ ARP_CHACHE_IP2		=8
.equ ARP_CHACHE_IP3		=9
.equ ARP_CHACHE_TIME	=10
.equ ARP_CHACHE_RESERVE	=11
; ##############################################################################
; ##############################################################################
; ##############################################################################
ARP_CHACHE_EINTRAG:
	LDS temp1,(SourceMACaddr0)		; SourceMACaddr 
	LDS temp2,(SourceMACaddr1)
	LDS temp3,(SourceMACaddr2)
	LDS temp4,(SourceMACaddr3)
	LDS temp5,(SourceMACaddr4)
	LDS temp6,(SourceMACaddr5)
	STS(adr_ARP_CHACHE_MAC0),temp1
	STS(adr_ARP_CHACHE_MAC1),temp2
	STS(adr_ARP_CHACHE_MAC2),temp3
	STS(adr_ARP_CHACHE_MAC3),temp4
	STS(adr_ARP_CHACHE_MAC4),temp5
	STS(adr_ARP_CHACHE_MAC5),temp6
	LDS temp1,(ARPsenderIPAddr0)	; senderIPAddr
	LDS temp2,(ARPsenderIPAddr1)
	LDS temp3,(ARPsenderIPAddr2)
	LDS temp4,(ARPsenderIPAddr3)
	STS(adr_ARP_CHACHE_IP0),temp1
	STS(adr_ARP_CHACHE_IP1),temp2
	STS(adr_ARP_CHACHE_IP2),temp3
	STS(adr_ARP_CHACHE_IP3),temp4
	call ARP_CHACHE_WRITE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 12 Byts pro DATENSATZ															
ARP_CHACHE_WRITE:
	ldi ZL,LOW (adr_ARP_CHACHE_DATA)
	ldi ZH,HIGH(adr_ARP_CHACHE_DATA)
;-------------------------------------------------------------------------------
ARP_CHACHE_WRITE_s:
	call ARP_CHACHE_NEXT_DATENSATZ
;-------------------------------------------------------------------------------
	; alles NULL ?				
	tst temp1
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp2
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp3
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp4
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp5
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp6
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	

	tst temp7
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp8
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst temp9
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	tst r0
	brne ARP_CHACHE_WRITE_NO_NULL	; nein	
	call ARP_CHACHE_WRITE_AKTION	; ja, neuen Datensatz schreiben					
	LDS temp,(adr_ARP_CHACHE_ANZAHL); ANZAHL-Eintrge	
	inc temp
	STS(adr_ARP_CHACHE_ANZAHL),temp
	call DEBUG_ARP_CHACHE
	ret
;-------------------------------------------------------------------------------
ARP_CHACHE_WRITE_NO_NULL:
	; MAC schon vorhanden ?	
	LDS temp,(adr_ARP_CHACHE_MAC0)
	cp temp,temp1
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_MAC1)
	cp temp,temp2
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_MAC2)
	cp temp,temp3
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_MAC3)
	cp temp,temp4
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_MAC4)
	cp temp,temp5
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_MAC5)	
	cp temp,temp6
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	; IP schon vorhanden ?	
	LDS temp,(adr_ARP_CHACHE_IP0)	
	cp temp,temp7
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_IP1)	
	cp temp,temp8
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_IP2)	
	cp temp,temp9
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	LDS temp,(adr_ARP_CHACHE_IP3)	
	cp temp,R0
	brne ARP_CHACHE_WRITE_NO_MAC_IP	; nein	
	ret
;-------------------------------------------------------------------------------
ARP_CHACHE_WRITE_NO_MAC_IP:
	rjmp ARP_CHACHE_WRITE_s
;-------------------------------------------------------------------------------
ARP_CHACHE_WRITE_AKTION:
	SBIW ZL,12		; -12
	LDS temp1,(adr_ARP_CHACHE_MAC0)
	LDS temp2,(adr_ARP_CHACHE_MAC1)
	LDS temp3,(adr_ARP_CHACHE_MAC2)
	LDS temp4,(adr_ARP_CHACHE_MAC3)
	LDS temp5,(adr_ARP_CHACHE_MAC4)
	LDS temp6,(adr_ARP_CHACHE_MAC5)
	ST Z+,temp1
	ST Z+,temp2
	ST Z+,temp3
	ST Z+,temp4
	ST Z+,temp5
	ST Z+,temp6
	LDS temp1,(adr_ARP_CHACHE_IP0)
	LDS temp2,(adr_ARP_CHACHE_IP1)
	LDS temp3,(adr_ARP_CHACHE_IP2)
	LDS temp4,(adr_ARP_CHACHE_IP3)
	ST Z+,temp1
	ST Z+,temp2
	ST Z+,temp3
	ST Z+,temp4
	ldi temp,0xFF	; TIME	
	ST Z+,temp
	ldi temp,0xFF
	ST Z+,temp		; DUMMY	
ret
;-------------------------------------------------------------------------------
ARP_CHACHE_NEXT_DATENSATZ:
	; Datensatzs read				
	LD temp1,Z+		; MAC (6Bytes)	
	LD temp2,Z+
	LD temp3,Z+
	LD temp4,Z+
	LD temp5,Z+
	LD temp6,Z+
	LD temp7,Z+		; IP (4 Bytes)	
	LD temp8,Z+
	LD temp9,Z+
	LD R0,Z+
	LD R1,Z+		; TIME   (DUMMY)
	LD R2,Z+		; RESERVE(DUMMY 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################

