.equ TCPflag_FIN	= 0
.equ TCPflag_SYN	= 1
.equ TCPflag_RESET	= 2
.equ TCPflag_PUSH	= 3
.equ TCPflag_ACK	= 4
.equ TCPflag_URG	= 5
.equ TCPflag_ECN	= 6
.equ TCPflag_WCR	= 7
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP:
	cbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2 an	
	call WAIT_100ms
	ldi temp,(MODUL_TCP_CRC)					; MODUL		
	STS(adr_MODUL_NR),temp
;-------------------------------------------------------------------------------
	; Checksum-Check				
	LDS temp3,(TCPchecksumL)
	LDS temp4,(TCPchecksumH)
	call FUNCTION_TCP_PSEUDOHEADER_CHECKSUM
	LDS temp1,(TCPchecksumL)
	LDS temp2,(TCPchecksumH)
	cp temp1,temp3
	brne TCP_CRC_ERROR
	cp temp2,temp4
	brne TCP_CRC_ERROR
	rjmp TCP_CRC_OK
TCP_CRC_ERROR:
	call ENC_RX_ERROR_COUNTER					; ERROR-COUNTER	
	;ret
TCP_CRC_OK:
;-------------------------------------------------------------------------------
	; ALARM bei PORT 90				
	sbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP aus	
	LDS temp1,(TCPdestinationPortL)
	LDS temp2,(TCPdestinationPortH)
	tst temp2
	brne TCP_NO_PORT90
	cpi temp1,90
	brne TCP_NO_PORT90
	cbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP an	
TCP_NO_PORT90:
;-------------------------------------------------------------------------------
	; RESET bei PORT 99				
	LDS temp1,(TCPdestinationPortL)
	LDS temp2,(TCPdestinationPortH)
	tst temp2
	brne TCP_NO_PORT99
	cpi temp1,99
	brne TCP_NO_PORT99
	jmp RESET  
TCP_NO_PORT99:
;-------------------------------------------------------------------------------
	; SPEICHERN fr ANZEIGE			
	LDS temp1,(TCPdestinationPortL)
	LDS temp2,(TCPdestinationPortH)
	STS(adr_TCP_PORT_DESTINATION_L),temp1
	STS(adr_TCP_PORT_DESTINATION_H),temp2
	LDS temp1,(TCPsourcePortL)
	LDS temp2,(TCPsourcePortH)
	STS(adr_TCP_PORT_SOURCE_L),temp1
	STS(adr_TCP_PORT_SOURCE_H),temp2
	; SPEICHERN fr ANZEIGE			
	LDS temp1,(SourceMACaddr0)
	LDS temp2,(SourceMACaddr1)
	LDS temp3,(SourceMACaddr2)
	LDS temp4,(SourceMACaddr3)
	LDS temp5,(SourceMACaddr4)
	LDS temp6,(SourceMACaddr5)
	STS(adr_TCP_SourceMACaddr0),temp1
	STS(adr_TCP_SourceMACaddr1),temp2
	STS(adr_TCP_SourceMACaddr2),temp3
	STS(adr_TCP_SourceMACaddr3),temp4
	STS(adr_TCP_SourceMACaddr4),temp5
	STS(adr_TCP_SourceMACaddr5),temp6
	; SPEICHERN fr ANZEIGE			
	LDS temp1,(IP4SourceIPaddr3)
	LDS temp2,(IP4SourceIPaddr2)
	LDS temp3,(IP4SourceIPaddr1)
	LDS temp4,(IP4SourceIPaddr0)
	STS(adr_TCP_IP4SourceIPaddr0),temp1
	STS(adr_TCP_IP4SourceIPaddr1),temp2
	STS(adr_TCP_IP4SourceIPaddr2),temp3
	STS(adr_TCP_IP4SourceIPaddr3),temp4
	; SPEICHERN fr ANZEIGE			
	LDS temp,(TCPflags)	
	STS(adr_TCP_FLAGS),temp

	rjmp TCP_FLAGS_AUSWERTEN
; ##############################################################################
; ##############################################################################
; ##############################################################################
; WCR,ECN,URG,ACK,PUSH,RESET,SYN,FIN											
TCP_FLAGS_AUSWERTEN:
	call DEBUG_TCP_FLAGS					; DEBUG Flags		
	LDS  temp1,(TCPflags)					; FLAGS laden		
;-------------------------------------------------------------------------------
	sbrs temp1,(TCPflag_SYN)				; FLAG SYN ?		
	rjmp TCP_FLAG_NO_SYN
	jmp TCP_SYN								; SYN				
TCP_FLAG_NO_SYN:
;-------------------------------------------------------------------------------
	sbrs temp1,(TCPflag_PUSH)				; FLAG PUSH	?		
	rjmp TCP_FLAG_NO_PUSH
	call TCP_PUSH							; PUSH				
	call FUNCTION_SEARCH_favicon_ICO_C		; "favicon.ico" angefordert?
	brcs TCP_FLAG_PUSH_ENDE					; ja 				
	call TCP_IP_CHACHE						; TCP-CHACHE Eintrag
	call TCP_TX_DATA						; DATA				
TCP_FLAG_PUSH_ENDE:
	ret
TCP_FLAG_NO_PUSH:
;-------------------------------------------------------------------------------
	sbrs temp1,(TCPflag_FIN)				; FLAG FIN	?		
	rjmp TCP_FLAG_NO_FIN
	rjmp TCP_FIN							; FIN				
TCP_FLAG_NO_FIN:
;-------------------------------------------------------------------------------
	sbrs temp1,(TCPflag_RESET)				; FLAG RESET	?	
	rjmp TCP_FLAG_NO_RESET
	rjmp TCP_RESET							; RESET				
TCP_FLAG_NO_RESET:
;-------------------------------------------------------------------------------
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP_FIN:
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2 aus
	call TCP_PAKET_EMPFANG_QUITTIEREN
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP_RESET:
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2 aus
	call TCP_PAKET_EMPFANG_QUITTIEREN
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP_PAKET_EMPFANG_QUITTIEREN:
	; IPv4 Total Length						
	ldi ZL,LOW (40)							; 40=20(IPv4-Header)+20(TCP-Header)
	ldi ZH,HIGH(40)
	STS(IP4TotalLengthL),ZL
	STS(IP4TotalLengthH),ZH
;-------------------------------------------------------------------------------
	call FUNCTION_MAKE_NEW_MAC_HEADER		; MAC-Heder	
	call FUNCTION_MAKE_NEW_IP4_HEADER		; IP4-Heder	
	call FUNCTION_MAKE_NEW_TCP_HEADER		; TCP		
	call FUNCTION_IP4HEADER_CHECKSUM		; IP4 CHECKSUM	
;-------------------------------------------------------------------------------
	; FLAGS setzen				
	ldi temp,(1<<TCPflag_ACK)
	STS(TCPflags),temp
;-------------------------------------------------------------------------------
	; ACK=SEQ+1					
	LDS temp1,(TcpSeq0)	; SEQ		
	LDS temp2,(TcpSeq1)
	LDS temp3,(TcpSeq2)
	LDS temp4,(TcpSeq3)
	LDS temp5,(TcpAck0)	; Sichern	
	LDS temp6,(TcpAck1)
	LDS temp7,(TcpAck2)
	LDS temp8,(TcpAck3)
	add temp1,EINS		; SEQ +1	
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	STS(TcpAck0),temp1	; SPEICHERN	
	STS(TcpAck1),temp2
	STS(TcpAck2),temp3
	STS(TcpAck3),temp4
;-------------------------------------------------------------------------------
	; SEQ=ACK					
	STS(TcpSeq0),temp5	; SPEICHERN	
	STS(TcpSeq1),temp6
	STS(TcpSeq2),temp7
	STS(TcpSeq3),temp8
;-------------------------------------------------------------------------------
	ldi temp,0x50				; 0x50=20Byte	
	STS(TCPHeaderLength),temp
;-------------------------------------------------------------------------------
	; TCPchecksum				
	call FUNCTION_TCP_PSEUDOHEADER_CHECKSUM
;-------------------------------------------------------------------------------
	; TX_FRAME_LENGTH			
	LDS ZL,(IP4TotalLengthL)
	LDS ZH,(IP4TotalLengthH)
	adiw ZL,14	; +14Mytes MAC-HEADER
	STS(adr_ENC_TX_FRAME_LENGTH_L),ZL
	STS(adr_ENC_TX_FRAME_LENGTH_H),ZH
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; SYN-Paket wurde empfangen, SYN/ACK-Paket wird zurckgesendet					
TCP_SYN:
;-------------------------------------------------------------------------------
	; IPv4 Total Length						
	ldi ZL,LOW (44)							; 44=20(IPv4-Header)+24(TCP-Header)
	ldi ZH,HIGH(44)
	STS(IP4TotalLengthL),ZL
	STS(IP4TotalLengthH),ZH
;-------------------------------------------------------------------------------
	call FUNCTION_MAKE_NEW_MAC_HEADER		; MAC-Heder	
	call FUNCTION_MAKE_NEW_IP4_HEADER		; IP4-Heder	
	call FUNCTION_MAKE_NEW_TCP_HEADER		; TCP		
	call FUNCTION_IP4HEADER_CHECKSUM		; IP4 CHECKSUM	
;-------------------------------------------------------------------------------
	; FLAGS setzen				
	ldi temp,(1<<TCPflag_SYN)|(1<<TCPflag_ACK)
	STS(TCPflags),temp
;-------------------------------------------------------------------------------
	; ACK=SEQ+1					
	LDS temp1,(TcpSeq0)
	LDS temp2,(TcpSeq1)
	LDS temp3,(TcpSeq2)
	LDS temp4,(TcpSeq3)
	add temp1,EINS
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	STS(TcpAck0),temp1
	STS(TcpAck1),temp2
	STS(TcpAck2),temp3
	STS(TcpAck3),temp4
;-------------------------------------------------------------------------------
	; SEQ=100 (bzw. Zufallszahl)
	dec temp1
	dec temp2
	dec temp3
	dec temp4
	STS(TcpSeq0),temp1
	STS(TcpSeq1),temp2
	STS(TcpSeq2),temp3
	STS(TcpSeq3),temp4
;-------------------------------------------------------------------------------
	ldi temp,0x60
	STS(TCPHeaderLength),temp
;-------------------------------------------------------------------------------
	; OPTIONEN
	ldi temp1,0x02
	ldi temp2,0x04
	ldi temp3,0x05
	ldi temp4,0xb4
	STS(TCPdata+0),temp1
	STS(TCPdata+1),temp2
	STS(TCPdata+2),temp3
	STS(TCPdata+3),temp4
;-------------------------------------------------------------------------------
	; TCPchecksum				
	call FUNCTION_TCP_PSEUDOHEADER_CHECKSUM
;-------------------------------------------------------------------------------
	; TX_FRAME_LENGTH			
	LDS ZL,(IP4TotalLengthL)
	LDS ZH,(IP4TotalLengthH)
	adiw ZL,14	; +14Mytes MAC-HEADER
	STS(adr_ENC_TX_FRAME_LENGTH_L),ZL
	STS(adr_ENC_TX_FRAME_LENGTH_H),ZH
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Daten wurden empfangen--> Paket wird besttigt								
TCP_PUSH:
	call DEBUG_TCP_RX_PUSH					; DEBUG								
	call FUNCTION_TCP_NEXT_ACK_NR			; NEXT_ACK_NR						
;-------------------------------------------------------------------------------
	; IPv4 Total Length						
	ldi ZL,LOW (40)							; 40=20(IPv4-Header)+20(TCP-Header)
	ldi ZH,HIGH(40)
	STS(IP4TotalLengthL),ZL
	STS(IP4TotalLengthH),ZH
;-------------------------------------------------------------------------------
	call FUNCTION_MAKE_NEW_MAC_HEADER		; MAC-Heder	
	call FUNCTION_MAKE_NEW_IP4_HEADER		; IP4-Heder	
	call FUNCTION_MAKE_NEW_TCP_HEADER		; TCP		
	call FUNCTION_IP4HEADER_CHECKSUM		; IP4 CHECKSUM	
;-------------------------------------------------------------------------------
	; FLAGS setzen				
	ldi temp,(1<<TCPflag_ACK)
	STS(TCPflags),temp
;-------------------------------------------------------------------------------
	; SEQ=ACK			
	LDS temp1,(TcpAck0)
	LDS temp2,(TcpAck1)
	LDS temp3,(TcpAck2)
	LDS temp4,(TcpAck3)
	STS(TcpSeq0),temp1
	STS(TcpSeq1),temp2
	STS(TcpSeq2),temp3
	STS(TcpSeq3),temp4
;-------------------------------------------------------------------------------
	; ACK=NextACK		
	LDS temp1,(adr_TCP_NEXT_ACK_0)
	LDS temp2,(adr_TCP_NEXT_ACK_1)
	LDS temp3,(adr_TCP_NEXT_ACK_2)
	LDS temp4,(adr_TCP_NEXT_ACK_3)
	STS(TcpAck0),temp1
	STS(TcpAck1),temp2
	STS(TcpAck2),temp3
	STS(TcpAck3),temp4
;-------------------------------------------------------------------------------
	; HeaderLength					
	ldi temp,0x50	; 0x50=20Byte	
	STS(TCPHeaderLength),temp
	; TCPchecksum					
	call FUNCTION_TCP_PSEUDOHEADER_CHECKSUM
;-------------------------------------------------------------------------------
	; TX_FRAME_LENGTH			
	LDS ZL,(IP4TotalLengthL)
	LDS ZH,(IP4TotalLengthH)
	adiw ZL,14	; +14Mytes MAC-HEADER
	STS(adr_ENC_TX_FRAME_LENGTH_L),ZL
	STS(adr_ENC_TX_FRAME_LENGTH_H),ZH
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP_TX_DATA:
;-------------------------------------------------------------------------------
	LDS temp1,(adr_TCP_ANZAHL_AUFRUFE_L)
	LDS temp2,(adr_TCP_ANZAHL_AUFRUFE_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_TCP_ANZAHL_AUFRUFE_L),temp1
	STS(adr_TCP_ANZAHL_AUFRUFE_H),temp2
;-------------------------------------------------------------------------------
	; WEBSEITE						
	call HTML_WEBSEITE
;-------------------------------------------------------------------------------
	; IPv4 Total Length				
	LDS ZL,(adr_TCP_TX_DATA_LENGTH_L)
	LDS ZH,(adr_TCP_TX_DATA_LENGTH_H)
	adiw ZL,40								; 40=20(IPv4-Header)+20(TCP-Header)
	STS(IP4TotalLengthL),ZL
	STS(IP4TotalLengthH),ZH
	; IP4_CHECKSUM					
	call FUNCTION_IP4HEADER_CHECKSUM		; IP4 CHECKSUM	
;-------------------------------------------------------------------------------
	; FLAGS setzen				
	ldi temp,(1<<TCPflag_PUSH)|(1<<TCPflag_ACK)
	STS(TCPflags),temp
;-------------------------------------------------------------------------------
	; HeaderLength					
	ldi temp,0x50	; 0x50=20Byte	
	STS(TCPHeaderLength),temp
	; TCPchecksum					
	call FUNCTION_TCP_PSEUDOHEADER_CHECKSUM
;-------------------------------------------------------------------------------
	; TX_FRAME_LENGTH			
	LDS ZL,(IP4TotalLengthL)
	LDS ZH,(IP4TotalLengthH)
	adiw ZL,14	; +14Mytes MAC-HEADER
	STS(adr_ENC_TX_FRAME_LENGTH_L),ZL
	STS(adr_ENC_TX_FRAME_LENGTH_H),ZH
	; TX						
	call ENC_TX
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TCP_IP_CHACHE:
	LDS temp1,(adr_TCP_IP4SourceIPaddr0)
	LDS temp2,(adr_TCP_IP4SourceIPaddr1)
	LDS temp3,(adr_TCP_IP4SourceIPaddr2)
	LDS temp4,(adr_TCP_IP4SourceIPaddr3)
	LDS temp5,(adr_TCP_IP_CHACHE+0)
	LDS temp6,(adr_TCP_IP_CHACHE+1)
	LDS temp7,(adr_TCP_IP_CHACHE+2)
	LDS temp8,(adr_TCP_IP_CHACHE+3)
	cp temp1,temp5
	brne TCP_IP_CHACHE_RUN
	cp temp2,temp6
	brne TCP_IP_CHACHE_RUN
	cp temp3,temp7
	brne TCP_IP_CHACHE_RUN
	cp temp4,temp8
	brne TCP_IP_CHACHE_RUN
	ret
;-------------------------------------------------------------------------------
TCP_IP_CHACHE_RUN:
	; Schieben					
	ldi temp9,(9+1)
	ldi ZL,LOW (adr_TCP_IP_CHACHE+9*4)
	ldi ZH,HIGH(adr_TCP_IP_CHACHE+9*4)
TCP_IP_CHACHE_s:
	LD temp1,Z+
	LD temp2,Z+
	LD temp3,Z+
	LD temp4,Z+
	ST Z+,temp1
	ST Z+,temp2
	ST Z+,temp3
	ST Z+,temp4
	sbiw ZL,12
	dec temp9
	brne TCP_IP_CHACHE_s
;-------------------------------------------------------------------------------
	; EINTRAG					
	ldi ZL,LOW (adr_TCP_IP_CHACHE)
	ldi ZH,HIGH(adr_TCP_IP_CHACHE)
	LDS temp1,(adr_TCP_IP4SourceIPaddr0)
	LDS temp2,(adr_TCP_IP4SourceIPaddr1)
	LDS temp3,(adr_TCP_IP4SourceIPaddr2)
	LDS temp4,(adr_TCP_IP4SourceIPaddr3)
	ST Z+,temp1
	ST Z+,temp2
	ST Z+,temp3
	ST Z+,temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################



