; ##############################################################################
; ##############################################################################
; ##############################################################################
; LCD-INITIALISIERUNG															
LCD_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS) 			; RS aus (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	call LCD_ENABLE					; 1	
	call LCD_ENABLE					; 2	
	call LCD_ENABLE					; 3	
    ldi temp, 0b00000010        ;4bit-Modus einstellen
	call LCD_COMMAND
    ldi temp, 0b00000001        ; DISPLAY lschen			
 	call LCD_COMMAND
    ;ldi temp, 0b00001111        ; DISPLAY ein / CURSOR blinken on
    ldi temp, 0b00001110        ; DISPLAY ein / CURSOR blinken off
	call LCD_COMMAND
    ldi temp, 0b00000110        ; Cursor Auto-Increment
 	call LCD_COMMAND
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;erzeugt den Enable-Puls												  		
;																		  		
LCD_ENABLE:
	sbi LCD_EN_PORT, LCD_EN    		   	; Enable high		
 	call wait_5us            		  	; kurze PAUSE		
	cbi LCD_EN_PORT, LCD_EN     	  	; Enable low		
	call wait_50us            		 	; kurze PAUSE		
ret                          
; ##############################################################################
; ##############################################################################
; ##############################################################################
; sendet ein Datenbyte an das LCD										  		
;																		  		
; INPUT: temp															  		
;																		  		
; call LCD_DATA			; DATENBYTE an LCD inp: temp 				  			
;																		  		
LCD_DATA_TEMP:
	sbi LCD_RS_PORT, LCD_RS 			; RS ein/auf DATA (high)				
LCD_DATA_RS:
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; alle auf LOW							
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,4							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,5
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,6
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,7
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	call lcd_enable        			; Enable-Routine aufrufen				
;-------------------------------------------------------------------------------
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; auf LOW								
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,0							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,1
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,2
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,3
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	call lcd_enable        			; Enable-Routine aufrufen				
	call wait_5us						; Pause 								
	sbi LCD_RS_PORT, LCD_RS 			; vorsichtshalber RS ein/auf DATA (high)
ret				                       
; ##############################################################################
; ##############################################################################
; ##############################################################################
;sendet einen Befehl an das LCD;wie lcd_data, nur ohne RS zu setzen		  		
;																		  		
; INPUT: temp															  		
;																		  		
LCD_COMMAND:                            
    cbi (LCD_RS_PORT),(LCD_RS) 			;	 RS aus (low)				
	call LCD_DATA_RS
	jmp wait_5ms						; Pause (wichtig)				
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
LCD_2_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	call FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	jmp LCD_AUSGABE_ZAHL_2_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
LCD_3_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	call FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	jmp LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2															
LCD_4_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	call FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	jmp LCD_AUSGABE_ZAHL_4_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2															
LCD_5_STELLEN_TEMP1_TEMP2:
	tst temp1
	brne LCD_5_STELLEN_TEMP1_TEMP2_w
	tst temp2
	brne LCD_5_STELLEN_TEMP1_TEMP2_w
	call LCD_MINUS
	call LCD_MINUS
	call LCD_MINUS
	call LCD_MINUS
	call LCD_MINUS
	ret
;---------------------------------------------------------------------------
LCD_5_STELLEN_TEMP1_TEMP2_w:
	clr temp3
	clr temp4
 	call FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	jmp LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1...TEMP9 (temp)												
LCD_AUSGABE_ZAHL_10_STELLEN_KURZ:
	; temp !
	call LCD_DATA_TEMP			;10.
LCD_AUSGABE_ZAHL_9_STELLEN_KURZ:
	mov temp, temp9			; 9.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_8_STELLEN_KURZ:
	mov temp, temp8			; 8.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_7_STELLEN_KURZ:
	mov temp, temp7			; 7.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_6_STELLEN_KURZ:
	mov temp, temp6			; 6.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_5_STELLEN_KURZ:
	mov temp, temp5			; 5.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_4_STELLEN_KURZ:
	mov temp, temp4			; 4.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_3_STELLEN_KURZ:
	mov temp, temp3			; 3.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_2_STELLEN_KURZ:
	mov temp, temp2			; 2.
	call LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_1_STELLEN_KURZ:
	mov temp, temp1			; 1.ZIFFER (1-er Stelle)	
	jmp LCD_DATA_TEMP
; ##############################################################################
; ##############################################################################
; ##############################################################################
; STAND: 09.12.2011															
;																			
;	Value: 0...	9.999.999.999												
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		     1-er Stelle)								
;			temp2	(		    10-er Stelle)								
;			temp3	(          100-er Stelle)								
;			temp4	(        1.000-er Stelle)								
;			temp5	(       10.000-er Stelle)								
;			temp6	(      100.000-er Stelle)								
;			temp7	(    1.000.000-er Stelle)								
;			temp8	(   10.000.000-er Stelle)								
;			temp9	(  100.000.000-er Stelle)								
;			temp	(1.000.000.000-er Stelle)								
; 																			
; call FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
; 																			
FUNKTION_HEX_ASC_32:
;---------------------------------------------------------------------------
	clr temp			
FUNKTION_HEX_ASC_109:	; 1.100.000.000
	inc temp
	subi temp1, BYTE1    (1000000000)
	sbci temp2, BYTE2    (1000000000)
	sbci temp3, BYTE3    (1000000000)
	sbci temp4, BYTE4    (1000000000)
	brcc FUNKTION_HEX_ASC_109
	subi temp, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000000)
	sbci temp2, BYTE2   (-1000000000)
	sbci temp3, BYTE3   (-1000000000)
	sbci temp4, BYTE4   (-1000000000)
;---------------------------------------------------------------------------
	clr temp9			
FUNKTION_HEX_ASC_108:	; 100.000.000
	inc temp9
	subi temp1, BYTE1    (100000000)
	sbci temp2, BYTE2    (100000000)
	sbci temp3, BYTE3    (100000000)
	sbci temp4, BYTE4    (100000000)
	brcc FUNKTION_HEX_ASC_108
	subi temp9, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000000)
	sbci temp2, BYTE2   (-100000000)
	sbci temp3, BYTE3   (-100000000)
	sbci temp4, BYTE4   (-100000000)
;---------------------------------------------------------------------------
	clr temp8
FUNKTION_HEX_ASC_107:	; 10.000.000
	inc temp8
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_107
	subi temp8, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
;---------------------------------------------------------------------------
	clr temp7
FUNKTION_HEX_ASC_106:	; 1.000.000
	inc temp7
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_106
	subi temp7, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
;---------------------------------------------------------------------------
	clr temp6
FUNKTION_HEX_ASC_105:	; 100.000	
	inc temp6
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_105
	subi temp6, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
;---------------------------------------------------------------------------	clr temp
	clr temp5
FUNKTION_HEX_ASC_104:	; 10.000	
	inc temp5
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_104
	subi temp5, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
;---------------------------------------------------------------------------
	clr temp4
FUNKTION_HEX_ASC_103:	; 1.000		
	inc temp4
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_103
	subi temp4, (-48+1)	; HEX->ASC	
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
;---------------------------------------------------------------------------
	clr temp3
FUNKTION_HEX_ASC_102:	; 100		
	inc temp3
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_102
	subi temp3, (-48+1)	; HEX->ASC	
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
;---------------------------------------------------------------------------
	clr temp2
FUNKTION_HEX_ASC_101:	; 10		
	inc temp2
	subi temp1, low  (10)
	brcc FUNKTION_HEX_ASC_101
	subi temp2, (-48+1)	; HEX->ASC	
	subi temp1, low  (-10)
;---------------------------------------------------------------------------
FUNKTION_HEX_ASC_100:	; 1			
	subi temp1, -48		; HEX->ASC	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INP: temp1																	
; OUT: (z.B."FF") 																
LCD_HEX8_TEMP1:
	; SICHERUNGSKOPIE						
	push temp
	push temp1
	; oberes NIBBLE bearbeiten				
	mov temp,temp1	
	swap temp						; NIBBLES tausch	
	call LCD_HEX8_UMWANDLUNG	; INP/OUT: temp		
	call LCD_DATA_TEMP					; ANZEIGE			
	; unteres NIBBLE bearbeiten				
	mov temp,temp1	
	call LCD_HEX8_UMWANDLUNG	; INP/OUT: temp		
	call LCD_DATA_TEMP					; ANZEIGE			
	; SICHERUNGSKOPIE wieder herstellen		
	pop temp1
	pop temp
	ret
;-------------------------------------------------------------------------------
LCD_HEX8_UMWANDLUNG:
	; BITMUSTER	
	andi temp,0b00001111
	; vergleich	
	cpi temp,10
	brsh LCD_HEX8_UMWANDLUNG_A_F
LCD_HEX8_UMWANDLUNG_0_9:
	subi temp,-48
	ret
LCD_HEX8_UMWANDLUNG_A_F:
	subi temp,-48-7
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INP: temp1+2																	
; OUT: (z.B."FFFF") 															
LCD_HEX16_TEMP1_TEMP2:
	push temp1
	mov temp1,temp2
	call LCD_HEX8_TEMP1
	pop temp1
	call LCD_HEX8_TEMP1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INP: temp1																	
; OUT: (z.B."00000000") 														
LCD_BIN8_TEMP1:
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	LSL temp1
	rcall LCD_BIN8_TEMP1_10
	ret
LCD_BIN8_TEMP1_10:
	push temp1
	brcc LCD_BIN8_TEMP1_0
	rcall LCD_1
	pop temp1
	ret
LCD_BIN8_TEMP1_0:
	rcall LCD_0
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Text aus Tabelle																
LCD_ANZEIGE_TEXT_Z:
	LPM temp, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp  			
	brne ANZEIGE_TEXT_w
	ret
ANZEIGE_TEXT_w:
	call LCD_DATA_TEMP			; Anzeige
	rjmp LCD_ANZEIGE_TEXT_Z
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Display lschen														  		
LCD_CLEAR:
   	ldi temp, 0b00000001
    call lcd_command
	jmp LCD_ZEILE1
;-------------------------------------------------------------------------------
; KURSOR GO-HOME														  		
LCD_ZEILE1:
 	ldi temp, 0b00000010
	jmp LCD_COMMAND
;-------------------------------------------------------------------------------
; KURSOR Sprung in ZEILE2												  		
LCD_ZEILE2:
 	ldi temp, 0b11000000 
	jmp LCD_COMMAND
;-------------------------------------------------------------------------------
; KURSOR Sprung in ZEILE3														
LCD_ZEILE3:
	ldi temp, 0b10010000 	; LCD 4x16	
	jmp LCD_COMMAND
;-------------------------------------------------------------------------------
; KURSOR Sprung in ZEILE4												  		
LCD_ZEILE4:
	ldi temp, 0b11010000 	; LCD 4x16	
	jmp LCD_COMMAND
;-------------------------------------------------------------------------------
LCD_SPACE:
	ldi temp, ' '			; SPACE
	jmp LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_PUNKT:
	ldi temp, '.'			; PUNKT
	jmp LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_3_PUNKT:
	ldi temp, '.'			;3 PUNKT
	call LCD_DATA_TEMP	
	call LCD_DATA_TEMP	
	jmp  LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_DOPPEL_PUNKT:
	ldi temp, ':'			; DOPPELPUNKT
	jmp LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_DOPPEL_PUNKT_SPACE:
	ldi temp, ':'			; ': '	
	call LCD_DATA_TEMP
	jmp LCD_SPACE
;-------------------------------------------------------------------------------
LCD_MINUS:
	ldi temp, '-'			; '-'	
	jmp LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_0:
	ldi temp, '0'
	jmp LCD_DATA_TEMP	
LCD_1:
	ldi temp, '1'
	jmp LCD_DATA_TEMP	
LCD_2:
	ldi temp, '2'
	jmp LCD_DATA_TEMP	
LCD_3:
	ldi temp, '3'
	jmp LCD_DATA_TEMP	
LCD_4:
	ldi temp, '4'
	jmp LCD_DATA_TEMP	
LCD_5:
	ldi temp, '5'
	jmp LCD_DATA_TEMP	
LCD_6:
	ldi temp, '6'
	jmp LCD_DATA_TEMP	
LCD_7:
	ldi temp, '7'
	jmp LCD_DATA_TEMP	
LCD_8:
	ldi temp, '8'
	jmp LCD_DATA_TEMP	
LCD_9:
	ldi temp, '9'
	jmp LCD_DATA_TEMP	
;-------------------------------------------------------------------------------
LCD_A:
	ldi temp, 'A'
	jmp LCD_DATA_TEMP	
LCD_B:
	ldi temp, 'B'
	jmp LCD_DATA_TEMP	
LCD_C:
	ldi temp, 'C'
	jmp LCD_DATA_TEMP	
LCD_D:
	ldi temp, 'D'
	jmp LCD_DATA_TEMP	
LCD_E:
	ldi temp, 'E'
	jmp LCD_DATA_TEMP	
LCD_F:
	ldi temp, 'F'
	jmp LCD_DATA_TEMP	
LCD_G:
	ldi temp, 'G'
	jmp LCD_DATA_TEMP	
LCD_H:
	ldi temp, 'H'
	jmp LCD_DATA_TEMP	
LCD_I:
	ldi temp, 'I'
	jmp LCD_DATA_TEMP	
LCD_J:
	ldi temp, 'J'
	jmp LCD_DATA_TEMP	
LCD_K:
	ldi temp, 'K'
	jmp LCD_DATA_TEMP	
LCD_L:
	ldi temp, 'L'
	jmp LCD_DATA_TEMP	
LCD_M:
	ldi temp, 'M'
	jmp LCD_DATA_TEMP	
LCD_N:
	ldi temp, 'N'
	jmp LCD_DATA_TEMP	
LCD_O:
	ldi temp, 'O'
	jmp LCD_DATA_TEMP	
LCD_P:
	ldi temp, 'P'
	jmp LCD_DATA_TEMP	
LCD_Q:
	ldi temp, 'Q'
	jmp LCD_DATA_TEMP	
LCD_R:
	ldi temp, 'R'
	jmp LCD_DATA_TEMP	
LCD_S:
	ldi temp, 'S'
	jmp LCD_DATA_TEMP	
LCD_T:
	ldi temp, 'T'
	jmp LCD_DATA_TEMP	
LCD_U:
	ldi temp, 'U'
	jmp LCD_DATA_TEMP	
LCD_V:
	ldi temp, 'V'
	jmp LCD_DATA_TEMP	
LCD_W:
	ldi temp, 'W'
	jmp LCD_DATA_TEMP	
LCD_X:
	ldi temp, 'X'
	jmp LCD_DATA_TEMP	
LCD_Y:
	ldi temp, 'Y'
	jmp LCD_DATA_TEMP	
LCD_Z:
	ldi temp, 'Z'
	jmp LCD_DATA_TEMP	

































