; ##############################################################################
; ##############################################################################
; ##############################################################################
; WDTCSR  Watchdog Timer Control Register										
; WDIF WDIE WDP3 WDCE WDE WDP2 WDP1 WDP0										
; WDP3 WDP2 WDP1 WDP0 Time														
;	0 	0 	0 	0 	2K 	(2048) 	cycles 16 ms									
;	0 	0 	0 	1 	4K 	(4096) 	cycles 32 ms									
;	0 	0 	1 	0 	8K 	(8192) 	cycles 64 ms									
;	0 	0 	1 	1 	16K (16384) cycles 0.125 s									
;	0 	1 	0 	0 	32K (32768) cycles 0.25 s									
; 	0 	1 	0 	1 	64K (65536) cycles 0.5 s									
; *	0 	1 	1 	0 	128K (131072)cycles 1.0 s									
;	0 	1 	1 	1 	256K (262144)cycles 2.0 s									
;	1 	0 	0 	0 	512K (524288)cycles 4.0 s									
;	1 	0 	0 	1 	1024K(1048576)cycles 8.0 s									
; Wenn WDIE=1 dann wird zuerst die WDR-ISR aufgerufen 							
; und dann das System neu gestartet												
WDR_INITIALISIERUNG:
	WDR
	LDS TEMP, WDTCSR
	ori TEMP, (1<<WDCE) | (1<<WDE)
	STS WDTCSR, TEMP
	ldi temp, (1<<WDE)| (1<<WDIE)|(0<<WDP3)|(1<<WDP2)|(1<<WDP1)|(0<<WDP0)
	STS WDTCSR, TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; MCUSR  MCU Status Register													
; 7,6,5,JTRF,WDRF,BORF,EXTRF,PORF												
; NEUSTART ber WDR, wenn BORF,EXTRF,PORF gestzt ist							
NEUSTART_MIT_WDR:
	in temp, MCUSR
	andi temp,0b00000111
	tst temp
	brne NEUSTART_MIT_WDR_FEHLER
	ret
NEUSTART_MIT_WDR_FEHLER:
	out MCUSR,NULL
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (SRAM_START)
	ldi ZH, HIGH(SRAM_START)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-4)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-4)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT A+B+C+D CLEAR																
PORT_CLEAR:
	clr temp
	out DDRA, temp
	out DDRB, temp
	out DDRC, temp
	out DDRD, temp
	out PORTB,temp
	out PORTB,temp
	out PORTC,temp
	out PORTD,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
REGISTER_CLEAR:
	clr R0
	clr R1
	clr R2
	clr R3
	clr R4
	clr R5
	clr R6
	clr R7
	clr R8
	clr R9
	clr R10
	clr R11
	clr R12
	clr R13
	clr R14
	clr R15
	clr R16
	clr R17
	clr R18
	clr R19
	clr R20
	clr R21
	clr R22
	clr R23
	clr R24
	clr R25
	clr R26
	clr R27
	clr R28
	clr R29
	clr R30
	clr R31
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_INITIALISIERUNG:
	; auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)			; GRN		
	sbi (LED_GELB_DDR),(LED_GELB_PIN_NR)			; GELB		
	sbi (LED_ROT_DDR),(LED_ROT_PIN_NR)				; ROT		
	sbi (LED_GELB2_DDR),(LED_GELB2_PIN_NR)			; GELB2		
	sbi (BEEP_DDR),(BEEP_PIN_NR)					; BEEP		
	; LED an									
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)			; GRN an   
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)			; GELB an	
	cbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)			; GELB2an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)				; ROT  an	
	cbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP an	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_TEST:
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)			; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)			; GELB aus	
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)			; GELB2aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)				; ROT  aus	
	sbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP aus	
	call wait_100ms
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)			; GRN an   
	call wait_100ms
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)			; GELB an	
	call wait_100ms
	cbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)			; GELB2 an	
	call wait_100ms
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)				; ROT  an	
	call wait_100ms
	cbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP an	
	call wait_100ms
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)			; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)			; GELB aus	
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)			; GELB2 aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)				; ROT  aus	
	sbi (BEEP_PORT),(BEEP_PIN_NR)					; BEEP aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER_SCHWER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER_SCHWER
	; SRAM CHECK
	LDS temp,(adr_SRAM_CHECK)
	cpi temp,'S'
	brne PROGRAMM_CHECK_FEHLER_SCHWER
ret
;-------------------------------------------------------------------------------
PROGRAMM_CHECK_FEHLER_SCHWER:
	CLI											; INTERRUPTS sperren	
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus  
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	call wait_100ms
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	call wait_100ms
	rjmp PROGRAMM_CHECK_FEHLER_SCHWER
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; INP: temp (Fehler-Code)														
;																				
ERROR_SAVE_TEMP:
	CLI											; INTERRUPTS sperren	
	STS adr_ERROR_CODE,temp						; ERROR-CODE	
	STS adr_ERROR1,temp1	
	STS adr_ERROR2,temp2	
	STS adr_ERROR3,temp3	
	STS adr_ERROR4,temp4	
	STS adr_ERROR5,temp5	
	STS adr_ERROR6,temp6	
	STS adr_ERROR7,temp7	
	STS adr_ERROR8,temp8	
	STS adr_ERROR8,temp9	
	STS adr_ERRORXL,XL
	STS adr_ERRORXH,XH
	STS adr_ERRORYL,YL
	STS adr_ERRORYH,YH
	STS adr_ERRORZL,ZL
	STS adr_ERRORZH,ZH

	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus  
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2aus	
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	call LCD_ANZEIGE_ERROR
ERROR_SAVE_TEMP_s:
	WDR
	rjmp ERROR_SAVE_TEMP_s
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_STOP:
	WDR
	CLI											; INTERRUPTS sperren	
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus  
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	call wait_50ms
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	call wait_50ms
	rjmp PROGRAMM_STOP
; ##############################################################################
; ##############################################################################
