; ##############################################################################
; ##############################################################################
; ##############################################################################
; SPI Mode 	Conditions 		Leading Edge 	Trailing Edge	
;  	0 		CPOL=0, CPHA=0 	Sample (Rising) Setup (Falling)	
;  	1 		CPOL=0, CPHA=1 	Setup (Rising) 	Sample (Falling)
;  	2 		CPOL=1, CPHA=0 	Sample (Falling)Setup (Rising)	
;  	3 		CPOL=1, CPHA=1 	Setup (Falling) Sample (Rising)	
;															
; CPOL Leading Edge Trailing Edge							
;	0 	Rising 		Falling									
;	1 	Falling 	Rising									
;															
; CPHA Leading Edge Trailing Edge							
;	0 	Sample 		Setup									
;	1 	Setup 		Sample									
;															
; SPI2X SPR1 SPR0 	SCK Frequency							
;	0 	0 	  0 	fosc/4									
;	0 	0 	  1 	fosc/16									
;	0 	1  	  0 	fosc/64									
;	0 	1     1 	fosc/128								
;	1 	0     0 	fosc/2									
;	1 	0     1 	fosc/8									
;	1 	1     0 	fosc/32									
;	1 	1     1 	fosc/64									
;															
;DORD: 														
;Data Order=1 the LSB of the data word is transmitted first.
;Data Order=0 the MSB of the data word is transmitted first.
;															
SPI_INITIALISIERUNG:
; SPI											
.equ SPI_CS_PIN_NR							= 4
.equ SPI_CS_DDR								= DDRB
.equ SPI_CS_PORT							= PORTB

	;ldi temp,(0<<SPIE)|(1<<SPE)|(1<<DORD)|(1<<MSTR)|(0<<CPOL)|(0<<CPHA)|(0<<SPR1)|(0<<SPR0)
	ldi temp,(0<<SPIE)|(1<<SPE)|(0<<DORD)|(1<<MSTR)|(0<<CPOL)|(0<<CPHA)|(0<<SPR1)|(0<<SPR0)
	OUT SPCR,temp

	ldi temp, (1<<SPI2X)
	OUT SPSR,temp

	; wichtig !					
	sbi DDRB ,PB5								; PIN MOSI auf AUSGANG	
	sbi DDRB ,PB7								; PIN SCK auf AUSGANG	
	sbi (SPI_CS_DDR),(SPI_CS_PIN_NR)			; CS auf AUSGANG		
	sbi (SPI_CS_PORT),(SPI_CS_PIN_NR)			; CS auf HIGH			
	sbi PORTB,PB6								; PIN MISO PULL-UP		

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_TX_TEMP1:
	out SPDR,temp1
	rcall SPI_WAIT								; Wait for transmission complete
	in DUMMY, SPDR								; RX (DUMMY)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_TX_TEMP2:
	out SPDR,temp2
	rcall SPI_WAIT								; Wait for transmission complete
	in DUMMY, SPDR								; RX (DUMMY)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_TX_DUMMY:
	out SPDR,NULL
	rcall SPI_WAIT								; Wait for transmission complete
	in DUMMY, SPDR								; RX (DUMMY)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_TX_RX_TEMP1:
	out SPDR,temp1
	rcall SPI_WAIT								; Wait for transmission complete
	in temp1, SPDR								; RX (DUMMY)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_RX_TEMP1:
	out SPDR,NULL
	rcall SPI_WAIT								; Wait for transmission complete
	in temp1, SPDR								; RX (DUMMY)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Wait for transmission complete												
SPI_WAIT:
	in DUMMY,SPSR
	SBRS DUMMY,SPIF
	rjmp SPI_WAIT
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_PAUSE:
	call WAIT_10us
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_CS_LOW:
	cbi (SPI_CS_PORT),(SPI_CS_PIN_NR)			; CS auf LOW	
	call SPI_PAUSE								; PAUSE (Testzwecke)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_CS_HIGH:
	sbi (SPI_CS_PORT),(SPI_CS_PIN_NR)			; CS auf HIGH	
	call SPI_PAUSE								; PAUSE (Testzwecke)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
