; ##############################################################################
; ##############################################################################
; ##############################################################################
; 16-BIT-TIMER																	
;																				
; CSn2 CSn1 CSn0																
;   0 	0 	0 	No clock source (Timer/Counter stopped).						
;   0 	0 	1 	clkI/O/1 (No prescaling)										
; 	0 	1 	0 	clkI/O/8 (From prescaler)										
; *	0 	1 	1 	clkI/O/64 (From prescaler)										
; 	1 	0 	0 	clkI/O/256 (From prescaler)										
; 	1 	0 	1 	clkI/O/1024 (From prescaler)									
; 	1 	1 	0 	External clock source on Tn pin. Clock on falling edge.			
; 	1 	1 	1 	External clock source on Tn pin. Clock on rising edge.			
;																				
TIMER1_INITIALISIERUNG:
	;  TCCR1B  Timer/Counter 1 Control Register B			
	ldi temp, (0<<ICNC1)| (0<<ICES1)|(0<<WGM13)|(0<<WGM12)|(0<<CS12)|(1<<CS11)|(1<<CS10)
	STS TCCR1B,temp
	; TIMSK1  Timer/Counter1 Interrupt Mask Register		
	ldi temp, (0<<ICIE1)| (0<<OCIE1B)|(0<<OCIE1A)|(1<<TOIE1)
	STS TIMSK1,temp
	; STARTWERT												
	ldi temp,HIGH(TIMERWERT1)
	STS TCNT1H,temp			; HIGH	
	ldi temp,LOW(TIMERWERT1)
	STS TCNT1L,temp			; LOW	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TIM1_OVF:
	SEI					; INTERRUPTS wieder freigeben (verschachtelter Interrupt)
	push TEMP		    ; Sichern von "TEMP" im Stack			
	in	 TEMP,SREG		; Einlesen des SREG 					
	push TEMP	    	; Schreiben von  SREG  im Stack (KOPIE)	
	push TEMP1
	push TEMP2
	ldi temp,HIGH(TIMERWERT1)	; STARTWERT												
	STS TCNT1H,temp			; HIGH	
	ldi temp,LOW(TIMERWERT1)
	STS TCNT1L,temp			; LOW	

	rcall ZEIT_ss10		; UHR+KALENDER	
	pop temp2
	pop TEMP1
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)		
	out	SREG,TEMP		; Wiederherstellen von SREG				
	pop	TEMP			; Wiederherstellen von "TEMP"
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 10ms-SEKUNDEN																	
ZEIT_ss10:
	LDS temp,(adr_ss10)	; aus SRAM laden			
	inc temp
	STS (adr_ss10),temp	; in SRAM speichern	
	cpi temp,100
	brsh ZEIT_ss
	ret	
;-------------------------------------------------------------------------------
; SEKUNDEN																		
ZEIT_ss:
	STS(adr_ss10),NULL	; in SRAM speichern	

	STS(adr_FREIGABE_SEARCH) ,EINS
	STS(adr_FREIGABE_LCD_ANZEIGE),EINS

	LDS temp,(adr_ss)	; aus SRAM laden			
	inc temp
	STS (adr_ss),temp	; in SRAM speichern	
	cpi temp,60
	brsh ZEIT_MM
	ret	
;-------------------------------------------------------------------------------
; MINUTEN																		
ZEIT_MM:
	STS (adr_ss),NULL	; in SRAM speichern	
	LDS temp,(adr_mm)	; aus SRAM laden	
	inc temp
	STS (adr_mm),temp	; in SRAM speichern	
	cpi temp,60
	brsh ZEIT_HH
	ret	
;-------------------------------------------------------------------------------
; STUNDEN																		
ZEIT_HH:
	STS (adr_mm),NULL	; in SRAM speichern	
	LDS temp,(adr_hh)	; aus SRAM laden	
	inc temp
	STS (adr_hh),temp	; in SRAM speichern	
	cpi temp,24
	brsh ZEIT_TAG
	ret	
;-------------------------------------------------------------------------------
; TAG					
ZEIT_TAG:
	STS (adr_hh),NULL	; in SRAM speichern	
	; WOCHENTAG	1=MO	
	LDS temp,(adr_WOCHENTAG)
	inc temp
	STS(adr_WOCHENTAG),temp
	cpi temp,7+1
	brlo ZEIT_TAG_WOCHENTAG_OK
	STS(adr_WOCHENTAG),EINS
ZEIT_TAG_WOCHENTAG_OK:
	LDS temp,(adr_TAG)	; aus SRAM laden	
	inc temp
	STS (adr_TAG),temp	; in SRAM speichern	
	; vergleich	
	rcall ZEIT_TAGE_IM_MONAT_TEMP1
	cp temp,temp1 
	breq ZEIT_TAG_w
	brsh ZEIT_MONAT
ZEIT_TAG_w:
	ret
;-------------------------------------------------------------------------------
; MONAT					
ZEIT_MONAT:
	STS (adr_TAG),EINS	; TAG=1				
	LDS temp,(adr_MONAT); aus SRAM laden	
	inc temp
	STS (adr_MONAT),temp; in SRAM speichern	
	cpi temp,13 
	brsh ZEIT_JAHR
	ret
;-------------------------------------------------------------------------------
; JAHR					
ZEIT_JAHR:
	STS (adr_MONAT),EINS; in SRAM speichern	
	; JAHR+1			
	LDS temp,(adr_JAHR)	; aus SRAM laden	
	inc temp
	STS (adr_JAHR),temp	; in SRAM speichern	
ret
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
; OUT: temp1 (z.B. 31 fr DEZEMBER)												
; Anzahl der TAGE im Monat	
ZEIT_TAGE_IM_MONAT_TEMP1:
	; MONAT laden			
	LDS temp1,(adr_MONAT)
	; vergleich				
	cpi temp1,2			; Februar 28/29			
	breq ZEIT_TAGE_IM_MONAT_28
	cpi temp1,4			; April 30				
	breq ZEIT_TAGE_IM_MONAT_30
	cpi temp1,6			; Juni 30				
	breq ZEIT_TAGE_IM_MONAT_30
	cpi temp1,9			; September 30			
	breq ZEIT_TAGE_IM_MONAT_30
	cpi temp1,11		; November 30			
	breq ZEIT_TAGE_IM_MONAT_30
ZEIT_TAGE_IM_MONAT_31:
	ldi temp1,31		; MONATE mit 31 TAGEN	
	ret
ZEIT_TAGE_IM_MONAT_28:
	; Jahr laden					
	LDS temp1,(adr_JAHR)
	; SCHKEIFE						
ZEIT_TAGE_IM_MONAT_28s:
	; vergleich						
	subi temp1,4
	tst temp1
	; NULL=Schaltjahr				
	breq ZEIT_TAGE_IM_MONAT_29
	brpl ZEIT_TAGE_IM_MONAT_28s
	; negativ kein Schaltjahr		
	ldi temp1,28
	ret
ZEIT_TAGE_IM_MONAT_29:
	ldi temp1,29
	ret
ZEIT_TAGE_IM_MONAT_30:
	ldi temp1,30
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
