; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_INITIALISIERUNG:
	ldi temp1,TAKT/(BAUD*16)-1  		; Baudrate 	
	ldi temp2,0
	STS UBRR0H, temp2
	STS UBRR0L, temp1
; Enable receiver and transmitter
	ldi temp,(1<<RXCIE0)|(0<<TXCIE0)|(0<<UDRIE0)|(1<<RXEN0)|(1<<TXEN0)|(0<<UCSZ02)|(0<<RXB80)|(0<< TXB80)|(0<<UCSR0B)
	STS UCSR0B,temp
; Set frame format: 8data, 2stop bit		
; USBS Bit Settings							
; USBSn Stop Bit(s)							
; 	0 	1-bit								
; 	1 	2-bit								
; Character Size							
; UCSZn2 	UCSZn1 	UCSZn0 	Character Size	
; 	0 		0 		0 		5-bit			
; 	0 		0 		1 		6-bit			
; 	0 		1 		0 		7-bit			
; 	0 		1 		1 		8-bit			
	ldi temp,(0<<UMSEL01)|(0<<UMSEL00)|(0<<UPM01)|(0<<UPM00)|(1<<USBS0)|(1<<UCSZ01)|(1<<UCSZ00)|(0<<UCPOL0)
	STS UCSR0C,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; USART0 RX Complete															
USART0_RXC:
	push TEMP		    ; "TEMP" sichern	
	in	 TEMP,SREG		; Einlesen des SREG 
	push TEMP	    	; SREG sichern		
;-------------------------------------------------------------------------------
; Wait for data to be received
;	sbis UCSR0A, RXC0
;rjmp USART_Receive
; Get and return received data from buffer
	LDS temp1, UDR0

	rcall USART_TX_TEMP1
;-------------------------------------------------------------------------------
	pop	TEMP			; LESEN von SREG				
	out	SREG,TEMP		; Wiederherstellen von SREG		
	pop	TEMP			; Wiederherstellen von "TEMP" 	
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_TEMP:
	WDR
	LDS  DUMMY,UCSR0A
	SBRS DUMMY,UDRE0	; Wait for empty transmit buffer
	rjmp USART_TX_TEMP
	STS UDR0,temp		; Send DATA					
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_TEMP1:
	WDR
	LDS  DUMMY,UCSR0A
	SBRS DUMMY,UDRE0	; Wait for empty transmit buffer
	rjmp USART_TX_TEMP1
	STS UDR0,temp1		; Send DATA					
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_HEX_TEMP1:
	push temp1
	push temp1
	swap temp1
	andi temp1,0b00001111
	rcall USART_TX_HEX_TEMP1_UMWANDLUNG
	rcall USART_TX_TEMP1		

	pop temp1
	andi temp1,0b00001111
	rcall USART_TX_HEX_TEMP1_UMWANDLUNG
	rcall USART_TX_TEMP1		
	rcall USART_SPACE
	pop temp1
ret
;-------------------------------------------------------------------------------
USART_TX_HEX_TEMP1_UMWANDLUNG:
	cpi temp1,9+1
	brsh USART_TX_HEX_TEMP1_UMWANDLUNG_1
	subi temp1,-48
	ret
USART_TX_HEX_TEMP1_UMWANDLUNG_1:
	subi temp1,-55
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_HEX_TEMP2:
	push temp1
	mov temp1,temp2
	rcall USART_TX_HEX_TEMP1
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_HEX_TEMP:
	push temp1
	mov temp1,temp
	rcall USART_TX_HEX_TEMP1
	pop temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_3_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
	call FUNKTION_HEX_ASC_32
	mov temp,temp3
	call USART_TX_TEMP
	mov temp,temp2
	call USART_TX_TEMP
	mov temp,temp1
	call USART_TX_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TX_5_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
	call FUNKTION_HEX_ASC_32
	mov temp,temp5
	call USART_TX_TEMP
	mov temp,temp4
	call USART_TX_TEMP
	mov temp,temp3
	call USART_TX_TEMP
	mov temp,temp2
	call USART_TX_TEMP
	mov temp,temp1
	call USART_TX_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TEST:
	ldi ZL,LOW (1000)
	ldi ZH,HIGH(1000)
	ldi temp1,0
USART_TEST_s:
	call USART_TX_TEMP1
	inc temp1
	sbiw ZL,1
	tst ZL
	brne USART_TEST_s
	tst ZH
	brne USART_TEST_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_TEXT_Z:
	LPM temp1, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp1  			
	brne USART_TEXT_Z_w
	ret
USART_TEXT_Z_w:
	rcall USART_TX_TEMP1
rjmp USART_TEXT_Z
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_NEW_ZEILE:
	ldi temp1,13
	rcall USART_TX_TEMP1
	ldi temp1,10
	rjmp USART_TX_TEMP1
USART_SPACE:
	ldi temp1,' '
	rjmp USART_TX_TEMP1
USART_PUNKT:
	ldi temp1,'.'
	rjmp USART_TX_TEMP1
USART_DOPPELPUNKT:
	ldi temp1,':'
	rjmp USART_TX_TEMP1
USART_DOPPELPUNKT_SP:
	ldi temp1,':'
	rcall USART_TX_TEMP1
	ldi temp1,' '
	rjmp USART_TX_TEMP1
USART_MINUS:
	ldi temp1,'-'
	rjmp USART_TX_TEMP1
USART_DUMMY:
	ldi temp1,'-'
	rcall USART_TX_TEMP1
	ldi temp1,'-'
	rcall USART_TX_TEMP1
	ldi temp1,' '
	rjmp USART_TX_TEMP1
;-------------------------------------------------------------------------------
USART_0:
	ldi temp1,'0'
	rjmp USART_TX_TEMP1
USART_1:
	ldi temp1,'1'
	rjmp USART_TX_TEMP1
USART_2:
	ldi temp1,'2'
	rjmp USART_TX_TEMP1
USART_3:
	ldi temp1,'3'
	rjmp USART_TX_TEMP1
USART_4:
	ldi temp1,'4'
	rjmp USART_TX_TEMP1
USART_5:
	ldi temp1,'5'
	rjmp USART_TX_TEMP1
USART_6:
	ldi temp1,'6'
	rjmp USART_TX_TEMP1
USART_7:
	ldi temp1,'7'
	rjmp USART_TX_TEMP1
USART_8:
	ldi temp1,'8'
	rjmp USART_TX_TEMP1
USART_9:
	ldi temp1,'9'
	rjmp USART_TX_TEMP1
;-------------------------------------------------------------------------------
USART_A:
	ldi temp1,'A'
	rjmp USART_TX_TEMP1
USART_B:
	ldi temp1,'B'
	rjmp USART_TX_TEMP1
USART_C:
	ldi temp1,'C'
	rjmp USART_TX_TEMP1
USART_D:
	ldi temp1,'D'
	rjmp USART_TX_TEMP1
USART_E:
	ldi temp1,'E'
	rjmp USART_TX_TEMP1
USART_F:
	ldi temp1,'F'
	rjmp USART_TX_TEMP1
USART_G:
	ldi temp1,'G'
	rjmp USART_TX_TEMP1
USART_H:
	ldi temp1,'H'
	rjmp USART_TX_TEMP1
USART_I:
	ldi temp1,'I'
	rjmp USART_TX_TEMP1
USART_J:
	ldi temp1,'J'
	rjmp USART_TX_TEMP1
USART_K:
	ldi temp1,'K'
	rjmp USART_TX_TEMP1
USART_L:
	ldi temp1,'L'
	rjmp USART_TX_TEMP1
USART_M:
	ldi temp1,'M'
	rjmp USART_TX_TEMP1
USART_N:
	ldi temp1,'N'
	rjmp USART_TX_TEMP1
USART_O:
	ldi temp1,'O'
	rjmp USART_TX_TEMP1
USART_P:
	ldi temp1,'P'
	rjmp USART_TX_TEMP1
USART_Q:
	ldi temp1,'Q'
	rjmp USART_TX_TEMP1
USART_R:
	ldi temp1,'R'
	rjmp USART_TX_TEMP1
USART_S:
	ldi temp1,'S'
	rjmp USART_TX_TEMP1
USART_T:
	ldi temp1,'T'
	rjmp USART_TX_TEMP1
USART_U:
	ldi temp1,'U'
	rjmp USART_TX_TEMP1
USART_V:
	ldi temp1,'V'
	rjmp USART_TX_TEMP1
USART_W:
	ldi temp1,'W'
	rjmp USART_TX_TEMP1
USART_X:
	ldi temp1,'X'
	rjmp USART_TX_TEMP1
USART_Y:
	ldi temp1,'Y'
	rjmp USART_TX_TEMP1
USART_Z:
	ldi temp1,'Z'
	rjmp USART_TX_TEMP1


