; ENC28J60																
; ATmega1284P-16MHz 													
;																		
; AVR-STUDIO 4															
; Bernhard.Erfurt@gmx.de												
; VERSION: 05/2016														
;																		

;																		
; GRN leuchtet: 	alles-ok und alles schn							
; GELB leuchtet:	ENC RX/TX											
; GELB2 leuchtet:														
; ROT  leuchtet: 	Error												
;																		

;																		
; Blinken die LEDs, das ist nicht gut !									
;																		
; ROT+GRN blinkt: 			CLKRDY nicht erkannt (ev. Harwarefehler ?)	
; ROT blinkt: 				Fehler im Programmcheck						
; ROT+GELB blinken: 		WDR-Zeitberschreitung						
; ROT+GELB+GRN blinken: 	unkorrekter Interruptaufruf					
;																		

; ATmega1284P 									
.include "m1284pdef.inc"

; KONSTANTEN									
.equ TAKT									= 16000000	; 16 MHz		
; USART											
.equ BAUD									= 9600 
; DEBUGGER										
.equ DEBUG_RX_ON							= 0
.equ DEBUG_TX_ON							= 0
.equ DEBUG_ARP_CHACHE_ON					= 0
.equ DEBUG_TCP_RX_PUSH_ON					= 0
.equ DEBUG_TCP_FLAGS_ON						= 0
; TIMERWERT1									
.equ TIMERWERT1								= 65536-2500;(2 hoch 16 minus...) bei 16MHz + Vorteiler 64 => 10ms 		
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR						= 4
.equ LED_GRUEN_DDR							= DDRA
.equ LED_GRUEN_PORT							= PORTA
; LED-GELB										
.equ LED_GELB_PIN_NR						= 5
.equ LED_GELB_DDR							= DDRA
.equ LED_GELB_PORT							= PORTA
; LED-GELB2										
.equ LED_GELB2_PIN_NR						= 6
.equ LED_GELB2_DDR							= DDRA
.equ LED_GELB2_PORT							= PORTA
; LED-ROT										
.equ LED_ROT_PIN_NR							= 7
.equ LED_ROT_DDR							= DDRA
.equ LED_ROT_PORT							= PORTA
; BEEP										
.equ BEEP_PIN_NR							= 1
.equ BEEP_DDR								= DDRB
.equ BEEP_PORT								= PORTB
; LCD (DATA)									
.equ LCD_DATA0_DDR							= DDRD
.equ LCD_DATA1_DDR							= DDRD
.equ LCD_DATA2_DDR							= DDRD
.equ LCD_DATA3_DDR							= DDRD
.equ LCD_DATA0_PORT							= PORTD
.equ LCD_DATA1_PORT							= PORTD
.equ LCD_DATA2_PORT							= PORTD
.equ LCD_DATA3_PORT							= PORTD
.equ LCD_DATA0								= 7
.equ LCD_DATA1								= 6
.equ LCD_DATA2								= 5
.equ LCD_DATA3								= 4
; LCD RS (Befehl/DATEN)							
.equ LCD_RS_DDR								= DDRB
.equ LCD_RS_PORT							= PORTB
.equ LCD_RS									= 3
; LCD_ENABLE									
.equ LCD_EN_DDR								= DDRB
.equ LCD_EN_PORT							= PORTB
.equ LCD_EN									= 0
; TX_CONTROLWORT								
.equ TX_CONTROLWORT							= 0b00001110 
; ERROR-CODES									
.equ ERROR_DUMMYx							= 0xFF		; DUMMY					
.equ ERROR_ENC_BFS							= 0x01		; Bit Field Set			
.equ ERROR_ENC_BFC							= 0x02		; Bit Field Clear		
.equ ERROR_ENC_RCR							= 0x03		; Read Control Register	
.equ ERROR_ENC_WCR							= 0x04		; Write Control Register
.equ ERROR_ENC_RBM							= 0x05		; Read Buffer Memory	
.equ ERROR_ENC_WBM							= 0x06		; Write Buffer Memory	
.equ ERROR_ENC_READ_PHY_REGISTER			= 0x07		; READ_PHY_REGISTER		
.equ ERROR_ENC_WRITE_PHY_REGISTER			= 0x08		; WRITE_PHY_REGISTER	
.equ ERROR_CONTROL_REGISTER_CHECK			= 0x0A		; CONTROL-REGISTER-CHECK
.equ ERROR_ENC_MAC_ADR						= 0x0B		; MAC-Adresse			
.equ ERROR_HTML_CONTENENT_LENGTH			= 0x10		; HTML CONTENENT_LENGTH	
; MAC-Adresse MAC 00:22:F9:01:BC:27						
.equ MACeigene0			= 0x00	 
.equ MACeigene1			= 0x22 
.equ MACeigene2			= 0xF9 
.equ MACeigene3			= 0xFF
.equ MACeigene4			= 0xFF 
.equ MACeigene5			= 0xFF 
; IP-ADRESSE eigene privat (192.168.0.90)				
.equ IPeigene0			= 192
.equ IPeigene1			= 168
.equ IPeigene2			= 0
.equ IPeigene3			= 90
; IP-ADRESSE ROUTER privat (192.168.0.1)				
.equ IProuter0			= 192
.equ IProuter1			= 168
.equ IProuter2			= 0
.equ IProuter3			= 1
; MODUL-NR												
.equ MODUL_RX			= 0x10
.equ MODUL_RX_ARP		= 0x11
.equ MODUL_RX_ICMP		= 0x12
.equ MODUL_RX_TCP		= 0x13
.equ MODUL_TCP_CRC		= 0x14
.equ MODUL_TX			= 0x40
.equ MODUL_HTML			= 0x50
; REGISTER												
.def ERROR			= R12
.def DUMMY			= R13
.def NULL 			= R14	; ist immer NULL 	
.def EINS 			= R15	; ist immer EINS 	
.def temp 			= R16
.def temp1 			= R17
.def temp2 			= R18
.def temp3 			= R19
.def temp4 			= R20
.def temp5 			= R21
.def temp6 			= R22
.def temp7 			= R23
.def temp8 			= R24
.def temp9 			= R25

; SRAM-BELEGUNG Adr:0x0100-0x40FF(256-16.639=16383)		
.equ adr_DATEN							=SRAM_START+0		
.equ adr_MODUL_NR						=SRAM_START+1						

.equ adr_FREIGABE_SEARCH				=SRAM_START+10					
.equ adr_FREIGABE_LCD_ANZEIGE			=SRAM_START+11					

.equ adr_ss10							=SRAM_START+20	; 10ms Sekunden				
.equ adr_ss								=SRAM_START+21	; Sekunden					
.equ adr_mm								=SRAM_START+22	; Minuten					
.equ adr_hh								=SRAM_START+23	; Stunden					
.equ adr_TAG							=SRAM_START+24	; TAG						
.equ adr_MONAT							=SRAM_START+25	; Monat						
.equ adr_JAHR							=SRAM_START+26	; JAHR						
.equ adr_WOCHENTAG						=SRAM_START+27	; 1=Mo 7=So					

.equ adr_ERROR_CODE						=SRAM_START+110	; ERROR-Anzeige				
.equ adr_ERROR1							=SRAM_START+111		
.equ adr_ERROR2							=SRAM_START+112		
.equ adr_ERROR3							=SRAM_START+113		
.equ adr_ERROR4							=SRAM_START+114		
.equ adr_ERROR5							=SRAM_START+115		
.equ adr_ERROR6							=SRAM_START+116		
.equ adr_ERROR7							=SRAM_START+117		
.equ adr_ERROR8							=SRAM_START+118		
.equ adr_ERROR9							=SRAM_START+119		
.equ adr_ERRORXL						=SRAM_START+120
.equ adr_ERRORXH						=SRAM_START+121
.equ adr_ERRORYL						=SRAM_START+122
.equ adr_ERRORYH						=SRAM_START+123
.equ adr_ERRORZL						=SRAM_START+124
.equ adr_ERRORZH						=SRAM_START+125

.equ adr_IP_EIGENE0						=SRAM_START+900	; IP eigene					
.equ adr_IP_EIGENE1						=SRAM_START+901
.equ adr_IP_EIGENE2						=SRAM_START+902
.equ adr_IP_EIGENE3						=SRAM_START+903
.equ adr_IP_SCAN_NR						=SRAM_START+904

.equ adr_TCP_DATA_LENGTH_L				=SRAM_START+910	; TCP						
.equ adr_TCP_DATA_LENGTH_H				=SRAM_START+911

.equ adr_TCP_TX_DATA_LENGTH_L			=SRAM_START+912
.equ adr_TCP_TX_DATA_LENGTH_H			=SRAM_START+913

.equ adr_TCP_ANZAHL_AUFRUFE_L			=SRAM_START+915
.equ adr_TCP_ANZAHL_AUFRUFE_H			=SRAM_START+916

.equ adr_TCP_FLAGS						=SRAM_START+918

.equ adr_TCP_NEXT_ACK_0					=SRAM_START+920	; Next ACK Nummer	
.equ adr_TCP_NEXT_ACK_1					=SRAM_START+921
.equ adr_TCP_NEXT_ACK_2					=SRAM_START+922
.equ adr_TCP_NEXT_ACK_3					=SRAM_START+923

.equ adr_TCP_PORT_DESTINATION_L			=SRAM_START+930		; bei TCP 		
.equ adr_TCP_PORT_DESTINATION_H			=SRAM_START+931			

.equ adr_TCP_PORT_SOURCE_L				=SRAM_START+932		; bei TCP 		
.equ adr_TCP_PORT_SOURCE_H				=SRAM_START+933			

.equ adr_TCP_SourceMACaddr0				=SRAM_START+940		; bei TCP  
.equ adr_TCP_SourceMACaddr1				=SRAM_START+941
.equ adr_TCP_SourceMACaddr2				=SRAM_START+942
.equ adr_TCP_SourceMACaddr3				=SRAM_START+943
.equ adr_TCP_SourceMACaddr4				=SRAM_START+944
.equ adr_TCP_SourceMACaddr5				=SRAM_START+945

.equ adr_TCP_IP4SourceIPaddr3			=SRAM_START+950
.equ adr_TCP_IP4SourceIPaddr2			=SRAM_START+951
.equ adr_TCP_IP4SourceIPaddr1			=SRAM_START+952
.equ adr_TCP_IP4SourceIPaddr0			=SRAM_START+953

.equ adr_HTML_CONTENENT_LENGTH_L		=SRAM_START+960
.equ adr_HTML_CONTENENT_LENGTH_H		=SRAM_START+961

.equ adr_ENC_RX_PAKET_COUNTER_L			=SRAM_START+1000
.equ adr_ENC_RX_PAKET_COUNTER_H			=SRAM_START+1001
.equ adr_ENC_RX_PAKET_COUNTER_ERROR_L	=SRAM_START+1002
.equ adr_ENC_RX_PAKET_COUNTER_ERROR_H	=SRAM_START+1003
.equ adr_ENC_RX_NEXT_READ_POINTER_L		=SRAM_START+1004 	; Next Read Pointer(L) 
.equ adr_ENC_RX_NEXT_READ_POINTER_H		=SRAM_START+1005 	; Next Read Pointer(H) 
.equ adr_ENC_RX_FRAME_LENGTH_L			=SRAM_START+1006
.equ adr_ENC_RX_FRAME_LENGTH_H			=SRAM_START+1007

.equ adr_ENC_TX_PAKET_COUNTER_L			=SRAM_START+1010
.equ adr_ENC_TX_PAKET_COUNTER_H			=SRAM_START+1011
.equ adr_ENC_TX_PAKET_COUNTER_ERROR_L	=SRAM_START+1012
.equ adr_ENC_TX_PAKET_COUNTER_ERROR_H	=SRAM_START+1013
.equ adr_ENC_TX_FRAME_LENGTH_L			=SRAM_START+1014
.equ adr_ENC_TX_FRAME_LENGTH_H			=SRAM_START+1015
.equ adr_ENC_TX_STATUS_VECTOR_0			=SRAM_START+1016
.equ adr_ENC_TX_STATUS_VECTOR_1			=SRAM_START+1017
.equ adr_ENC_TX_STATUS_VECTOR_2			=SRAM_START+1018
.equ adr_ENC_TX_STATUS_VECTOR_3			=SRAM_START+1019
.equ adr_ENC_TX_STATUS_VECTOR_4			=SRAM_START+1020
.equ adr_ENC_TX_STATUS_VECTOR_5			=SRAM_START+1021
.equ adr_ENC_TX_STATUS_VECTOR_6			=SRAM_START+1022
.equ adr_ENC_TX_STATUS_VECTOR_7			=SRAM_START+1023
.equ adr_ENC_DATA						=SRAM_START+1100	; ca. 1500 Bytes Data


.equ adr_ARP_CHACHE_MAC0				=SRAM_START+3000	
.equ adr_ARP_CHACHE_MAC1				=SRAM_START+3001
.equ adr_ARP_CHACHE_MAC2				=SRAM_START+3002
.equ adr_ARP_CHACHE_MAC3				=SRAM_START+3003
.equ adr_ARP_CHACHE_MAC4				=SRAM_START+3004
.equ adr_ARP_CHACHE_MAC5				=SRAM_START+3005
.equ adr_ARP_CHACHE_IP0					=SRAM_START+3006
.equ adr_ARP_CHACHE_IP1					=SRAM_START+3007
.equ adr_ARP_CHACHE_IP2					=SRAM_START+3008
.equ adr_ARP_CHACHE_IP3					=SRAM_START+3009
.equ adr_ARP_CHACHE_ANZAHL				=SRAM_START+3010
.equ adr_ARP_CHACHE_DATA				=SRAM_START+3020	; Chache Data_Bereich	

.equ adr_TCP_IP_CHACHE					=SRAM_START+4000	; TCP Data_Bereich		


.equ adr_SRAM_CHECK						=SRAM_START+16300	; SRAM CHECK muss immer "S" sein	

;---------------------------------------------------------------------------
.cseg							;Beginn eines Code-Segmentes				
.org 0							;Startadresse=0								
.org 0x0000 jmp RESET 			; Reset										
.org 0x0002 jmp INTERRUPT_ERROR ;jmp EXT_INT0 ; IRQ0						
.org 0x0004 jmp INTERRUPT_ERROR ;jmp EXT_INT1 ; IRQ1						
.org 0x0006 jmp EXT_INT2 		; IRQ2										
.org 0x0008 jmp INTERRUPT_ERROR ;jmp PCINT0 ; PCINT0						
.org 0x000A jmp INTERRUPT_ERROR ;jmp PCINT1 ; PCINT1						
.org 0x000C jmp INTERRUPT_ERROR ;jmp PCINT2 ; PCINT2						
.org 0x000E jmp INTERRUPT_ERROR ;jmp PCINT3 ; PCINT3						
.org 0x0010 jmp WDT 		 	; Watchdog Timeout							
.org 0x0012 jmp INTERRUPT_ERROR ;jmp TIM2_COMPA ; Timer2 CompareA			
.org 0x0014 jmp INTERRUPT_ERROR ;jmp TIM2_COMPB ; Timer2 CompareB			
.org 0x0016 jmp INTERRUPT_ERROR ;jmp TIM2_OVF 	; Timer2 Overflow			
.org 0x0018 jmp INTERRUPT_ERROR ;jmp TIM1_CAPT 	; Timer1 Capture			
.org 0x001A jmp INTERRUPT_ERROR ;jmp TIM1_COMPA ; Timer1 CompareA			
.org 0x001C jmp INTERRUPT_ERROR ;jmp TIM1_COMPB ; Timer1 CompareB			
.org 0x001E jmp TIM1_OVF 		; Timer1 Overflow							
.org 0x0020 jmp INTERRUPT_ERROR ;jmp TIM0_COMPA ; Timer0 CompareA			
.org 0x0022 jmp INTERRUPT_ERROR ;jmp TIM0_COMPB ; Timer0 CompareB			
.org 0x0024 jmp INTERRUPT_ERROR ;jmp TIM0_OVF 	; Timer0 Overflow			
.org 0x0026 jmp INTERRUPT_ERROR ;jmp SPI_STC ; SPI Transfer Complete		
.org 0x0028 jmp USART0_RXC 		; USART0 RX Complete						
.org 0x002A jmp INTERRUPT_ERROR ;jmp USART0_UDRE ; USART0,UDR Empty			
.org 0x002C jmp INTERRUPT_ERROR ;jmp USART0_TXC ; USART0 TX Complete		
.org 0x002E jmp INTERRUPT_ERROR ;jmp ANA_COMP ; Analog Comparator			
.org 0x0030 jmp INTERRUPT_ERROR ;jmp ADC ; ADC Conversion Complete			
.org 0x0032 jmp INTERRUPT_ERROR ;jmp EE_RDY ; EEPROM Ready					
.org 0x0034 jmp INTERRUPT_ERROR ;jmp TWI ; 2-wire Serial					
.org 0x0036 jmp INTERRUPT_ERROR ;jmp SPM_RDY ; SPM Ready					
.org 0x0038 jmp INTERRUPT_ERROR ;jmp USART1_RXC ; USART1 RX Complete		
.org 0x003A jmp INTERRUPT_ERROR ;jmp USART1_UDRE ; USART1,UDR Empty			
.org 0x003C jmp INTERRUPT_ERROR ;jmp USART1_TXC ; USART1 TX Complete		
.org 0x003E jmp INTERRUPT_ERROR ;jmp TIM3_CAPT ; Timer3 Capture				
.org 0x0040 jmp INTERRUPT_ERROR ;jmp TIM3_COMPA ; Timer3 CompareA								
.org 0x0042 jmp INTERRUPT_ERROR ;jmp TIM3_COMPB ; Timer3 CompareB			
.org 0x0044 jmp INTERRUPT_ERROR ;jmp TIM3_OVF 	; Timer3 Overflow			
; Unkorrekten Interrupt Aufruf 												
INTERRUPT_ERROR:
	WDR
	CLI											; INTERRUPTS sperren	
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus  
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	call wait_100ms
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an   
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	call wait_100ms
rjmp INTERRUPT_ERROR
; Diese Routine wird bei WDR-Zeitberschreitung aufgerufen, hier knnte man		
; sich z.B. den Fehler anzeigen lasen, oder DATEN in den EEPROM schreiben		
WDT:
	ldi temp9,20
	CLI											; INTERRUPTS sperren	
WDT_s:
	push temp9
	WDR
	call LCD_ANZEIGE_WDR_ERROR					; LCD		
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus  
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	call wait_100ms
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	call wait_100ms
	pop temp9
	dec temp9
	brne WDT_s
rjmp WDT_s
WDT_NEUSTART:
	rjmp WDT_NEUSTART
;-------------------------------------------------------------------------------
RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM_CLEAR										
	call SRAM_CLEAR
; PORT_CLEAR										
	call PORT_CLEAR
; REGISTER_CLEAR									
	call REGISTER_CLEAR
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
	; ZEIT_DATUM		
	ldi temp1,1
	ldi temp2,6
	ldi temp3,16
	ldi temp4,1
	STS(adr_TAG)  ,temp1
	STS(adr_MONAT),temp2
	STS(adr_JAHR) ,temp3
	STS(adr_WOCHENTAG),temp4


	; IP-Adresse		
	ldi temp1,IPeigene0
	ldi temp2,IPeigene1
	ldi temp3,IPeigene2
	ldi temp4,IPeigene3
	STS(adr_IP_EIGENE0),temp1
	STS(adr_IP_EIGENE1),temp2
	STS(adr_IP_EIGENE2),temp3
	STS(adr_IP_EIGENE3),temp4
; WDR_INITIALISIERUNG								
	call WDR_INITIALISIERUNG
; LED_INITIALISIERUNG								
	call LED_INITIALISIERUNG
; LED_TEST											
	call LED_TEST
; TIMER1_INITIALISIERUNG							
	call TIMER1_INITIALISIERUNG
; USART_INITIALISIERUNG								
	call USART_INITIALISIERUNG
; SPI_INITIALISIERUNG								
	call SPI_INITIALISIERUNG
; EXT_INTERRUPT_INITIALISIERUNG						
	call EXT_INTERRUPT_INITIALISIERUNG
; LCD_INITIALISIERUNG								
	call LCD_INITIALISIERUNG
	call LCD_ANZEIGE_BEGRUESSUNG
	call LCD_ANZEIGE_BEGRUESSUNG2
; PROGRAMM_CHECK									
	call PROGRAMM_CHECK
; ENC_INITIALISIERUNG								
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	call ENC_INITIALISIERUNG
; Interrupts freigeben								
	sei
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus  
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus	
	sbi (LED_GELB2_PORT),(LED_GELB2_PIN_NR)		; GELB2 aus	

	call DEBUG_START
	call ARP_TX_REQUEST_ROUTER

	call LCD_CLEAR
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR					; Watch-Dog-RESET		
	call PROGRAMM_CHECK
	call ENC_MAC_ADRESSE_CHECK
	ldi temp1,(EPKTCNT)	; Ethernet Packet Count	
	call ENC_RCR_TEMP1	; INP: temp1(cod+addr) OUT: temp1(data)			
	tst temp1
	breq LOOP_w1
	call ENC_RX
	jmp LOOP
;-------------------------------------------------------------------------------
LOOP_w1:
	LDS temp,(adr_FREIGABE_SEARCH)
	tst temp
	breq LOOP_w2 
	STS(adr_FREIGABE_SEARCH),NULL
	call ARP_TX_REQUEST_ROUTER
	call ARP_TX_REQUEST_ALLE
	jmp LOOP
;-------------------------------------------------------------------------------
LOOP_w2:
	LDS temp,(adr_FREIGABE_LCD_ANZEIGE)
	tst temp
	breq LOOP_w3
	STS(adr_FREIGABE_LCD_ANZEIGE),NULL
	call LCD_ANZEIGE_STATUS
	
;-------------------------------------------------------------------------------
LOOP_w3:

rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "NET_ENC28J60.asm"				; ENC28J60 Definitionen			
.include "NET_ENC_INITIALISIERUNG.asm"	; ENC-INITIALISIERUNG			
.include "NET_ENC_SUB.asm"				; ENC-SUB						
.include "NET_ENC_RX.asm"				; ENC-RX						
.include "NET_ENC_TX.asm"				; ENC-TX						
.include "NET_ENC_FUNCTION.asm"			; ENC-Funktionen				
.include "NET_IP_ARP.asm"				; ARP							
.include "NET_IP_ARP_CACHE.asm"			; ARP-CACHE						
.include "NET_IP_ICMP.asm"				; ICMP							
.include "NET_IP_TCP.asm"				; TCP							
.include "NET_IP_HTML.asm"				; HTTP / HTML					
.include "NET_IP_HTML_SONSTIGES.asm"	; HTTP / HTML					
.include "NET_SPI.asm"					; SPI							
.include "NET_EXT_INTERRUPT.asm"		; ext. Interupt					
.include "NET_LCD_ini.asm"				; LCD							
.include "NET_LCD.asm"					; LCD							
.include "NET_LCD_KURZ.asm"				; LCD							
.include "NET_SONSTIGES.asm"			; sonstiges						
.include "NET_USART.asm"				; USART							
.include "NET_TIMER.asm"				; TIMER							
.include "NET_DEBUG.asm"				; DEBUG							
.include "NET_WAIT_16MHZ.asm"			; WAIT							
; ##############################################################################
; ##############################################################################
; ##############################################################################
