/*
 * CFile1.c
 *
 * Created: 17.08.2015 09:27:05
 *  Author: dallmann
 */ 

#include <asf.h>

#include "ADS1262.h"

struct spi_device		ADS1262_cs;

volatile uint16_t		ADS1262_val;

void ADS1262_init(void)
{	//uint8_t		buf[1];

	// SPI
	ioport_configure_pin(MISO_ADC,		IOPORT_DIR_INPUT);							// MISO
	ioport_configure_pin(MOSI_ADC,		IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);		// MOSI
	ioport_configure_pin(SCK_ADC,		IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);		// SCK
		
	// Chip Selects
	ioport_configure_pin(ADS1262_CS,	IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);	
	
	ioport_configure_pin(ADS1262_START, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);
	ioport_configure_pin(ADS1262_DRDY,	IOPORT_DIR_INPUT  | IOPORT_PULL_UP);
	ioport_configure_pin(ADS1262_RESET, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);
	
	ADS1262_cs.id = ADS1262_CS;

	spi_master_init(SPI_ADC);
	spi_master_setup_device(SPI_ADC, &ADS1262_cs, SPI_MODE_1, 1000000, 0);	
	spi_enable(SPI_ADC); 	
	//ADS1262_set(ADS1262_CH_ALL, ADS1262_CMD_WRITE, 0x8000);
	//ADS1262_cmd(ADS1262_CMD_RESET);
	//uint8_t dat= 0x01;
	//ADS1262_REG((ADS1262_CMD_WREG | 1), 0, &dat);

	//buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
	//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);

	return;
}

void ADS1262_REG(uint8_t cmd, uint8_t num, uint8_t *val)
{	// lesen oder Schreiben von 'num' registerwerten ab 'cmd' adresse
	uint8_t i;//data,busy;
	
/*	busy = ioport_get_pin_level(ADS1262_DRDY);
	while(busy!= 0x00)
	{	//printf(" mode: 0x%02X; \n\r ", (uint16_t)mode);
		busy = ioport_get_pin_level(ADS1262_DRDY);
	}
*/
	spi_select_device(SPI_ADC, &ADS1262_cs);

//	data = cmd | addr;

	spi_write_single(SPI_ADC, cmd);
	while(!spi_is_tx_ok(SPI_ADC));
	spi_write_single(SPI_ADC, num);
	while(!spi_is_tx_ok(SPI_ADC));
	
	for(i=0; i<=num; i++)
	{
		spi_write_single(SPI_ADC, *(val+i));
		while(!spi_is_tx_ok(SPI_ADC));
		*(val+i) = spi_get(SPI_ADC);
	}
		spi_write_single(SPI_ADC, *(val+i));
		while(!spi_is_tx_ok(SPI_ADC));
		*(val+i) = spi_get(SPI_ADC);

	spi_deselect_device(SPI_ADC, &ADS1262_cs);
		
	return;
}

uint8_t ADS1262_read(int32_t *val)
{	//lesen eines Wertes
	uint8_t		status, d;
	uint32_t	l=0;
	
	spi_select_device(SPI_ADC, &ADS1262_cs);

	spi_write_single(SPI_ADC, ADS1262_CMD_RDATA);
	while(!spi_is_tx_ok(SPI_ADC));
	
	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));
	status = spi_get(SPI_ADC);
	
	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));
	d = spi_get(SPI_ADC);
	l = l | (((uint32_t)(d)) << 24);
	
	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));
	d = spi_get(SPI_ADC);
	l = l | (((uint32_t)(d)) << 16);

	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));
	d = spi_get(SPI_ADC);
	l = l | (((uint32_t)(d)) <<  8);

	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));
	d = spi_get(SPI_ADC);
	l = l | ((uint32_t)(d)) ;

	spi_write_single(SPI_ADC, 0);
	while(!spi_is_tx_ok(SPI_ADC));

	spi_deselect_device(SPI_ADC, &ADS1262_cs);

	*val = (int32_t)l;
	
	return status;
}

void ADS1262_cmd(uint8_t cmd)
{	// schreiben eines 1Byte Commandos Stat,Stop, RST, ect.
	uint8_t busy;
	
	busy = ioport_get_pin_level(ADS1262_DRDY);
	while(busy != 0x00)
	{	//printf(" mode: 0x%02X; \n\r ", (uint16_t)mode);
		busy = ioport_get_pin_level(ADS1262_DRDY);
	}
	spi_select_device(SPI_ADC, &ADS1262_cs);

	spi_write_single(SPI_ADC, cmd);
	while(!spi_is_tx_ok(SPI_ADC));

	spi_deselect_device(SPI_ADC, &ADS1262_cs);

	return;
}

float Get_ADC(uint8_t ch, uint8_t verbose, uint8_t mean)
{
	float		db_data, f_data;
	int32_t		qdata;
	uint8_t		status, dry, i;
	
	//do{	dry = ioport_get_pin_level(ADS1262_DRDY);
		////printf(" mode: 0x%02X; \n\r ", (uint16_t)mode);
	//}while(dry != 0x00);
	ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &ch);
	//do{	dry = ioport_get_pin_level(ADS1262_DRDY);
		////printf(" mode: 0x%02X; \n\r ", (uint16_t)mode);
	//}while(dry != 0x00);
	//ADS1262_cmd(ADS1262_CMD_START);
	do{	dry = ioport_get_pin_level(ADS1262_DRDY);
		//printf(" mode: 0x%02X; \n\r ", (uint16_t)mode);
	}while(dry != 0x00);
	
	do{	status = ADS1262_read(&qdata);
	} while ((status & 0x40)== 0x00);
	
	f_data= 0.0;
	for (i=0;i<mean;i++)
	{
		do{	status = ADS1262_read(&qdata);
		} while ((status & 0x40)== 0x00);
		
		//if( (verbose != 0) || (status != 0x41))
		//{	printf(" Read Status ADS1262: 0x%02X; Data: 0x%08lX ", (uint16_t)status, qdata);
			//if((status & 0x40)== 0x00)printf(" no new DATA!; ");
			//if((status & 0x02)== 0x02)printf(" PGA Differential output Alarm!; ");
			//if((status & 0x04)== 0x04)printf(" PGA Hihg End Alarm!; ");
			//if((status & 0x08)== 0x08)printf(" PGA Low End Alarm!; ");
			//printf("\n\r");
		//}
		
		db_data = (float)qdata * 2.5 / 2147483648.0;//4294967295.0;
		f_data += db_data;
	}
	
	f_data = f_data/(float)mean;
	//printf(" U: %fV \n\r ", (float)db_data);
	
	return (float)f_data;
}

float Get_PT1000(void)
{	int		i;
	float	f_data, f_data1;
	
	f_data = 0.0;
	f_data1 = 0.0;
	for (i=0;i<8;i++)
	 	f_data = Get_ADC(ADC_IMUX_PT1000,0,1);
	for (i=0;i<8;i++)
		f_data1 = Get_ADC(ADC_IMUX_PT_REF,0,1);
	
	//printf(" U: %7.6fV; ", f_data/8.0);
	//printf(" U: %7.6fV ", f_data1/8.0);
	f_data = (f_data / f_data1)-1;
	f_data = f_data / 0.003851;
	
	return f_data;
}
