/*
 * IncFile1.h
 *
 * Created: 17.08.2015 09:27:43
 *  Author: dallmann
 */ 


#ifndef ADS1262_H_
#define ADS1262_H_

#define ADS1262_CMD_NOP			0x00
#define ADS1262_CMD_RESET		0x06
#define ADS1262_CMD_START		0x08
#define ADS1262_CMD_STOP		0x0A
#define ADS1262_CMD_RDATA		0x12
#define ADS1262_CMD_SYOCAL		0x16
#define ADS1262_CMD_SYGCAL		0x17
#define ADS1262_CMD_SYFCAL		0x19
#define ADS1262_CMD_RREG		0x20
#define ADS1262_CMD_WREG		0x40

#define ADS1262_REG_ID			0x00
#define ADS1262_REG_POWER		0x01
#define ADS1262_REG_INTERFACE	0x02
#define ADS1262_REG_MODE		0x03	//3x
#define ADS1262_REG_MODE2		0x05	//3x
#define ADS1262_REG_INMUX		0x06
#define ADS1262_REG_OFCAL		0x07	//3x
#define ADS1262_REG_FSCAL		0x0A	//3x
#define ADS1262_REG_REF_MUX		0x0F
#define ADS1262_REG_			0x
#define ADS1262_REG_			0x
#define ADS1262_REG_			0x
										// Protokoll
#define ADC_IMUX_ISFET			0x7A	// 0
#define ADC_IMUX_REFET			0x6A	// 1
#define ADC_IMUX_IS_REF_DIFF	0x76	// 2
#define ADC_IMUX_PT1000			0x89
#define ADC_IMUX_PT_REF			0x9A
#define ADC_IMUX_T_MOS			0x5A
#define ADC_IMUX_T_PN			0x4A
#define ADC_IMUX_pH_Krause		0x3A
#define ADC_IMUX_TEMP_MON		0xBB
#define ADC_IMUX_AVCC_MON		0xCC
#define ADC_IMUX_DVCC_MON		0xDD
#define ADC_IMUX_REF_POT		0x0A	// 3
#define ADC_IMUX_UDS0			0x71
#define ADC_IMUX_UDS1			0x62


#define ADC_MODE_Gain_bypass	0x80
#define ADC_MODE_Gain_1			0x00
#define ADC_MODE_Gain_2			0x10
#define ADC_MODE_Gain_4			0x20
#define ADC_MODE_Gain_8			0x30
#define ADC_MODE_Gain_16		0x40
#define ADC_MODE_Gain_32		0x50

#define ADC_MODE_DR_0002		0x00
#define ADC_MODE_DR_0020		0x04
#define ADC_MODE_DR_0100		0x06
#define ADC_MODE_DR_0400		0x08
#define ADC_MODE_DR_2400		0x0A
#define ADC_MODE_DR_7200		0x0C
#define ADC_MODE_DR_38k			0x0F


#define ADS1262_START		IOPORT_CREATE_PIN(PORTC, 0)
#define ADS1262_DRDY		IOPORT_CREATE_PIN(PORTC, 1)
#define ADS1262_RESET		IOPORT_CREATE_PIN(PORTC, 2)

// Chip Selects
#define ADS1262_CS			IOPORT_CREATE_PIN(PORTC, 3)
//#define SS_ADC				IOPORT_CREATE_PIN(PORTF, 4)
// SPI
#define MOSI_ADC			IOPORT_CREATE_PIN(PORTC, 5)
#define MISO_ADC			IOPORT_CREATE_PIN(PORTC, 6)
#define SCK_ADC				IOPORT_CREATE_PIN(PORTC, 7)
#define SPI_ADC				&SPIC


void ADS1262_init(void);					// init ADS1262
void ADS1262_REG(uint8_t cmd, uint8_t num, uint8_t *val);
uint8_t ADS1262_read(int32_t *val);
void ADS1262_cmd(uint8_t cmd);
float Get_ADC(uint8_t ch, uint8_t verbose, uint8_t mean);
float Get_PT1000(void);


#endif /* ADS1262_H_ */