/*
 * LF
.c
 *
 * Created: 22.09.2015 14:01:20
 *  Author: dallmann
 */ 

#include <asf.h>
#include "LF.h"

struct spi_device		LTC1407_cs;
static volatile uint8_t	irq_flg = 0;
uint32_t ref_R, freq_i;


void PWM_init(uint32_t freq)//46Hz - 3MHz
{	uint32_t per;
	uint16_t irq_cnt;
	
	freq_i	= freq;
	per		= 24000000 / 8 / freq;
	irq_cnt = (per>>2);
	if(irq_cnt > 35) 
		 irq_cnt = irq_cnt - 35;
	else irq_cnt = 0;
		
	
	ioport_configure_pin(PWM_PIN, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);

	
	tc_enable(PWM_CH);
	tc_set_wgm(PWM_CH, TC_WG_SS);
	tc_write_period(PWM_CH,(uint16_t)per);
	tc_write_cc(PWM_CH, TC_CCA, (uint16_t)per>>1);
	tc_enable_cc_channels(PWM_CH,TC_CCAEN);
	tc_write_clock_source(PWM_CH, TC_CLKSEL_DIV8_gc);
	// fr Interrupt zum ADC start
	//pmic_init();			//Enable the interrupt controller
	//cpu_irq_enable();		//Enable interrupts

	tc_set_ccb_interrupt_callback(PWM_CH, my_LTC1407_callback);
	tc_write_cc(PWM_CH, TC_CCB, irq_cnt);
	tc_enable_cc_channels(PWM_CH,(TC_CCBEN));
	tc_set_ccb_interrupt_level(PWM_CH, TC_INT_LVL_LO);
//

}

void LTC1407_init(void)
{
	ioport_configure_pin(LF_MUX_A0, IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);
	ioport_configure_pin(LF_MUX_A1, IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);
	ioport_configure_pin(LF_MUX_EN, IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);

	ioport_configure_pin(LTC1407_CNV, IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW |IOPORT_INV_ENABLED);
	ioport_configure_pin(LTC1407_SDO, IOPORT_DIR_INPUT  | IOPORT_PULL_DOWN);
	ioport_configure_pin(LTC1407_CLK, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);

	LTC1407_cs.id = LTC1407_CNV;
	spi_master_init(SPI_LF_ADC);
	spi_master_setup_device(SPI_LF_ADC, &LTC1407_cs, SPI_MODE_1, 10000000, 0);
	spi_enable(SPI_LF_ADC);

}

void LF_mux_set(uint8_t mux)
{	uint32_t R_list[] = {316000,100000,31600,10000,3160,1000,316,100};
	
	if(mux > 0x07)
	{	ioport_set_pin_low(LF_MUX_EN);
		ref_R = 1;
	}
	else
	{	ioport_set_pin_high(LF_MUX_EN);
		ioport_set_pin_level(LF_MUX_A0,(bool)(mux & 0x01));
		ioport_set_pin_level(LF_MUX_A1,(bool)(mux & 0x02));
		ioport_set_pin_level(LF_MUX_A2,(bool)(mux & 0x04));
		ref_R = R_list[mux];
	}
}

void my_LTC1407_callback(void)
{
	// User code here to execute when a channel B compare match occurs
	if(irq_flg	== 0)
	{	spi_select_device(SPI_LF_ADC, &LTC1407_cs);
		spi_write_single(SPI_LF_ADC, 0);
		irq_flg	= 1;
		//tc_set_ccb_interrupt_level(PWM_CH, TC_INT_LVL_OFF);
	}

}

void read_LF(uint8_t verbose)
{
	uint8_t		d;
	uint8_t		ir_cnt = 0;
	uint32_t	l = 0;
	int16_t		l1=0,l2=0;
	int32_t		LF_RI=0,LF_RU=0,res_i;
	float		RI,RU, result;


	//tc_set_ccb_interrupt_level(PWM_CH, TC_INT_LVL_LO);
	while(ir_cnt <= 9)						// Mittelwertbildung aus 8 Werten, der erste wird verworfen
	{	irq_flg = 0;
	
		while(irq_flg == 0);				// warten auf IRQ,  dann wir in Interruptroutine Conv gesetzt
	
	
		//spi_write_single(SPI_LF_ADC, 0);
		while(!spi_is_tx_ok(SPI_LF_ADC));				//1. Byte Auslesen
		d= spi_get(SPI_LF_ADC);	
		l = (((uint32_t)(d)) << 24);

		spi_deselect_device(SPI_LF_ADC, &LTC1407_cs);	// rcksetzen des conv signales

		spi_write_single(SPI_LF_ADC, 0);
		while(!spi_is_tx_ok(SPI_LF_ADC));				//2. Byte Auslesen
		d= spi_get(SPI_LF_ADC);
		l = l | (((uint32_t)(d)) << 16);

		spi_write_single(SPI_LF_ADC, 0);
		while(!spi_is_tx_ok(SPI_LF_ADC));				//3. Byte Auslesen
		d= spi_get(SPI_LF_ADC);
		l = l | (((uint32_t)(d)) <<  8);

		spi_write_single(SPI_LF_ADC, 0);
		while(!spi_is_tx_ok(SPI_LF_ADC));				//4. Byte Auslesen
		d= spi_get(SPI_LF_ADC);
		l = l | (((uint32_t)(d)) <<  0);
		
		if(ir_cnt > 1)									// nach erstem Durchlauf
		{	l1=(int16_t)(l>>14) & 0xFFFC;					// Aufteilung der zwei Werte
			l2=(int16_t)(l<< 2) & 0xFFFC;

			if (l1 >0)								// wenn kein fehler Vorliegt Aufsummieren
			{	LF_RU = LF_RU + (int32_t)l1; // erster Kanal  ist Spannung  nicht invertiert
				LF_RI = LF_RI - (int32_t)l2; // zweiter Kanal ist Strom invertiert
			
				//printf("-- LF_Data: 0x%08lX :0x%04X: 0x%04X = %6d %6d", l, l1, l2,l1,l2);	
				if(verbose)	printf(": %6d %6d \n\r", l1, l2);	
				//printf("-- LF_Dataint: %8ld %8ld\n\r", LF_RI,LF_RU);
			}
			else 
			{	if(verbose)	printf("Fail: %6d %6d \n\r", l1, l2);
				ir_cnt--;
			}
			
		}	
		ir_cnt++;
	}

	res_i = (LF_RU * 5000) / (LF_RI >> 1);
	LF_RI = LF_RI /8;
	LF_RU = LF_RU /8;
	if(verbose)	printf("-- LF_Dataint: %8ld %8ld\n\r", LF_RU,LF_RI);
	RI = (float)LF_RI * 1.25 / 32768.0;
	RU = (float)LF_RU * 1.25 / 32768.0;
	result = (RU / RI) * (float)ref_R;
	
	if(verbose)	printf("-- LF_Data: %5.4fV , %5.4fA*R; Frq: = ", RU, RI);	
	//printf("%6ld", freq_i);
	if(verbose)	printf("Hz-- LF = ");	
	printf(", %6.1f ", result);
	if(verbose)	printf("Ohm ^ S:");
	
	result = RI * 1000000.0 / (RU * (float)ref_R);	//Rin kOhm fr mS
	//printf(",  %5.4f\n\r", result);	
	return;
}
