
#include <asf.h>
#include "LTC2600.h"
#include "ADS1262.h"
#include <math.h>
#include <util/delay_basic.h>

struct spi_device		LTC2600_cs;
volatile uint16_t		LTC2600_val;

void LTC2600_init(void)
{
	// SPI

	//ioport_configure_pin(SS_DAC,	IOPORT_DIR_INPUT | IOPORT_PULL_UP);						// SS
	ioport_configure_pin(MISO_DAC,	IOPORT_DIR_INPUT);										// MISO
	ioport_configure_pin(MOSI_DAC,	IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);					// MOSI
	ioport_configure_pin(SCK_DAC,	IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);					// SCK
	
	// Chip Selects
	ioport_configure_pin(LTC2600_CS, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);
	_delay_loop_2(500);
//	LTC2600_cs.id = LTC2600_CS;

//	spi_master_init(SPI_DAC);
//	spi_master_setup_device(SPI_DAC, &LTC2600_cs, SPI_MODE_0, 1000000, 0);
//	spi_enable(SPI_DAC);

	LTC2600_set(LTC2600_CH_ALL, LTC2600_CMD_WRITE, 0);
}

void LTC2600_set(uint8_t addr, uint8_t cmd, uint16_t val)
{
	uint8_t data,i ;
	uint32_t s;
	
	//spi_select_device(SPI_DAC, &LTC2600_cs);
	ioport_set_pin_low(LTC2600_CS);
	
	data = cmd | addr;

	//spi_write_single(SPI_DAC, data);
	//while(!spi_is_tx_ok(SPI_DAC));
	for(i=0; i<8; i++)
	{	s= 1<<(7-i);
		ioport_set_pin_level(MOSI_DAC,(bool)(data & s));
		_delay_loop_2(100);
		ioport_set_pin_high(SCK_DAC);
		_delay_loop_2(100);
		ioport_set_pin_low(SCK_DAC);
	}
	
	//spi_write_single(SPI_DAC, (uint8_t)((val&0xFF00)>>8));
	//while(!spi_is_tx_ok(SPI_DAC));
	//spi_write_single(SPI_DAC, (uint8_t)(val&0x00FF));
	//while(!spi_is_tx_ok(SPI_DAC));
	for(i=0; i<16; i++)
	{	s= 1<<(15-i);
		ioport_set_pin_level(MOSI_DAC,(bool)(val & s));
		_delay_loop_2(100);
		ioport_set_pin_high(SCK_DAC);
		_delay_loop_2(100);
		ioport_set_pin_low(SCK_DAC);
	}

	//spi_deselect_device(SPI_DAC, &LTC2600_cs);
	_delay_loop_2(100);
	ioport_set_pin_high(LTC2600_CS);
}

void PH_set_UDS(uint8_t ch, float val)
{
	uint16_t data;
	uint8_t	addr[]	= {2,0};//adc_addr[]	= {ADC_IMUX_UDS0, ADC_IMUX_UDS1};
	float	soll;
	
	if(ch == 0)
		soll = val + 0.0017 - 0.0159;
	else if(ch == 1)
		soll = val - 0.0011 - 0.0155;
	else
		soll = val;
		
	data = (uint16_t)(soll*65535/2.5);
	LTC2600_set(addr[ch], LTC2600_CMD_WRITE, data);
	
	//if(ch < 2)
	//{	_delay_loop_2(65535);
		//f_data = Get_ADC(adc_addr[ch],0,8);
		//delta = val - f_data;
		//printf("CH : %d ist: %7.6f; delta: %7.6f\n\r",ch, f_data, delta);
		//n=0;
		//while( (1 < (int)(fabs(delta)*10000)) && (n<20))
		//{	
			//soll += delta;	
			//data = (uint16_t)(soll*65535/2.5);
			//LTC2600_set(addr[ch], LTC2600_CMD_WRITE, data);
			//_delay_loop_2(65535);
			//f_data = Get_ADC(adc_addr[ch],0,8);
			//delta = val - f_data;
			//printf("CH : %d ist: %7.6f;soll: %7.6f; delta: %7.6f\n\r",ch, f_data, soll, delta);
			//n++;
		//}
	//}

}

void PH_set_ID(uint8_t ch, float val)
{
	uint8_t	addr[]	= {3,1};
	uint16_t data;
	float	soll;
	
	if(ch == 0)
		soll = val + 0.21 + 0.18;
	else if(ch == 1)
		soll = val + 0.56 + 0.06;
	else
		soll = val;
	
	data = (uint16_t)(soll*65535/500.0);
	LTC2600_set(addr[ch], LTC2600_CMD_WRITE, data);
}
