/*
 * LTC2600.h
 *
 * Created: 14.8.2015 
 *  Author: dallmann
 */ 


#ifndef LTC2600_H_
#define LTC2600_H_

#define LTC2600_CMD_WRITE			0x30
#define LTC2600_CMD_PD				0x40

#define LTC2600_CH_ALL				0x0F

// Chip Selects
#define LTC2600_CS			IOPORT_CREATE_PIN(PORTB, 0)
// SPI
#define MOSI_DAC			IOPORT_CREATE_PIN(PORTB, 1)
#define MISO_DAC			IOPORT_CREATE_PIN(PORTB, 2)
//#define SS_DAC				IOPORT_CREATE_PIN(PORTC, 4)
#define SCK_DAC				IOPORT_CREATE_PIN(PORTB, 3)
//#define SPI_DAC				&SPIC

#define DAC_pH_U1			0
#define DAC_pH_I1			1
#define DAC_pH_U0			2
#define DAC_pH_I0			3
#define DAC_T_UGS			4
#define DAC_T_I				5
#define DAC_clamp			6
//#define DAC_				7


/*! \brief Initializes the LTC2600 devices
 *
 *
 * \return Nothing
 */
void LTC2600_init(void);					// init LTC2600

void LTC2600_set(uint8_t addr, uint8_t cmd, uint16_t val);
void PH_set_UDS	(uint8_t ch, float val);
void PH_set_ID	(uint8_t ch, float val);

#endif /* LTC2600_H_ */