/**
 * \file
 *
 * \brief Empty user application template
 *
 */

/**
 * \mainpage User Application template doxygen documentation
 *
 * \par Empty user application template
 *
 * Bare minimum empty user application template
 *
 * \par Content
 *
 * -# Include the ASF header files (through asf.h)
 * -# "Insert system clock initialization code here" comment
 * -# Minimal main function that starts with a call to board_init()
 * -# "Insert application code here" comment
 *
 */

/*
 * Include header files for all drivers that have been imported from
 * Atmel Software Framework (ASF).
 */
 /**
 * Support and FAQ: visit <a href="http://www.atmel.com/design-support/">Atmel Support</a>
 */
#include <asf.h>
#include <conf_board.h>
#include "LTC2600.h"
#include "ADS1262.h"
#include "LF.h"
#include "temp.h"
#include <stdio.h>
#include <util/delay_basic.h>
#include "serial_packets.h"

/*void cb_version	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_name		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_serial		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_dac_channel	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_dac_mirror	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_volt_channel(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_volt_mirror	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_dac_hv		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_volt_hv		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_hv_enable	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_clear_dac	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_save_mirror	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_load_mirror	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_soft_reset	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
*/
void cb_pH_AP		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_pH_get		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_pt1000		(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);
void cb_ser_mode	(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);


#define	Rev_date	0x20160525
#define	Rev_num		0x10

#define LED_gruen		IOPORT_CREATE_PIN(PORTA, 4)
#define LED_rot			IOPORT_CREATE_PIN(PORTA, 5)
#define LED_rot_off		ioport_set_pin_high(LED_rot)
#define LED_rot_on		ioport_set_pin_low(LED_rot)
#define LED_gruen_off	ioport_set_pin_low(LED_gruen)
#define LED_gruen_on	ioport_set_pin_high(LED_gruen)


int32_t		second, minute;
float 		f_data, f_Id, f_Uds, f_Ugs, f_delta, ISFET_old, REFET_old, REF_old;
uint8_t		scan_now = 0, ser_mode = 0, ph;
const uint8_t		ch_LUT[] = {ADC_IMUX_ISFET, ADC_IMUX_REFET, ADC_IMUX_IS_REF_DIFF, ADC_IMUX_REF_POT, ADC_IMUX_UDS0, ADC_IMUX_UDS1};

int main (void)
{
	uint8_t		c, buf[16];
	//uint8_t		addr,i,j, status, mode,length;
	//uint16_t	i_data;
	int32_t		qdata;//wait_s;
	//char		str[10];

	ioport_configure_pin(LED_rot,	IOPORT_DIR_OUTPUT | IOPORT_INIT_LOW);	

	sysclk_init();
	irq_initialize_vectors();
	stdio_usb_init();

	cpu_irq_enable();
	//board_init();
	sleepmgr_init();


	LTC2600_init();
	ADS1262_init();
	PWM_init(200);
	LTC1407_init();
	//dac_init();
	TM_init();


	ioport_configure_pin(LED_gruen,	IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);


	
	PH_set_UDS(0,1.1);
	PH_set_UDS(1,1.1);
	PH_set_ID(0,385.0);
	PH_set_ID(1,385.0);
/*	
	register_packet_handler(CMD_pH_AP,	cb_pH_AP);
	register_packet_handler(CMD_pH_get, cb_pH_get);
	register_packet_handler(CMD_pt1000, cb_pt1000);
	register_packet_handler(CMD_ser_mode, cb_ser_mode);
*/

//	while(1) {}
// Insert application code here, after the board has been initialized.
	
	while(1)
	{
		if(udi_cdc_is_rx_ready()) //if(usart_rx_is_complete(USART_SERIAL))
		{	LED_rot_on;
			c = udi_cdc_getc();
			//udi_cdc_putc(c);
			if(ser_mode == 0)
				packet_state_machine(c);
			else
				serial_menue(c);
		}	//USB
		else  // wenn kein zeichen kommt
		{	if (second & 0x01)
				LED_rot_off;
			else
				LED_rot_on;
				
			if (scan_now == 1)
			{	if (qdata != second)
				{	qdata = second;
					printf("\r %4ld\r", second);
					
				}
				if (second >= 60)
				{	minute +=1;
					second = 0;
						printf("; %4ld; %2d; %2.1f; %5.1f;",minute, ph, f_Uds, f_Id);
						//buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
						//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
						f_data = Get_ADC(ADC_IMUX_ISFET,0,8);
						ISFET_old =  f_data;
						printf(" %7.6f;", f_data);
						f_data = Get_ADC(ADC_IMUX_REFET,0,8);
						printf(" %7.6f;", f_data);
						f_delta = (ISFET_old - f_data)* 1000.0;
						printf(" %6.3f;",f_delta);
						//buf[0] = ADC_MODE_Gain_4		| ADC_MODE_DR_0020;
						//ADS1262_REG((ADS1262_CMD_WREG	| ADS1262_REG_MODE2), 0, &buf[0]);
						f_data = Get_ADC(ADC_IMUX_IS_REF_DIFF,0,8);
						//printf(" %6.3f;", (f_data*250.0));
						printf(" %6.3f;", (f_data*1000.0));
						f_data = Get_ADC(ADC_IMUX_REF_POT,0,8);
						//printf(" %6.3f;\n\r", (f_data*250.0));
						printf(" %6.3f;\n\r", (f_data*1000.0));
				}
			}
		}	//else USB
		
		
	}	//while(1)
	
	
}

void console_open(bool enable)
{
	LED_rot_on;
	if(ser_mode == 1)
	{	printf_P(PSTR("\r\n\r\nATXMEGA MiMoX Testboard 2.0 Console %08lX , %04X\r\nPress 'm' for Menue"), Rev_date, Rev_num);
		printf_P(PSTR("\r\n> "));
	}	
	//usb_flag=1;
}

int cdc_getstring(char *buf, int maxlen)
{
	uint8_t val=0;
	uint8_t i=0;

	do
	{
		val = udi_cdc_getc();
		if(val==8)
		{
			if(i > 0)
			{
				i--;
				udi_cdc_putc(8);		// backspace
				udi_cdc_putc(32);		// space
				udi_cdc_putc(8);		// backspace
			}
		}
		else
		{
			if( (val > 31) && (val < 127) )
			{
				buf[i] = val;
				udi_cdc_putc(val);
				i++;
			}
		}
	}
	while( (val!=13) && (i < maxlen) );

	printf("\r\n");

	return i;
}

int32_t cdc_getint(uint8_t maxlen)
{
	char buf[maxlen];
	int32_t	 value=0;

	cdc_getstring(buf, maxlen);
	value = strtol(buf,NULL,0);
	
	return value;
}

float cdc_getfloat(int maxlen)
{
	char buf[maxlen];
	double	 value=0;

	cdc_getstring(buf, maxlen);
	value = strtod(buf,NULL);
	
	return (float)value;
}

void TM_init(void)//46Hz - 3MHz
{	uint32_t per;
	uint16_t irq_cnt;
	
	per		= 23437;//24000000 / 1024 / freq;
	irq_cnt = (per>>2);
	if(irq_cnt > 35)
	irq_cnt = irq_cnt - 35;
	else irq_cnt = 0;
	
	
	ioport_configure_pin(TM_PIN, IOPORT_DIR_OUTPUT | IOPORT_INIT_HIGH);

	
	tc_enable(TM_CH);
	tc_set_wgm(TM_CH, TC_WG_SS);
	tc_write_period(TM_CH,(uint16_t)per);
	tc_write_cc(TM_CH, TC_CCA, (uint16_t)per>>2);
	tc_enable_cc_channels(TM_CH,TC_CCAEN);
	tc_write_clock_source(TM_CH, TC_CLKSEL_DIV1024_gc);
	// fr Interrupt zum ADC start
	//pmic_init();			//Enable the interrupt controller
	//cpu_irq_enable();		//Enable interrupts

	tc_set_cca_interrupt_callback(TM_CH, my_sec_callback);
	tc_set_cca_interrupt_level(TM_CH, TC_INT_LVL_LO);
	//

}

void my_sec_callback(void)
{
	// User code here to execute when a channel B compare match occurs
	second += 1;
}


void cb_pH_AP(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send)
{
	uint8_t		ch=0;
	//uint16_t	dac_val=0;
	
	ch = HEXA_(recv->data[0]);
	sscanf(&recv->data[1],"%f", &f_data);
	
	if(ch<2)
	{	PH_set_UDS(ch,f_data);
	//	printf("set ch %d to %f V",ch,f_data);
	}
	else if(ch<4)
	{	PH_set_ID((ch & 0x01),f_data);
	//	printf("set ch %d to %f A",(ch & 0x01),f_data);
	}

	
}

void cb_pH_get(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send)
{
	//uint16_t chk=0;
	uint8_t		ch=0,buf[1],b_data;
	//const uint8_t		ch_LUT[] = {ADC_IMUX_ISFET,ADC_IMUX_REFET,ADC_IMUX_IS_REF_DIFF, ADC_IMUX_REF_POT,ADC_IMUX_UDS0,ADC_IMUX_UDS1};
	char		str[15],i;

	ch = HEXA_(recv->data[0]);

	buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
	ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
	buf[0] = ch_LUT[ch];
	ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);
	buf[0] = ch_LUT[ch];
	
	//printf("get ch %d 0x%X  0x%X ",(uint8_t)ch,buf[0],ch_LUT[ch]);
	f_data = Get_ADC(ch_LUT[ch],0,2);
	
	send->len	= sprintf (str, "%07.6f", f_data);
	
	send->data	= (char*)malloc(send->len * sizeof(char));
	//*send->data	= (uint32_t)f_data;
	for (i=0; i<send->len; i++)
	{	send->data[i] = (char)str[i];
		//chk += send->data[i];
	}
	//send->chk = (uint8_t)(chk & 0x00FF);

}

void cb_pt1000(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send)
{
	uint16_t	chk=0;
	char		str[15],i;
	
	f_data = Get_PT1000();
	////ioport_set_pin_low(DAC_CLR);
	//_delay_ms(100);
	//ioport_set_pin_high(DAC_CLR);
	//printf(" T_pt1000 = %5.3fC \n\r ", f_data);
	send->len	= sprintf (str, "%04.2f", f_data);
	//send->len	= 4;
	send->data	= (char*)malloc(send->len * sizeof(char));
	//*send->data	= (uint32_t)f_data;
	for (i=0; i<send->len; i++)
	{	send->data[i] = (char)str[i];
		chk += send->data[i];
	}
	//send->data[1] = (uint8_t)str[1];
	//send->data[2] = (uint8_t)str[2];
	//send->data[3] = (uint8_t)str[3];
	//chk += send->data[0];
	//chk += send->data[1];
	//chk += send->data[2];
	//chk += send->data[3];
	send->chk	= (uint8_t)(chk & 0x00FF);
}
void cb_ser_mode(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send)
{
	ser_mode = 1;
}

/*float Receive_float(int maxlen)
{
	uint32_t		w_data, expon = 1, num = 0;
	int	    buf[16], z = 0, data, i, m, dot = 255, sign=0;
	float	    f_data=0.0, f_expon;
	do
	{
		data = XUartLite_RecvByte(STDIN_BASEADDRESS);//getchar();
		if(data != Backspace)
		{	
		}
		else //wenn backspace
		{	if(z)
			{	z--;
				putchar(Backspace);
				putchar(Space);
				putchar(Backspace);
			}	}
		}
		while((data!=Enter) && (z<16));
		//	print("\r\n");


		if(z==0) return 0;
		i=0;
		expon=1;
		
		if(type==FLOAT)
		{	if(dot ==255) dot=z;
			i=dot;
			while(i)
			{	i--;
				w_data = buf[i];
				f_data += (w_data*expon);
				expon *=10;
				//xil_printf(" a%04X  0x%04X\r\n",expon, num);
			}
			
			i=dot;
			f_expon = 0.1;
			z--;
			while(i<z)
			{	i++;
				w_data = buf[i];
				f_data += ((float)w_data*f_expon);
				f_expon /=10;
				//xil_printf(" a%04X  0x%04X\r\n",expon, num);
			}
			if (sign) f_data =0-f_data;
			num = (*((DWORD*)(&f_data)));
			return num;
		}
	}*/