/*
 * serial_packets.c
 *
 * Created: 29.5.2012 14:32:47
 *  Author: grafe
 */ 

#include "asf.h"
#include "conf_board.h"
#include "serial_packets.h"

volatile uint8_t			pack_state=PACKET_STATE_START;
volatile SERIAL_PACKET_t	recv;
volatile PACKET_HANDLER_t	cb[256];
volatile uint8_t			cb_ctr=0;

void packet_state_machine(uint8_t c)
{
	static uint16_t cnt=0;
	static uint16_t chk=0;
	
	if (c == ENTER)
	{	//printf(" line end \r\n");
		pack_state = PACKET_STATE_START;
	}
	else
	{
		switch(pack_state)
		{
			case PACKET_STATE_START:
				if(c == PACKET_START_SIGN) 
				{
					//printf(" Start");
					pack_state = PACKET_STATE_CMD;	
					cnt = 0;
				}						
				break;
			case PACKET_STATE_CMD:
				if(cnt)
				{
					//printf(" CMD2");
					recv.cmd |= (uint16_t)c;
					pack_state = PACKET_STATE_LEN;	
					cnt = 0;
				}
				else
				{
					//printf(" CMD1");
					recv.cmd = (uint16_t)(c << 8);
					cnt++;
				}
				break;
			case PACKET_STATE_LEN:
				if(cnt)
				{
					recv.len |= (uint16_t)HEXA_(c);
					//printf(" LEN: %d",recv.len);
					if(recv.len > 0)
					{
						pack_state = PACKET_STATE_DATA;	
						if(recv.data != NULL) free(recv.data);
						recv.data = (uint8_t*)malloc(recv.len * sizeof(uint8_t));
						cnt = 0;
						chk = 0;
					}
					else
					{
						pack_state = PACKET_STATE_CHK;
						cnt = 0;
						chk = 0;	
					}						
				}
				else
				{
					//printf(" LEN1");
					recv.len = (uint16_t)(HEXA_(c) << 8);
					cnt++;
				}
				break;
			case PACKET_STATE_DATA:
				//printf(" Data");
				recv.data[cnt] = c;
				chk += recv.data[cnt++];
				if(cnt == recv.len)
				{	
					pack_state = PACKET_STATE_CHK;	
					cnt = 0;				
				}
				break;
			case PACKET_STATE_CHK:
				//printf(" CHK");
				chk += c;
				chk &= 0x00FF;
					
	//					if(chk == 0)
				process_packet();

				pack_state = PACKET_STATE_START;

				// ToDo: Error handling
				break;
			default: break;
		}
	}
	
}

void process_packet(void)
{
	SERIAL_PACKET_t send;
	uint16_t		i;
	
	send.cmd = recv.cmd;
	send.len = 0;
	send.data = 0;
	send.chk = 0;
	
	for(i=0; i<cb_ctr; i++)
	{
		if(cb[i].cmd == recv.cmd)
		{
			cb[i].cb(&recv, &send);
		}
	}

	udi_cdc_putc(ENTER);									// send checksum
	udi_cdc_putc(LF);									// send checksum
	udi_cdc_putc( (uint8_t)PACKET_START_SIGN);					// send praeamble

	udi_cdc_putc((uint8_t)((send.cmd & 0xFF00) >> 8));		// send cmd
	udi_cdc_putc((uint8_t)(send.cmd & 0x00FF));
	udi_cdc_putc((uint8_t)((send.len & 0xFF00) >> 8));		// send len
	udi_cdc_putc((uint8_t)(send.len & 0x00FF));
	
	for(i=0; i<send.len; i++) 
		udi_cdc_putc( send.data[i]);						// send data
	
//	udi_cdc_putc(send.chk);									// send checksum
	udi_cdc_putc(ENTER);									// send checksum
	udi_cdc_putc(LF);									// send checksum
	
	free(send.data);
}

void send_packet(SERIAL_PACKET_t *send)
{
	uint16_t		i;
		
//	udi_cdc_putc((uint8_t)PACKET_START_SIGN);					// send praeamble

//	udi_cdc_putc((uint8_t)((send->cmd & 0xFF00) >> 8));		// send cmd
//	udi_cdc_putc((uint8_t)(send->cmd & 0x00FF));
//	udi_cdc_putc((uint8_t)((send->len & 0xFF00) >> 8));		// send len
//	udi_cdc_putc((uint8_t)(send->len & 0x00FF));
	
	for(i=0; i<send->len; i++) udi_cdc_putc(send->data[i]);	// send data
	
//	udi_cdc_putc(send->chk);									// send checksum
	udi_cdc_putc(ENTER);									// send checksum
	udi_cdc_putc(LF);									// send checksum

}

int register_packet_handler(uint16_t cmd, pCallback handler)
{
	if(cb_ctr<256)
	{
		cb[cb_ctr].cmd = cmd;
		cb[cb_ctr].cb = handler;
		cb_ctr++;
		return 0;
	}
	else
	return 1;
}
