/*
 * serial_packets.h
 *
 * Created: 29.5.2012 14:32:30
 *  Author: grafe
 */ 



#ifndef SERIAL_PACKETS_H_
#define SERIAL_PACKETS_H_


#define VERSION_LOW		0x01
#define VERSION_HIGH	0x00

#define F_CPU	24000000UL
//#define DEBUG

#define HEXA_(c) ((c<0x3A)? c-0x30 : c-0x37)

#define PACKET_START_SIGN	0x44
#define ENTER				0x0D
#define LF					0x0A
#define BS					0x08
//#define SP					0x20

#define PACKET_STATE_START	0
#define PACKET_STATE_CMD	1
#define PACKET_STATE_LEN	2
#define PACKET_STATE_DATA	3
#define PACKET_STATE_CHK	4

#define CMD_pH_AP			'uu'
#define CMD_pH_get			'xx'
#define CMD_pt1000			'tt'
#define CMD_ser_mode		'sm'

typedef struct serial_packet_t
{
	uint16_t	cmd;
	uint16_t	len;
	uint8_t		*data;
	uint8_t		chk;
} SERIAL_PACKET_t;

typedef void (*pCallback)(volatile SERIAL_PACKET_t *recv, SERIAL_PACKET_t *send);

typedef struct packet_handler_t
{
	uint16_t	cmd;
	pCallback   cb;
} PACKET_HANDLER_t;

void	packet_state_machine(uint8_t c);
void	process_packet(void);
void	send_packet(SERIAL_PACKET_t *send);
int		register_packet_handler(uint16_t cmd, pCallback handler);

void	console_open(bool enable);
int		cdc_getstring(char *buf, int maxlen);
int32_t cdc_getint(uint8_t maxlen);
float	cdc_getfloat(int maxlen);
void	TM_init(void);
void	my_sec_callback(void);

void	serial_menue(uint8_t c);


#endif /* SERIAL_PACKETS_H_ */