/*
 * CFile1.c
 *
 * Created: 09.02.2016 16:29:35
 *  Author: dallmann
 */ 

#include <asf.h>
#include <conf_board.h>
#include "LTC2600.h"
#include "ADS1262.h"
#include "LF.h"
#include "temp.h"
#include "serial_packets.h"
#include <stdio.h>
#include <util/delay_basic.h>


extern int32_t		second, minute;
extern float 		f_data, f_Id, f_Uds, f_Ugs, f_delta, ISFET_old, REFET_old, REF_old;
extern uint8_t		scan_now, ser_mode, ph;




void serial_menue(uint8_t c)
{
	uint8_t		buf[16];
	uint8_t		addr,i,j, mode,length;
	uint16_t	i_data;
	int32_t		qdata;//wait_s;
	//char		str[10];

	switch(c)
	{
		case 13:
		case 'm':
				scan_now = 0;
				//printf_P(PSTR("\n\nATXMEGA MiMoX Testboard v1.0 Console %08lX , %04X\n"), Rev_date, Rev_num);
				printf("\nM: Menue\n");
				printf("=================================\n");
				printf("l - LF- Frequenz einstellen\n");
				printf("p - PH Channel\n");
				printf("s - Status\n");
				printf("t - Temperatur\n");
				printf("1 - Read LF Sensor\n");
				printf("2 - Read/Writhe ADC-Register\n");
				printf("3 - MOSFET Kennlinie\n");
				printf("4 - PN Kennlinie\n");
				printf("5 - PH Channel\n");
				printf("6 - PH Channel\n");
					
				break;

		case '0':
				scan_now = 0;
				printf(" Read DAC Kennlinie \n");
					
				buf[0] = ADC_IMUX_REF_POT;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);
				buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
					

				for(i_data = 0; i_data < 0xFFE0; i_data+=16)
				{
					LTC2600_set(LTC2600_CH_ALL, LTC2600_CMD_WRITE, i_data);
					f_Ugs = (float)i_data*2.5/65535.0;
					printf("%5d; %7.6f;",i_data, f_Ugs);
						
					f_data = Get_ADC(ADC_IMUX_REF_POT,0,4);
					f_Ugs  = (f_data - f_Ugs)*1000;
					printf("%7.6f; %4.3f\n",f_data, f_Ugs);
				}
				break;
	
		case '1':
				scan_now = 0;
				printf("read LF sensor Frequ Kennlinie \n");
				//printf("LF Referenzmux (0=100k, 1=10k, 2=1k, 3=100, n=off): ");
				//qdata = cdc_getint(1);
				//LF_mux_set((uint8_t) qdata);
				//printf("f inHz, R in Ohm, sigma in S \n");
				printf("F, R316k, R100k, R31k6, R10k, R3k16, R1k, R316, R100\n");
				qdata = 50;
				while(qdata <55000)
				{	PWM_init(qdata);
					printf("%6ld", qdata);
					for(i=0; i<8; i++)
					{	LF_mux_set((uint8_t) i);
						_delay_loop_2(65535);
						read_LF(0);
					}
					printf("\n");
					qdata += qdata;
				}
				break;

		case '2':
				printf(" ADS1262 Read= 1 or Write =2: ");
				mode = cdc_getint(1);
				printf(" Reg = ");
				addr = cdc_getint(5);
				printf(" lnge = ");
				length = cdc_getint(5);
				if(mode == 1)
				{	for(i=0; i<length; i++) buf[i] = 0;
					ADS1262_REG((ADS1262_CMD_RREG | addr), (length-1), &buf[0]);
					for(i=0; i<length; i++)
					printf(" 0x%02X,",(uint16_t)buf[i]);
				}
				else if(mode ==2)
				{
					for(i=0; i<length; i++)
					{	printf(" 0x");
						buf[i] = cdc_getint(3);
					}
					ADS1262_REG((ADS1262_CMD_WREG | addr), (length-1), &buf[0]);
				}
				printf("\n");
				break;

		case '3':
				printf(" T_MOSFET Kennlinie: ");
					
				buf[0] = ADC_IMUX_ISFET;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);

				//f_data = Get_PT1000();
				//printf(" T_pt1000 = %5.3fC \n", f_data);

				//printf(" Ugs: ");
				//f_data = cdc_getfloat(4);
				//i_data = (uint16_t)(f_data*4095.0/5.0);
				//set_dac(DAC_T_Ugs0,i_data);
				//printf(" Id: ");
				//f_data = cdc_getfloat(4);
				//i_data = (uint16_t)(f_data*4095.0/250.0);
				//set_dac(DAC_T_I0,i_data);
					
					
				printf(" Ugs in V;Uds in V bei Id:\n");
				for(i = 1; i <= 10; i++)
				{	f_Id = 10.0 * (float)i;
					printf(" %5.1f;", f_Id);
				}
				printf("\n");
				for(i = 13; i <= 50; i++)
				{
					f_Ugs = 0.1 * (float)i;
					i_data = (uint16_t)(f_Ugs*4095.0/5.0);
					//set_dac(DAC_T_Ugs0,i_data);
					LTC2600_set(DAC_T_UGS, LTC2600_CMD_WRITE, i_data);
					printf(" %2.1f;", f_Ugs);
						
					for(j = 1; j <= 10; j++)
					{
						f_Id = 10.0 * (float)j;
						i_data = (uint16_t)(f_Id*4095.0/250.0);
						//set_dac(DAC_T_I0, i_data);
						LTC2600_set(DAC_T_I, LTC2600_CMD_WRITE, i_data);
						_delay_loop_2(65535);
						f_data = Get_ADC(ADC_IMUX_T_MOS,0,1);
						f_data = Get_ADC(ADC_IMUX_T_MOS,0,1);
						printf(" %7.6f;", f_data);
					}
					printf("\n");
				}
				break;

		case '4':
				printf(" T_PN Kennlinie: ");
					
				buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
				//buf[0] = ADC_IMUX_ISFET;
				//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);

				//f_data = Get_PT1000();
				//printf(" T_pt1000 = %5.3fC \n", f_data);

				//printf(" Id: ");
				//f_data = cdc_getfloat(4);
				//data = (uint16_t)(f_data*4095.0/250.0);
				//set_dac(DAC_T_I1,data);
					
					
				printf(" U in V bei ID;");
				//for(i = 1; i <= 32; i=i+i)
				//{	f_Id = 10.0 * (float)i;
				//	printf(" %5.1f;", f_Id);
				//}
				printf("\n");
				for(i = 1; i <= 32; i++)
				{
					f_Id = 10.0 * (float)i;
					PH_set_ID(0,f_Id);
					//i_data = (uint16_t)(f_Id*4095.0/250.0);
					//set_dac(DAC_T_I1, i_data);
					_delay_loop_2(65535);
					f_data = Get_ADC(ADC_IMUX_ISFET,0,2);
					printf(" %7.6f;", f_data);
					//f_data = Get_ADC(ADC_IMUX_T_PN,0,1);
					//f_data = Get_ADC(ADC_IMUX_T_PN,0,1);
					//printf(" %7.6f;", f_data);
				}
				for(i = 1; i <= 32; i++)
				{
					f_Id = 10.0 * (float)i;
					PH_set_ID(1,f_Id);
					_delay_loop_2(65535);
					f_data = Get_ADC(ADC_IMUX_REFET,0,2);
					printf(" %7.6f;", f_data);
					
				}
				printf(" \n");
				break;
					
		case '5':
				printf(" ISFET-P Kennlinie: ");
					
				buf[0] = ADC_IMUX_ISFET;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);
					
				f_Id = 1.5;
				printf(" Uds in V;Ugs in V bei Id:\n");
				for(i = 1; i <= 8; i++)
				{	f_Id = f_Id * 2.0;
					printf(" %5.1f;", f_Id);
				}
				printf("\n");
				for(i = 5; i <= 25; i++)
				{
					f_Uds = 0.1 * (float)i;
					PH_set_UDS(0,f_Uds);
					PH_set_UDS(1,f_Uds);
					printf(" %2.1f;", f_Uds);
						
					f_Id = 1.5;
					for(j = 1; j <= 8; j++)
					{
						f_Id = f_Id * 2.0;
						PH_set_ID(0,f_Id);
						PH_set_ID(1,f_Id);
						_delay_loop_2(65535);
						f_data = Get_ADC(ADC_IMUX_ISFET,0,1);
						printf(" %7.6f;", f_data);
					}
					printf("\n");
				}
				break;

		case '6':
				printf(" ADC-Set 2400 Sps , Gain Bypass \n");
				buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_2400;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
				second = 58;
				break;
					
		case '7':
				printf(" ADC-Set 20 Sps , Gain Bypass \n");
				buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
				second = 58;
				break;
		case '8':
				printf(" ADC-Set 20 Sps , ADC_MODE_Gain_1 \n");
				buf[0] = ADC_MODE_Gain_1		| ADC_MODE_DR_0020;
				ADS1262_REG((ADS1262_CMD_WREG	| ADS1262_REG_MODE2), 0, &buf[0]);
				second = 58;
				break;
		case '9':
				printf(" ADC-Set 20 Sps , ADC_MODE_Gain_32 \n");
				buf[0] = ADC_MODE_Gain_32		| ADC_MODE_DR_0020;
				ADS1262_REG((ADS1262_CMD_WREG	| ADS1262_REG_MODE2), 0, &buf[0]);
				second = 58;
				break;

		//case '8':
				//printf(" Zeit messung \n");
				//second = 0;
				//buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0002;
				//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
					//
				//buf[0] = ADC_IMUX_ISFET;
				//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);
				//f_Uds = 1.1;
				//PH_set_UDS(0,f_Uds);
				//PH_set_UDS(1,f_Uds);
				//f_Id = 384.0;
				//PH_set_ID(0,f_Id);
				//PH_set_ID(1,f_Id);
				//qdata = second;
				//while(second < 300)
				//{	if (qdata != second)
					//{	qdata = second;
						//f_data = Get_ADC(ADC_IMUX_ISFET,0,1);
						//printf("%3ld; %7.6f\n",second, f_data);
					//}
				//}
				//f_Uds = 1.9;
				//PH_set_UDS(0,f_Uds);
				//PH_set_UDS(1,f_Uds);
				//while(second < 600)
				//{	if (qdata != second)
					//{	qdata = second;
						//f_data = Get_ADC(ADC_IMUX_ISFET,0,1);
						//printf("%ld; %7.6f\n",second, f_data);
					//}
				//}
				//f_Id = 192.0;
				//PH_set_ID(0,f_Id);
				//PH_set_ID(1,f_Id);
				//while(second < 900)
				//{	if (qdata != second)
					//{	qdata = second;
						//f_data = Get_ADC(ADC_IMUX_ISFET,0,1);
						//printf("%ld; %7.6f\n",second, f_data);
					//}
				//}
					
				//break;
		//case '9':
				//tc_disable(PWM_CH);
				//printf("\n PH Kennlinie: pH-Puffer: ");
				//ph = cdc_getint(3);
				//printf("\n Zeitpuffer in s: ");
				//wait_s = cdc_getint(6);
				//buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0002;
				//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
		//
				//buf[0] = ADC_IMUX_ISFET;
				//ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_INMUX), 0, &buf[0]);
				//f_Id = 1.5;
				//printf("\n ; Puffer; Uds in V; Id in A; UGs ISFET in V; REFET in V; Diff in mV; delta in mV; REF in mV\n");
				//for(i = 11; i <= 11; i+=2)
				//{
					//f_Uds = 0.1 * (float)i;
					//PH_set_UDS(0,f_Uds);
					//PH_set_UDS(1,f_Uds);
			//
					//f_Id = 24.0;
					//for(j = 1; j <= 2; j++)
					//{
						//f_Id = f_Id * 4.0;
						//PH_set_ID(0,f_Id);
						//PH_set_ID(1,f_Id);
				//
						//second = 0;
						//while(second < wait_s)
						//if (qdata != second)
						//{	qdata = second;
							//printf(" %4ld\r", second);
						//}
						////_delay_loop_2(65535);
						//printf(" %2d; %2.1f; %5.1f;", ph, f_Uds, f_Id);
						//f_data = Get_ADC(ADC_IMUX_ISFET,0,1);
						//printf(" %7.6f;", f_data);
						//f_data = Get_ADC(ADC_IMUX_REFET,0,1);
						//printf(" %7.6f;", f_data);
						//f_data = Get_ADC(ADC_IMUX_IS_REF_DIFF,0,1);
						//printf(" %7.6f;\n", f_data);
					//}
				//}
				//break;
							
		case 's':
				//ADS1262_cmd(ADS1262_CMD_START);
				f_data = Get_ADC(ADC_IMUX_TEMP_MON,1,1);
				printf(" Utemp: %4.3fV  ", f_data);
				f_data = (f_data - 0.1224)/0.00042 + 25;
				printf(" = %5.3fC \n", f_data);
				f_data = Get_ADC(ADC_IMUX_AVCC_MON,1,1);
				printf(" Uavcc: %4.3fV \n", (4.0*f_data));
				f_data = Get_ADC(ADC_IMUX_DVCC_MON,1,1);
				printf(" Udvcc: %4.3fV \n", (4.0*f_data));
				//ADS1262_cmd(ADS1262_CMD_START);
				//ADS1262_cmd(ADS1262_CMD_STOP);
				//LTC2600_set(1, LTC2600_CMD_WRITE, 0x5AA5);
				break;

		case 'l':
				printf("\n LF Frequenz: ");
				qdata = cdc_getint(6);
				PWM_init(qdata);
				printf("LF Referenzmux (0=100k, 1=10k, 2=1k, 3=100, n=off): ");
				qdata = cdc_getint(1);
				LF_mux_set((uint8_t) qdata);
				_delay_loop_2(65535);
				printf("read LF sensor\n");
				read_LF(1);
				break;
					
		case 'k':
				break;

		case 'p':
				scan_now = 0;
//				buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0002;
//				ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);
					
				printf("\n pH-Puffer: ");
				ph = cdc_getint(3);
					
				printf("Enter Drain-Currend (A): ");
				f_Id = cdc_getfloat(8);
				PH_set_ID(0,f_Id);
				PH_set_ID(1,f_Id);
					
				printf("Enter Drain-Source Voltage(V): ");
				f_Uds = cdc_getfloat(8);
				PH_set_UDS(0,f_Uds);
				PH_set_UDS(1,f_Uds);
					
				printf("New Start? ");
				c = udi_cdc_getc();
				//printf("_%X_",c);
				if (c == 'y')
				{	second = 58;
					minute = 0;
					printf("\n ; Zeit in min; Puffer; Uds in V; Id in A; UGs ISFET in V; REFET in V; Diff in mV; delta in mV; REF in mV\n");
				}
				scan_now = 1;
					
				//f_data = Get_ADC(ADC_IMUX_ISFET,1);
				//printf_P(PSTR(" U_GS_ISFET: %fV \n"), f_data);
				//f_data = Get_ADC(ADC_IMUX_REFET,1);
				//printf_P(PSTR(" U_GS_REFET: %fV \n"), f_data);
				//f_data = Get_ADC(ADC_IMUX_IS_REF_DIFF,1);
				//printf_P(PSTR(" U_GS_IS/RE: %fV \n"), f_data);
				break;

		case 'r':
					i = scan_now;
					scan_now = 0;
					printf("ISFET Realtime\n");
					
					buf[0] = ADC_MODE_Gain_bypass | ADC_MODE_DR_0020;
					ADS1262_REG((ADS1262_CMD_WREG | ADS1262_REG_MODE2), 0, &buf[0]);

					while(!udi_cdc_is_rx_ready())
					{
						f_data = Get_ADC(ADC_IMUX_ISFET,0,2);
						ISFET_old =  f_data;
						printf("\r %7.6f;", f_data);
						f_data = Get_ADC(ADC_IMUX_REFET,0,2);
						printf(" %7.6f;", f_data);
						f_delta = (ISFET_old - f_data)* 1000.0;
						printf(" %6.3f;",f_delta);
						f_data = Get_ADC(ADC_IMUX_IS_REF_DIFF,0,2);
						printf(" %6.3f;", (f_data*1000.0));
						f_data = Get_ADC(ADC_IMUX_REF_POT,0,2);
						printf(" %6.3f;", (f_data*1000.0));
						f_data = Get_ADC(ADC_IMUX_UDS0,0,2);
						printf(" %7.6f;", f_data);
						f_data = Get_ADC(ADC_IMUX_UDS1,0,2);
						printf(" %7.6f\r", f_data);
					}
					udi_cdc_getc();
					scan_now = i;
					break;
					
			
		case 't':
					f_data = Get_PT1000();
					printf(" T_pt1000 = %5.3fC \n", f_data);
					break;

		case 'x':	ser_mode = 0;
					scan_now = 0;
					break;
	
		case 32:	scan_now = 0;
					break;
		default:
					//scan_now = 0;
					printf_P(PSTR("\nNot Implemented!\n"));
					break;
	}
	printf_P(PSTR("\n> "));

}