/*
 * Mega_LOL.c
 *
 * Created: 24.07.2016 
 * 
 * 
 * Ein einfacher Test fr komplexere Soundausgabe am Atmega328P
 * 
 * orginal von Ulrich Radig, -> portiert auf Atmega328P
 * "Dazu habe ich einen Lautsprecher einfach an einen Port des C
 *  angeschlossen, genauer gesagt am OC0 wegen der PWM Erzeugung. Dabei gebe
 *  ich mit Hilfe des Timer1 immer ein neues PWM Signal auf den Ausgang.
 *  Aufgrund des geringen Speichers eines ATMega32 kommt man so auf ca.
 *  4sec. bei einer Sampelrate von 8000Hz bei 8Bit."
 *
 * Vorschlag:
 * wenn man die Daten auf einer SD karte htte 
 * geht es bestimmt besser, dann brauch man die Daten nur per Interrupt auslesen und an die PWM geben !
 *
 * Erklrung:
 * eine schnelllaufende PWM, wird vom einem Interrupt stndig mit neuen Werten gefttert
 * Es kommt eine kleine Sprachansage herraus
 * 
 * 
 * /////////////////////////////////////////////////////////////////////
 * !!!			Nachteile 			!!!
 * es wird fr dieses kurze Sample 15kbyte Speicher im Flasch belegt !!!
 * -> somit ist der Halbe Flash vom Arduino schon voll !!!
 * 
 */ 

#define Arduino_UNO_PIN_13	0x20		// Arduino UNO PIN 13, PortB.5
#define F_CPU	16000000UL	
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include "sound.h"

volatile uint16_t LED_counter=0;
volatile uint16_t bytecounter = 0;
PGM_P test = sound;
#define SOUNDRATE	F_CPU/64/8000


//############################################################################
//Timer1 Interrupt, alle 128us wird eine ISR ausgelst
ISR (TIMER1_OVF_vect)
//############################################################################
{
	bytecounter++;
	OCR0A = pgm_read_byte(test++);
	//TCNT1 = 65535 - (F_CPU/64/8000);		// 16000000/64/8000 = 31 ; 65535-31=65504
	TCNT1 = 65535 - SOUNDRATE;	
	
	if(bytecounter>soundbytes)
	{
		bytecounter = 0;
		test = sound;
	}
	
	// Ein einfacher LED Test, um zu sehen, das der IRQ funktioniert !
	// 3906 * 128us = ms
	// 7812 * 128us=1000ms
	LED_counter++;
	if (LED_counter==3906)	PORTB|=Arduino_UNO_PIN_13;		// Pin setzen
	if (LED_counter==7812)	LED_counter=0,PORTB&=~Arduino_UNO_PIN_13;	// Pin lschen
}


//############################################################################
//Hauptprogramm
int main (void)
//############################################################################
{
	// PWM Kanle
	// PortD.5 -> OC0B		-> Arduino UNO PIN 5
	
	// PortD.6 -> OC0A		-> Arduino UNO PIN 6 
	
	// PortB.1 -> OC1A		-> Arduino UNO PIN 9
	// PortB.2 -> OC1B		-> Arduino UNO PIN 10
	// PortB.3 -> OC2A		-> Arduino UNO PIN 11
	
	// DDRB -> alles Output
	DDRB = 0xFF;			//(1<<3);					// setze PortB.3 auf Output
	// DDRD -> alles Output
	DDRD = 0xFF;
	

	//Set TIMER0 (PWM OC0 Pin)
	
	// Timer 0 starten mit...
	TCCR0A|=(1<<WGM01|1<<WGM00);		//Fast PWM mit Timer 0 an PIN OC0A
	//TCCR0B|=(1<<WGM02);
	
	// OCR0A PIN Configurieren im FAST PWM MODE, s. 106, normal Mode
	TCCR0A|=(1<<COM0A1);			// clear PIN OC0A on Match, set PIN_OC0A at BOTTOM(0x00)
	// also PIN_OC0A hat 1 bei 0x00, PWM zhlt bis 0xFF, und wenn TIMER_0 = OCR0A -> PIN_OC0A lschen
	// oder Inverting Mode
	//TCCR0A|=(1<<COM0A0|1<<COM0A1);
	
	// Timer 0 Prescaler, wird gesetzt im Register TCCR0B
	TCCR0B|=(1<<CS00);				//Prescaler 1:1 -> 16MHz/256 =62,5kHz PWM (alle 0,0625us ein Impuls zur PWM, 0,..1,...,2... usw.)
	// fr eine komplette PWM bentigt der Atmega (16 Takte/1us /256 PWM Stufen) = 16us 
	//TCCR0A |= (1<<WGM01|1<<COM0A0|1<<CS00);
	// Dyty Cyle = 50%
	OCR0A = 128;
	
	//Set TIMER1
	TIMSK1 |= (1 << TOIE1);
	//Prescaler 64
	TCCR1B = (1<<CS10 | 1<<CS11);
	//SYSCLK define in usart.h, -> 16MHz
	//TCNT1 = 65535 - (F_CPU/64/8000);		//16MHz/64/8000 = 250kHz/8000 = 31 (31,25)
	TCNT1 = 65535 - SOUNDRATE;	
	// Timer luft mit 16MHz/64 = 250kHz
	// 16Takte/1us /64 = 1 Takte in 4us -> 32 Takte bis Overflow von Timer_1 ergibt (4us * 32Takte = 128us)
	// somit ergibt es ein berlauf bei 31 Takten, nach 128us
	// 16us die PWM * 8bit = 128us fr Timer_1 IRQ !
	
	//Globale Interrupts Enable
	sei();
	
	while(1)
	{
		// do something...
	}
}

